/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.content.resources;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.exmo.exmodifier.Exmodifier;
import net.exmo.exmodifier.content.modifier.ModifierHandle;
import net.exmo.exmodifier.content.resources.ConfigPackInfo;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class ZipHandle {
    public static final Path ZIP_FILE_DIR = FMLPaths.CONFIGDIR.get().resolve("exmo/packs");
    public static Map<String, ConfigPackInfo> readConfigFromZipFile = new HashMap<String, ConfigPackInfo>();

    public static void copyPacks(Minecraft p_100000_, List<Path> p_100001_, Path p_100002_) {
        MutableBoolean mutableboolean = new MutableBoolean();
        p_100001_.forEach(p_170009_ -> {
            try (Stream<Path> stream = Files.walk(p_170009_, new FileVisitOption[0]);){
                stream.forEach(p_170005_ -> {
                    try {
                        Util.m_137563_((Path)p_170009_.getParent(), (Path)p_100002_, (Path)p_170005_);
                    }
                    catch (IOException ioexception1) {
                        Exmodifier.LOGGER.Logger.warn("Failed to copy exmo zip config file  from {} to {}", new Object[]{p_170005_, p_100002_, ioexception1});
                        mutableboolean.setTrue();
                    }
                });
            }
            catch (IOException var8) {
                Exmodifier.LOGGER.Logger.warn("Failed to copy exmo zip config file from {} to {}", p_170009_, (Object)p_100002_);
                mutableboolean.setTrue();
            }
        });
        if (mutableboolean.isTrue()) {
            SystemToast.m_94875_((Minecraft)p_100000_, (String)p_100002_.toString());
        }
    }

    public static ZipFunction init() throws IOException {
        readConfigFromZipFile.clear();
        if (!Files.exists(ZIP_FILE_DIR, new LinkOption[0])) {
            Files.createDirectories(ZIP_FILE_DIR, new FileAttribute[0]);
            return new ZipFunction();
        }
        ZipFunction zipFunction = new ZipFunction();
        Files.list(ZIP_FILE_DIR).forEach(path -> {
            if (path.toString().endsWith(".zip") || path.toString().endsWith(".jar") || path.toString().endsWith(".7z") || path.toString().endsWith(".rar") || path.toString().endsWith(".gz")) {
                try (ZipFile zipFile = new ZipFile(path.toFile());){
                    ZipEntry configEntry = zipFile.getEntry("pack.mcmeta");
                    if (configEntry != null) {
                        try (InputStream inputStream = zipFile.getInputStream(configEntry);){
                            String json = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                            JsonObject jsonObject = (JsonObject)Exmodifier.GSON.fromJson(json, JsonObject.class);
                            ConfigPackInfo config = ConfigPackInfo.exSerialize.fromJsonSingle(jsonObject);
                            zipFunction.configPacks().add(config);
                        }
                        catch (Exception e) {
                            Exmodifier.LOGGER.error("Failed to parse config.json", e);
                        }
                    }
                    ModifierHandle.readConfigFromZipFile(zipFile, zipFunction);
                }
                catch (IOException e) {
                    Exmodifier.LOGGER.error("IOException:", e);
                }
            }
        });
        return zipFunction;
    }

    public record ZipFunction(List<Runnable> elementDefault, List<Runnable> defaultEntry, List<ConfigPackInfo> configPacks, List<Runnable> suit) {
        public ZipFunction() {
            this(new ArrayList<Runnable>(), new ArrayList<Runnable>(), new ArrayList<ConfigPackInfo>(), new ArrayList<Runnable>());
        }
    }
}

