/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.content.slot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.exmo.exmodifier.Exmodifier;
import net.exmo.exmodifier.content.helper.ModifierEntryHelper;
import net.exmo.exmodifier.content.helper.ModifierSlotHelper;
import net.exmo.exmodifier.content.modifier.ModifierHandle;
import net.exmo.exmodifier.content.modifier.ModifierInstant;
import net.exmo.exmodifier.content.selected.BaseItemSelected;
import net.exmo.exmodifier.content.slot.ModifierSlot;
import net.exmo.exmodifier.content.slot.UnLockSlotItem;
import net.exmo.exmodifier.events.ExRegisterSlotEvent;
import net.exmo.exmodifier.events.ExRegisterUnLockSlotEvent;
import net.exmo.exmodifier.util.StringToIntConverter;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ModifierSlotHandle {
    public static Map<ResourceLocation, ModifierSlot> registerSlots = new HashMap<ResourceLocation, ModifierSlot>();
    public static List<UnLockSlotItem> unLockSlotItems = new ArrayList<UnLockSlotItem>();

    public static void registerUnLockSlotItem(UnLockSlotItem unLockSlotItem) {
        unLockSlotItems.add(unLockSlotItem);
        BaseItemSelected.IDS.put(StringToIntConverter.stringToInt(unLockSlotItem.item.toString()), unLockSlotItem);
        Exmodifier.LOGGER.debug("Registry UnLockSlotItem: " + unLockSlotItem.item.m_5524_());
    }

    public static void registerSlot(ResourceLocation id, ModifierSlot modifierSlot) {
        int id1 = StringToIntConverter.stringToInt(id.toString());
        modifierSlot.setId(id1);
        registerSlots.put(id, modifierSlot);
        BaseItemSelected.IDS.put(id1, modifierSlot);
        Exmodifier.LOGGER.debug("Registry ModifierSlot: " + String.valueOf(id));
    }

    public static ModifierSlot getSlot(ResourceLocation id) {
        return registerSlots.get(id);
    }

    public static ResourceLocation getKey(ModifierSlot modifierSlot) {
        if (modifierSlot == null) {
            return null;
        }
        for (Map.Entry<ResourceLocation, ModifierSlot> entry : registerSlots.entrySet()) {
            if (entry.getValue().getId() != modifierSlot.getId()) continue;
            return entry.getKey();
        }
        return null;
    }

    public static List<Component> getTooltip(ItemStack stack, Player player) {
        ModifierSlotHelper slotHelper = ModifierSlotHelper.of(stack);
        ModifierEntryHelper modifierHelper = ModifierEntryHelper.of(stack);
        List<ModifierInstant> moList = modifierHelper.getModifierEntries();
        List<String> slots = slotHelper.getSlotListId();
        if (slotHelper.validList()) {
            int i;
            ArrayList<Component> tooltip = new ArrayList<Component>();
            for (i = 0; i < moList.size(); ++i) {
                ModifierInstant entry = moList.get(i);
                if (!entry.getSlot().isPresent()) continue;
                String id = entry.getSlot().get();
                slots.remove(id);
                if (!slotHelper.containSlot(id)) continue;
                tooltip.add((Component)Component.m_237115_((String)("modifier.slot." + id)));
                tooltip.addAll(ModifierHandle.CommonEvent.generateEntryTooltip(entry, player, stack, true));
                tooltip.add((Component)Component.m_237115_((String)"null"));
            }
            for (i = 0; i < slots.size(); ++i) {
                String slot = slots.get(i);
                tooltip.add((Component)Component.m_237115_((String)("modifier.slot." + slot)));
                tooltip.add((Component)Component.m_237115_((String)"modifier.slot.null"));
                tooltip.add((Component)Component.m_237115_((String)"null"));
            }
            tooltip.remove(tooltip.size() - 1);
            return tooltip;
        }
        return new ArrayList<Component>();
    }

    public static void reload() {
        ModifierSlotHandle.ExampleSlotRegister();
        ExRegisterUnLockSlotEvent event = new ExRegisterUnLockSlotEvent();
        ModifierSlotHandle.ExampleUnLockItemRegister(event);
        MinecraftForge.EVENT_BUS.post((Event)new ExRegisterSlotEvent());
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    @SubscribeEvent
    public static void registerSlot(ExRegisterSlotEvent event) {
    }

    @SubscribeEvent
    public static void registerSlot(ExRegisterUnLockSlotEvent event) {
    }

    private static void ExampleSlotRegister() {
        ModifierSlotHandle.registerSlot(new ResourceLocation("exmodifier", "front"), new ModifierSlot());
        ModifierSlotHandle.registerSlot(new ResourceLocation("exmodifier", "centre"), new ModifierSlot());
        ModifierSlotHandle.registerSlot(new ResourceLocation("exmodifier", "after"), new ModifierSlot());
    }

    private static void ExampleUnLockItemRegister(ExRegisterUnLockSlotEvent event) {
        event.registerUnLockSlot(new UnLockSlotItem(Items.f_42681_, 0).setCostExp(3.0).setNeedCount(2).setSlots(List.of("exmodifier:front")));
        event.registerUnLockSlot(new UnLockSlotItem(Items.f_42678_, 0).setCostExp(3.0).setNeedCount(2).setSlots(List.of("exmodifier:centre")));
        event.registerUnLockSlot(new UnLockSlotItem(Items.f_42679_, 0).setCostExp(3.0).setNeedCount(2).setSlots(List.of("exmodifier:after")));
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
    }
}

