/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.content.suit;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.exmo.exmodifier.Exmodifier;
import net.exmo.exmodifier.content.modifier.ModifierEntry;
import net.exmo.exmodifier.content.type.ItemType;
import net.exmo.exmodifier.util.exSerialize.ExSerialize;
import net.exmo.exmodifier.util.gether.AttriGetherNormal;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.effect.MobEffectInstance;

public class ExSuit {
    public static ExSerialize<ExSuit> ExSer = ExSerialize.create(ExSuit::new).addStringField("id", ExSuit::getId, (obj, id) -> {
        obj.id = id;
    }).addStringField("type", e -> e.type != null ? e.type.name() : "", (e, s) -> {
        e.type = ModifierEntry.StringToType(s);
    }).addStringField("LocalDescription", ExSuit::getLocalDescription, (obj, desc) -> {
        obj.LocalDescription = desc;
    }).addBooleanField("visible", ExSuit::isVisible, (obj, visible) -> {
        obj.visible = visible;
    }).addIntField("MaxLevel", ExSuit::getMaxLevel, ExSuit::setMaxLevel).addBooleanField("newTooltipPage", ExSuit::isNewTooltipPage, ExSuit::setNewTooltipPage).addBooleanField("hasMobEffect", ExSuit::isHasMobEffect, (obj, hasMobEffect) -> {
        obj.hasMobEffect = hasMobEffect;
    }).addIntStringMapField("effectLocalDescription", ExSuit::getEffectLocalDescription, ExSuit::setEffectLocalDescription).addIntStringMapField("commands", exSuit -> exSuit.getCommands().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> String.join((CharSequence)"=-;-=", (Iterable)e.getValue()))), (exSuit, commands) -> {
        exSuit.commands = commands.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Arrays.asList(((String)e.getValue()).split("=-;-="))));
    }).addIntStringMapField("triggers", exSuit -> exSuit.getTriggers().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Trigger)((Object)((Object)((Object)e.getValue())))).toString())), (exSuit, triggers) -> {
        exSuit.triggers = triggers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ExSuit.StringToTrigger((String)e.getValue())));
    }).addIntStringMapField("attriGether", exSuit -> exSuit.getAttriGether().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).stream().map(ag -> ag.toNbt().toString()).collect(Collectors.joining(";")))), (exSuit, attriGethers) -> {
        exSuit.attriGether = attriGethers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Arrays.stream(((String)e.getValue()).split(";")).map(a -> {
            try {
                return AttriGetherNormal.fromNbt(TagParser.m_129359_((String)a));
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        }).collect(Collectors.toList())));
    }).addStringMapField("setting", ExSuit::getSetting, ExSuit::setSetting).addIntStringMapField("effect", exSuit -> exSuit.getEffect().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).stream().map(ExSuit::getEffectString).collect(Collectors.joining(";")))), (exSuit, attriGethers) -> {
        exSuit.effect = attriGethers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Arrays.stream(((String)e.getValue()).split(";")).map(ExSuit::getEffectFromString).collect(Collectors.toList())));
    });
    public Map<String, String> setting = new HashMap<String, String>();
    public boolean hasMobEffect = false;
    public ItemType type;
    public String id;
    public boolean newTooltipPage;
    public String LocalDescription = "";
    public Map<Integer, String> effectLocalDescription = new HashMap<Integer, String>();
    public Map<Integer, List<String>> commands = new HashMap<Integer, List<String>>();
    public int MaxLevel;
    public boolean visible = true;
    public static final Trigger MainTrigger = Trigger.TICK;
    public Map<Integer, Trigger> triggers = new HashMap<Integer, Trigger>();
    public Map<Integer, List<AttriGetherNormal>> attriGether = new HashMap<Integer, List<AttriGetherNormal>>();
    private Map<Integer, List<MobEffectInstance>> effect = new HashMap<Integer, List<MobEffectInstance>>();
    public Map<String, Float> itemDamage = new HashMap<String, Float>();

    public boolean isNewTooltipPage() {
        return this.newTooltipPage;
    }

    public ExSuit setNewTooltipPage(boolean newTooltipPage) {
        this.newTooltipPage = newTooltipPage;
        return this;
    }

    public String getLocalDescription() {
        return this.LocalDescription;
    }

    public ExSuit setLocalDescription(String localDescription) {
        this.LocalDescription = localDescription;
        return this;
    }

    public static ExSerialize<ExSuit> getExSer() {
        return ExSer;
    }

    public static void setExSer(ExSerialize<ExSuit> exSer) {
        ExSer = exSer;
    }

    public Map<String, String> getSetting() {
        return this.setting;
    }

    public ExSuit setSetting(Map<String, String> setting) {
        this.setting = setting;
        return this;
    }

    public boolean isHasMobEffect() {
        return this.hasMobEffect;
    }

    public ExSuit setHasMobEffect(boolean hasMobEffect) {
        this.hasMobEffect = hasMobEffect;
        return this;
    }

    public ItemType getType() {
        return this.type;
    }

    public ExSuit setType(ItemType type2) {
        this.type = type2;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public ExSuit setId(String id) {
        this.id = id;
        return this;
    }

    public int getMaxLevel() {
        return this.MaxLevel;
    }

    public ExSuit setMaxLevel(int maxLevel) {
        this.MaxLevel = maxLevel;
        return this;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public ExSuit setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public Map<String, Float> getItemDamage() {
        return this.itemDamage;
    }

    public ExSuit setItemDamage(Map<String, Float> itemDamage) {
        this.itemDamage = itemDamage;
        return this;
    }

    public Map<Integer, String> getEffectLocalDescription() {
        return this.effectLocalDescription;
    }

    public ExSuit setEffectLocalDescription(Map<Integer, String> effectLocalDescription) {
        this.effectLocalDescription = effectLocalDescription;
        return this;
    }

    public Map<Integer, Trigger> getTriggers() {
        return this.triggers;
    }

    public void setTriggers(Map<Integer, Trigger> triggers) {
        this.triggers = triggers;
    }

    public void setLevelTriggers(int level, Trigger trigger) {
        this.triggers.put(level, trigger);
    }

    public Map<Integer, List<AttriGetherNormal>> getAttriGether() {
        return this.attriGether;
    }

    public Map<Integer, List<AttriGetherNormal>> getAttriGetherC() {
        return new HashMap<Integer, List<AttriGetherNormal>>(this.attriGether);
    }

    public String toString() {
        return "ExSuit{setting=" + String.valueOf(this.setting) + ", hasMobEffect=" + this.hasMobEffect + ", type=" + String.valueOf(this.type) + ", Id='" + this.id + "', LocalDescription='" + this.LocalDescription + "', commands=" + String.valueOf(this.commands) + ", MaxLevel=" + this.MaxLevel + ", visible=" + this.visible + ", MainTrigger=" + String.valueOf((Object)MainTrigger) + ", triggers=" + String.valueOf(this.triggers) + ", attriGether=" + String.valueOf(this.attriGether) + ", effect=" + String.valueOf(this.effect) + ", itemDamage=" + String.valueOf(this.itemDamage) + "}";
    }

    public static Trigger StringToTrigger(String trigger) {
        for (Trigger trigger1 : Trigger.values()) {
            if (!trigger1.toString().equalsIgnoreCase(trigger)) continue;
            return trigger1;
        }
        return Trigger.TICK;
    }

    public String getSetting(String key) {
        if (this.setting.containsKey(key)) {
            return this.setting.get(key);
        }
        return null;
    }

    public ExSuit() {
    }

    public static String getEffectString(MobEffectInstance mobEffectInstance) {
        String asString = mobEffectInstance.m_19555_(new CompoundTag()).m_7916_();
        return asString;
    }

    public static MobEffectInstance getEffectFromString(String effectString) {
        try {
            return MobEffectInstance.m_19560_((CompoundTag)TagParser.m_129359_((String)effectString));
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public int CountMaxLevelAndGet() {
        int maxLevel = 0;
        if (this.attriGether != null) {
            if (this.effect != null && !this.effect.isEmpty()) {
                maxLevel = Collections.max(this.effect.keySet());
            }
            if (!this.attriGether.isEmpty()) {
                maxLevel = Math.max(maxLevel, Collections.max(this.attriGether.keySet()));
            }
        }
        this.MaxLevel = maxLevel;
        return maxLevel;
    }

    public void CountMaxLevel(int maxLevel) {
        this.MaxLevel = Math.max(Collections.max(this.attriGether.keySet()), Collections.max(this.effect.keySet()));
    }

    public ExSuit(String id, Map<Integer, List<AttriGetherNormal>> attriGether) {
        this.id = id;
        this.attriGether = attriGether;
    }

    public Map<Integer, List<MobEffectInstance>> getEffect() {
        return this.effect;
    }

    public void setLevelAttriGether(int level, List<AttriGetherNormal> attriGether) {
        Exmodifier.LOGGER.debug("setLevelAttriGether " + level + " " + String.valueOf(attriGether));
        if (attriGether != null) {
            this.attriGether.put(level, attriGether);
        }
    }

    public void setAttriGether(Map<Integer, List<AttriGetherNormal>> attriGether) {
        this.attriGether = attriGether;
    }

    public void setEffect(Map<Integer, List<MobEffectInstance>> effect) {
        Exmodifier.LOGGER.debug("setEffect " + String.valueOf(effect));
        this.effect = effect;
        if (!effect.isEmpty()) {
            this.hasMobEffect = true;
        }
    }

    public void setLevelEffects(int level, List<MobEffectInstance> mobEffectInstances) {
        Exmodifier.LOGGER.debug("setLevelEffects " + level + " " + String.valueOf(mobEffectInstances));
        this.effect.put(level, mobEffectInstances);
        this.hasMobEffect = true;
    }

    public void addEffect(int level, MobEffectInstance mobEffectInstance) {
        if (!this.effect.containsKey(level)) {
            this.effect.put(level, new ArrayList());
        }
        this.effect.get(level).add(mobEffectInstance);
        this.hasMobEffect = true;
    }

    public Map<Integer, List<String>> getCommands() {
        return this.commands;
    }

    public void setCommands(Map<Integer, List<String>> commands) {
        this.commands = commands;
    }

    public static enum Trigger {
        TICK,
        ON_HURT,
        ATTACK,
        JUMP,
        SHOOT,
        EAT,
        DODGE,
        CRIT,
        KILL,
        DIE,
        MOVECHANGE,
        SWING,
        PROJECTILE_HIT,
        ON_USE,
        SWIM,
        IN_LAVA,
        DIG;

    }
}

