/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.content.type;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.exmo.exmodifier.Exmodifier;
import net.exmo.exmodifier.content.modifier.MoConfig;
import net.exmo.exmodifier.content.type.ItemType;
import net.exmo.exmodifier.events.ExRegisterExType;
import net.exmo.exmodifier.util.ExConfigHandle;
import net.exmo.exmodifier.util.ItemSelector;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

public class ExTypeHandle {
    public static Map<String, ItemType> itemTypes = new HashMap<String, ItemType>();
    public static Path ConfigPath = FMLPaths.CONFIGDIR.get().resolve("exmo/type");
    public static List<MoConfig> FoundTypeConfigs = new ArrayList<MoConfig>();

    public static void registerItemType(ItemType itemType) {
        itemTypes.put(itemType.name(), itemType);
        Exmodifier.LOGGER.debug("Registered Item Type: " + String.valueOf(itemType));
    }

    public static void readConfig() throws IOException {
        long startTime = System.nanoTime();
        FoundTypeConfigs = ExConfigHandle.listFiles(ConfigPath);
        for (MoConfig moconfig : FoundTypeConfigs) {
            ExTypeHandle.processItemTypes(moconfig);
        }
        long endTime = System.nanoTime();
        long duration = endTime - startTime;
        Exmodifier.LOGGER.debug("ReadConfig Types Over time: " + duration / 1000000L + " ms");
    }

    public static void processItemTypes(MoConfig moconfig) throws FileNotFoundException {
        if (moconfig.readEntrys().isEmpty()) {
            Exmodifier.LOGGER.info("No Types Config Found");
            return;
        }
        ArrayList<ItemType> entries = new ArrayList<ItemType>();
        for (Map.Entry<String, JsonElement> entry : moconfig.readEntrys()) {
            try {
                Exmodifier.LOGGER.debug("Reading Type Config: " + entry.getKey());
                ExTypeHandle.processItemType(moconfig, entry, entries);
                Exmodifier.LOGGER.debug("Reading Type Config Over: " + entry.getKey());
            }
            catch (Exception e) {
                Exmodifier.LOGGER.Logger.error("Error processing Type: " + entry.getKey(), (Throwable)e);
            }
        }
        for (ItemType itemType : entries) {
            ExTypeHandle.registerItemType(itemType);
        }
        MinecraftForge.EVENT_BUS.post((Event)new ExRegisterExType());
    }

    public static void processItemType(MoConfig moconfig, Map.Entry<String, JsonElement> entry, List<ItemType> entries) {
        JsonElement itemElement = entry.getValue();
        if (!itemElement.isJsonObject()) {
            return;
        }
        JsonObject itemObject = itemElement.getAsJsonObject();
        ArrayList<ItemSelector> selectors = new ArrayList<ItemSelector>();
        ArrayList<EquipmentSlot> equipmentSlots = new ArrayList<EquipmentSlot>();
        if (itemObject.has("selectors")) {
            JsonArray selectorsArray = itemObject.getAsJsonArray("selectors");
            for (JsonElement selectorElement : selectorsArray) {
                JsonArray tagArray;
                JsonObject selectorObj = selectorElement.getAsJsonObject();
                ArrayList<CompoundTag> containNBT = new ArrayList<CompoundTag>();
                ArrayList<TagKey<Item>> containTag = new ArrayList<TagKey<Item>>();
                ArrayList<String> items = new ArrayList<String>();
                if (selectorObj.has("containNBT")) {
                    JsonArray nbtArray = selectorObj.getAsJsonArray("containNBT");
                    for (JsonElement nbtEntry : nbtArray) {
                        if (!nbtEntry.isJsonObject()) continue;
                        CompoundTag nbtTag = new CompoundTag();
                        JsonObject nbtObject = nbtEntry.getAsJsonObject();
                        for (Map.Entry nbtPair : nbtObject.entrySet()) {
                            nbtTag.m_128359_((String)nbtPair.getKey(), ((JsonElement)nbtPair.getValue()).getAsString());
                        }
                        containNBT.add(nbtTag);
                    }
                }
                if (selectorObj.has("containTag")) {
                    tagArray = selectorObj.getAsJsonArray("containTag");
                    for (JsonElement tagElement : tagArray) {
                        if (!tagElement.isJsonPrimitive()) continue;
                        containTag.add((TagKey<Item>)TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)new ResourceLocation(tagElement.getAsString())));
                    }
                }
                if (selectorObj.has("itemIds")) {
                    tagArray = selectorObj.getAsJsonArray("itemIds");
                    for (JsonElement tagElement : tagArray) {
                        if (!tagElement.isJsonPrimitive()) continue;
                        items.add(tagElement.getAsString());
                    }
                }
                String typeStr = selectorObj.get("type").getAsString();
                ItemSelector.CompareType type2 = ItemSelector.CompareType.valueOf(typeStr);
                ItemSelector selector = new ItemSelector(null, items, containNBT, type2, containTag, null);
                selectors.add(selector);
            }
        }
        if (itemObject.has("equipmentSlot")) {
            JsonArray slotArray = itemObject.getAsJsonArray("equipmentSlot");
            for (JsonElement slotElement : slotArray) {
                String slotName = slotElement.getAsString();
                EquipmentSlot slot = EquipmentSlot.m_20747_((String)slotName.toLowerCase());
                if (slot != null) {
                    equipmentSlots.add(slot);
                    continue;
                }
                Exmodifier.LOGGER.Logger.error("Invalid equipment slot: " + slotName);
            }
        }
        String name = itemObject.has("name") ? itemObject.get("name").getAsString() : entry.getKey();
        ItemType itemType = new ItemType(name, new ArrayList<ItemSelector>(selectors), equipmentSlots.toArray(new EquipmentSlot[0]));
        entries.add(itemType);
    }
}

