/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.init;

import java.util.List;
import java.util.Random;
import net.exmo.exmodifier.events.ExDodgeEvent;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ExAttribute {
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)"exmodifier");
    public static final RegistryObject<Attribute> ARROW_BASE_DAMAGE;
    public static final RegistryObject<Attribute> DURABILITY;
    public static final RegistryObject<Attribute> DIG_SPEED;
    public static final RegistryObject<Attribute> DODGE;
    public static final RegistryObject<Attribute> MAX_INJURY_FREE;
    public static final RegistryObject<Attribute> MAX_DODGE;
    public static final RegistryObject<Attribute> HIT_RATE;
    public static final RegistryObject<Attribute> PERCENT_HEAL;
    public static final RegistryObject<Attribute> INJURY_FREE;
    public static final RegistryObject<Attribute> BEHIND_DAMAGE;
    public static final RegistryObject<Attribute> FIREWORK_DAMAGE;
    public static final RegistryObject<Attribute> DEFENSE;
    public static final RegistryObject<Attribute> DIRECT_PROTECTION;
    public static final RegistryObject<Attribute> MAGIC_PROTECTION;
    public static final RegistryObject<Attribute> ELEMENT_CONVERSION_COEFFICIENT;
    public static final RegistryObject<Attribute> ELEMENT_RESISTANCE_COEFFICIENT;
    public static final RegistryObject<Attribute> ALL_ATTRIBUTE_BOOST;

    private static RegistryObject<Attribute> registerAttribute(String name, double defaultValue, double minValue, double maxValue) {
        return ATTRIBUTES.register(name, () -> new RangedAttribute("attribute.exmodifier." + name, defaultValue, minValue, maxValue).m_22084_(true));
    }

    @SubscribeEvent
    public static void register(FMLConstructModEvent event) {
        event.enqueueWork(() -> ATTRIBUTES.register(FMLJavaModLoadingContext.get().getModEventBus()));
    }

    @SubscribeEvent
    public static void addAttributes(EntityAttributeModificationEvent event) {
        List entityTypes = event.getTypes();
        entityTypes.forEach(e -> {
            event.add(e, (Attribute)DODGE.get());
            event.add(e, (Attribute)DIG_SPEED.get());
            event.add(e, (Attribute)INJURY_FREE.get());
            event.add(e, (Attribute)HIT_RATE.get());
            event.add(e, (Attribute)PERCENT_HEAL.get());
            event.add(e, (Attribute)BEHIND_DAMAGE.get());
            event.add(e, (Attribute)ARROW_BASE_DAMAGE.get());
            event.add(e, (Attribute)DURABILITY.get());
            event.add(e, (Attribute)DEFENSE.get());
            event.add(e, (Attribute)DIRECT_PROTECTION.get());
            event.add(e, (Attribute)MAGIC_PROTECTION.get());
            event.add(e, (Attribute)ELEMENT_CONVERSION_COEFFICIENT.get());
            event.add(e, (Attribute)ELEMENT_RESISTANCE_COEFFICIENT.get());
            event.add(e, (Attribute)ALL_ATTRIBUTE_BOOST.get());
            if (e.equals(EntityType.f_20532_)) {
                event.add(e, (Attribute)MAX_DODGE.get());
                event.add(e, (Attribute)FIREWORK_DAMAGE.get());
                event.add(e, (Attribute)MAX_INJURY_FREE.get());
            }
        });
    }

    static {
        ALL_ATTRIBUTE_BOOST = ExAttribute.registerAttribute("all_attribute_boost", 1.0, 0.0, 1.0E8);
        ELEMENT_RESISTANCE_COEFFICIENT = ExAttribute.registerAttribute("element_resistance_coefficient", 6.0, 0.0, 1.0E8);
        ELEMENT_CONVERSION_COEFFICIENT = ExAttribute.registerAttribute("element_conversion_coefficient", 1.0, 0.0, 1.0E8);
        FIREWORK_DAMAGE = ExAttribute.registerAttribute("firework_damage", 1.0, 0.0, 1.0E8);
        BEHIND_DAMAGE = ExAttribute.registerAttribute("behind_damage", 1.0, -1.0E8, 1.0E8);
        ARROW_BASE_DAMAGE = ExAttribute.registerAttribute("arrow_base_damage", 0.0, 0.0, 1.0E8);
        DURABILITY = ExAttribute.registerAttribute("durability", 1.0, 0.0, 1.0E8);
        DIG_SPEED = ExAttribute.registerAttribute("dig_speed", 1.0, 0.0, 1.0E8);
        DODGE = ExAttribute.registerAttribute("dodge", 1.0, 0.0, 1.0E7);
        MAX_INJURY_FREE = ExAttribute.registerAttribute("max_injury_free", 1.85, 0.0, 1.0E7);
        MAX_DODGE = ExAttribute.registerAttribute("max_dodge", 1.85, 0.0, 1.0E7);
        HIT_RATE = ExAttribute.registerAttribute("hit_rate", 1.0, 0.0, 1.0E7);
        PERCENT_HEAL = ExAttribute.registerAttribute("percent_heal", 1.0, 0.0, 1.0E7);
        INJURY_FREE = ExAttribute.registerAttribute("injury_free", 1.0, -100000.0, 1.0E7);
        DEFENSE = ExAttribute.registerAttribute("defense", 0.0, -100000.0, 1.0E7);
        DIRECT_PROTECTION = ExAttribute.registerAttribute("direct_protection", 0.0, -100000.0, 1.0E7);
        MAGIC_PROTECTION = ExAttribute.registerAttribute("magic_protection", 0.0, -100000.0, 1.0E7);
    }

    @Mod.EventBusSubscriber
    public static class Utils {
        public static void particle(Entity entity) {
            Level level = entity.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel _level = (ServerLevel)level;
                _level.m_8767_((ParticleOptions)ParticleTypes.f_123796_, entity.m_20185_(), entity.m_20186_() + (double)entity.m_20206_() * 0.5, entity.m_20189_(), 5, 0.2, 0.2, 0.2, 0.02);
            }
        }

        public static void move(Entity entity) {
            Random random = new Random();
            double a = -1.0;
            if (Math.random() < 0.5) {
                a = 1.0;
            }
            entity.m_20256_(new Vec3(Math.cos(Math.toRadians(entity.m_146908_())) * 2.0 * a, 0.0, Math.sin(Math.toRadians(entity.m_146908_())) * a));
        }

        public static boolean isLookingBehindTarget(LivingEntity target, Vec3 attackerLocation) {
            if (attackerLocation != null) {
                Vec3 lookingVector = target.m_20252_(1.0f);
                Vec3 attackAngleVector = attackerLocation.m_82546_(target.m_20182_()).m_82541_();
                attackAngleVector = new Vec3(attackAngleVector.f_82479_, 0.0, attackAngleVector.f_82481_);
                return attackAngleVector.m_82526_(lookingVector) < -0.5;
            }
            return false;
        }

        public static float getBackstabbingDamagePerLevel(float amount, int level) {
            float multiplier = (float)level * 0.2f + 1.2f;
            return amount * multiplier;
        }

        @SubscribeEvent
        public static void AtAttack(LivingAttackEvent event) {
            LivingEntity entity = event.getEntity();
            Entity entity2 = event.getSource().m_7639_();
            if (!(entity2 instanceof LivingEntity)) {
                return;
            }
            LivingEntity souree = (LivingEntity)entity2;
            if (event.getSource().m_276093_(DamageTypes.f_268515_) || event.getSource().m_276093_(DamageTypes.f_268530_) || event.getSource().m_276093_(DamageTypes.f_268546_)) {
                return;
            }
            if (entity.m_21204_().m_22171_((Attribute)DODGE.get())) {
                double remove_value = 0.0;
                if (souree.m_21204_().m_22171_((Attribute)HIT_RATE.get())) {
                    remove_value = souree.m_21133_((Attribute)HIT_RATE.get());
                }
                double v = entity.m_21133_((Attribute)DODGE.get()) - remove_value;
                if (Math.random() <= v) {
                    Utils.particle((Entity)entity);
                    Utils.move((Entity)entity);
                    ExDodgeEvent e = new ExDodgeEvent(entity, event, entity.m_21133_((Attribute)DODGE.get()), remove_value, ExDodgeEvent.resultType.MISS);
                    MinecraftForge.EVENT_BUS.post((Event)e);
                    if (e.result == ExDodgeEvent.resultType.MISS) {
                        event.setCanceled(true);
                    }
                } else if (v < 0.0) {
                    ExDodgeEvent e = new ExDodgeEvent(entity, event, entity.m_21133_((Attribute)DODGE.get()), remove_value, ExDodgeEvent.resultType.HIT);
                    MinecraftForge.EVENT_BUS.post((Event)e);
                    if (e.result == ExDodgeEvent.resultType.MISS) {
                        event.setCanceled(true);
                    } else {
                        entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, (int)(v * 2.5 * -1.0), false, false));
                    }
                }
            }
        }

        @SubscribeEvent
        public static void DamageModifier(LivingHurtEvent event) {
            LivingEntity entity1;
            Entity entity;
            double v;
            LivingEntity attacker;
            if (event.getSource().m_276093_(DamageTypes.f_286979_)) {
                return;
            }
            LivingEntity entity2 = event.getEntity();
            float FinallyDanage = event.getAmount();
            LivingEntity livingEntity = attacker = event.getSource().m_7639_() instanceof LivingEntity ? (LivingEntity)event.getSource().m_7639_() : null;
            if (event.getSource().m_7639_() instanceof LivingEntity) {
                double multiplier;
                if (Utils.isLookingBehindTarget(event.getEntity(), event.getSource().m_7270_()) && attacker != null && attacker.m_21204_().m_22171_((Attribute)BEHIND_DAMAGE.get())) {
                    multiplier = attacker.m_21133_((Attribute)BEHIND_DAMAGE.get());
                    FinallyDanage = (float)(multiplier * (double)FinallyDanage);
                    Level level = attacker.m_9236_();
                    if (!level.f_46443_ && multiplier > 1.0) {
                        level.m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12313_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                }
                if (attacker != null && attacker.m_21204_().m_22171_((Attribute)FIREWORK_DAMAGE.get())) {
                    multiplier = attacker.m_21133_((Attribute)FIREWORK_DAMAGE.get());
                    FinallyDanage = (float)(multiplier * (double)FinallyDanage);
                }
            }
            if (entity2.m_21204_().m_22171_((Attribute)DEFENSE.get())) {
                v = entity2.m_21133_((Attribute)DEFENSE.get());
                FinallyDanage = (float)((double)(FinallyDanage * (float)Math.round(100.0 * (100.0 / (v - 1.0 + 100.0)))) * 0.01);
            }
            if (entity2.m_21204_().m_22171_((Attribute)INJURY_FREE.get())) {
                v = entity2.m_21133_((Attribute)INJURY_FREE.get());
                FinallyDanage = (float)((2.0 - v) * (double)FinallyDanage);
            }
            if ((entity = event.getSource().m_7639_()) instanceof LivingEntity && (entity1 = (LivingEntity)entity).m_21204_().m_22171_((Attribute)PERCENT_HEAL.get()) && entity1.m_21204_().m_22171_(Attributes.f_22276_)) {
                double v2 = entity1.m_21133_((Attribute)PERCENT_HEAL.get());
                entity1.m_5634_((float)(entity1.m_21133_(Attributes.f_22276_) * (v2 - 1.0)));
            }
            if (entity2.m_21204_().m_22171_((Attribute)DIRECT_PROTECTION.get())) {
                double v3 = entity2.m_21133_((Attribute)DIRECT_PROTECTION.get());
                FinallyDanage = (float)Math.max(0.0, (double)FinallyDanage - v3);
            }
            if (event.getSource().m_276093_(DamageTypes.f_268515_) && entity2.m_21204_().m_22171_((Attribute)MAGIC_PROTECTION.get())) {
                double v4 = entity2.m_21133_((Attribute)MAGIC_PROTECTION.get());
                FinallyDanage = (float)Math.max(0.0, (double)FinallyDanage - v4);
            }
            event.setAmount(FinallyDanage);
        }

        @SubscribeEvent
        public static void persistAttributes(PlayerEvent.Clone event) {
            Player oldP = event.getOriginal();
            Player newP = event.getEntity();
            newP.m_21051_((Attribute)ALL_ATTRIBUTE_BOOST.get()).m_22100_(oldP.m_21051_((Attribute)ALL_ATTRIBUTE_BOOST.get()).m_22115_());
            newP.m_21051_((Attribute)DODGE.get()).m_22100_(oldP.m_21051_((Attribute)DODGE.get()).m_22115_());
            newP.m_21051_((Attribute)BEHIND_DAMAGE.get()).m_22100_(oldP.m_21051_((Attribute)BEHIND_DAMAGE.get()).m_22115_());
            newP.m_21051_((Attribute)PERCENT_HEAL.get()).m_22100_(oldP.m_21051_((Attribute)PERCENT_HEAL.get()).m_22115_());
            newP.m_21051_((Attribute)HIT_RATE.get()).m_22100_(oldP.m_21051_((Attribute)HIT_RATE.get()).m_22115_());
            newP.m_21051_((Attribute)DEFENSE.get()).m_22100_(oldP.m_21051_((Attribute)DEFENSE.get()).m_22115_());
            newP.m_21051_((Attribute)DIRECT_PROTECTION.get()).m_22100_(oldP.m_21051_((Attribute)DIRECT_PROTECTION.get()).m_22115_());
            newP.m_21051_((Attribute)MAGIC_PROTECTION.get()).m_22100_(oldP.m_21051_((Attribute)DIRECT_PROTECTION.get()).m_22115_());
            newP.m_21051_((Attribute)INJURY_FREE.get()).m_22100_(oldP.m_21051_((Attribute)INJURY_FREE.get()).m_22115_());
            newP.m_21051_((Attribute)FIREWORK_DAMAGE.get()).m_22100_(oldP.m_21051_((Attribute)FIREWORK_DAMAGE.get()).m_22115_());
            newP.m_21051_((Attribute)ELEMENT_CONVERSION_COEFFICIENT.get()).m_22100_(oldP.m_21051_((Attribute)ELEMENT_RESISTANCE_COEFFICIENT.get()).m_22115_());
            newP.m_21051_((Attribute)ELEMENT_RESISTANCE_COEFFICIENT.get()).m_22100_(oldP.m_21051_((Attribute)ELEMENT_RESISTANCE_COEFFICIENT.get()).m_22115_());
        }
    }
}

