/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.network;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.exmo.exmodifier.Exmodifier;
import net.exmo.exmodifier.content.attributeEffect.AttriGetherEffectInstance;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ExModifiervaV {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        Exmodifier.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        Exmodifier.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        public int type;
        public SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            SavedData savedData = this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
            if (savedData instanceof MapVariables) {
                MapVariables _mapvars = (MapVariables)savedData;
                _mapvars.read(buffer.m_130260_());
            } else {
                savedData = this.data;
                if (savedData instanceof WorldVariables) {
                    WorldVariables _worldvars = (WorldVariables)savedData;
                    _worldvars.read(buffer.m_130260_());
                }
            }
        }

        public SavedDataSyncMessage(int type2, SavedData data) {
            this.type = type2;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        public PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.Sitemstack = message.data.Sitemstack;
                    variables.craftIndex = message.data.craftIndex;
                    variables.SuitsNum = message.data.SuitsNum;
                    variables.attriGetherEffectInstances = message.data.attriGetherEffectInstances;
                    variables.itemsDamage = message.data.itemsDamage;
                    variables.syncContent = message.data.syncContent;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public Map<String, Integer> SuitsNum = new HashMap<String, Integer>();
        public Map<String, Float> itemsDamage = new HashMap<String, Float>();
        public Map<String, String> syncContent = new HashMap<String, String>();
        public List<AttriGetherEffectInstance> attriGetherEffectInstances = new ArrayList<AttriGetherEffectInstance>();
        public ItemStack Sitemstack = ItemStack.f_41583_;
        public int craftIndex = -2;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                Exmodifier.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("craftIndex", this.craftIndex);
            nbt.m_128365_("Sitemstack", (Tag)this.Sitemstack.m_41739_(new CompoundTag()));
            ListTag EFListTag = new ListTag();
            for (AttriGetherEffectInstance attriGetherEffectInstance : this.attriGetherEffectInstances) {
                if (attriGetherEffectInstance == null) continue;
                EFListTag.add((Object)attriGetherEffectInstance.toNBT());
            }
            nbt.m_128365_("attriGetherEffectInstances", (Tag)EFListTag);
            CompoundTag SuitsNuma = new CompoundTag();
            for (Map.Entry<String, Integer> entry : this.SuitsNum.entrySet()) {
                if (entry.getValue() == 0 || entry == null || entry.getKey() == null) continue;
                SuitsNuma.m_128359_(entry.getKey(), entry.getValue().toString());
            }
            nbt.m_128365_("SuitsNum", (Tag)SuitsNuma);
            CompoundTag compoundTag = new CompoundTag();
            for (Map.Entry<String, Float> entry : this.itemsDamage.entrySet()) {
                compoundTag.m_128359_(entry.getKey(), entry.getValue().toString());
            }
            nbt.m_128365_("itemsDamage", (Tag)compoundTag);
            CompoundTag compoundTag2 = new CompoundTag();
            for (Map.Entry<String, String> entry : this.syncContent.entrySet()) {
                compoundTag2.m_128359_(entry.getKey(), entry.getValue());
            }
            nbt.m_128365_("syncContent", (Tag)compoundTag2);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.craftIndex = nbt.m_128451_("craftIndex");
            this.Sitemstack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Sitemstack"));
            ListTag ExSuitListTag = nbt.m_128437_("Suits", 8);
            ListTag EFListTag = nbt.m_128437_("attriGetherEffectInstances", 10);
            ArrayList<AttriGetherEffectInstance> EFList = new ArrayList<AttriGetherEffectInstance>();
            for (int i = 0; i < EFListTag.size(); ++i) {
                EFList.add(AttriGetherEffectInstance.fromNBT(EFListTag.m_128728_(i)));
            }
            this.attriGetherEffectInstances = EFList;
            CompoundTag SuitsNuma = nbt.m_128469_("SuitsNum");
            for (Object key : SuitsNuma.m_128431_()) {
                String value = SuitsNuma.m_128461_((String)key);
                this.SuitsNum.put((String)key, Integer.parseInt(value));
            }
            CompoundTag syncContenta = nbt.m_128469_("syncContent");
            for (String key : syncContenta.m_128431_()) {
                String value = syncContenta.m_128461_(key);
                this.syncContent.put(key, value);
            }
            CompoundTag itemsDamaget = nbt.m_128469_("itemsDamage");
            for (String key : itemsDamaget.m_128431_()) {
                String value = itemsDamaget.m_128461_(key);
                this.itemsDamage.put(key, Float.valueOf(Float.parseFloat(value)));
            }
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("exmodifier", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "exmodifier_mapvars";
        public static List<Map.Entry<ServerBossEvent, UUID>> bossBarList = new ArrayList<Map.Entry<ServerBossEvent, UUID>>();
        static MapVariables clientSide = new MapVariables();

        @NotNull
        private CompoundTag getBossBarCompoundTag(ServerBossEvent bossEvent) {
            CompoundTag bossEventNBT = new CompoundTag();
            bossEventNBT.m_128359_("Name", bossEvent.m_18861_().getString());
            bossEventNBT.m_128359_("Color", bossEvent.m_18862_().m_18886_());
            ServerPlayer serverPlayer = bossEvent.m_8324_().stream().findFirst().orElse(null);
            if (serverPlayer != null) {
                bossEventNBT.m_128359_("Player", serverPlayer.m_7755_().getString());
            }
            bossEventNBT.m_128359_("BossBarOverlay", bossEvent.m_18863_().m_18902_());
            bossEventNBT.m_128359_("Player", bossEvent.m_18863_().m_18902_());
            bossEventNBT.m_128379_("IsVisible", bossEvent.m_8323_());
            bossEventNBT.m_128350_("Progress", bossEvent.m_142717_());
            return bossEventNBT;
        }

        private ServerBossEvent getBossBarFromNBT(CompoundTag bossEventNBT) {
            ServerBossEvent bossEvent = null;
            MutableComponent name = Component.m_237115_((String)bossEventNBT.m_128461_("Name"));
            int progress = bossEventNBT.m_128451_("Progress");
            BossEvent.BossBarOverlay overlay = BossEvent.BossBarOverlay.valueOf((String)bossEventNBT.m_128461_("BossBarOverlay"));
            BossEvent.BossBarColor color = BossEvent.BossBarColor.valueOf((String)bossEventNBT.m_128461_("Color"));
            bossEvent = new ServerBossEvent((Component)name, color, overlay);
            bossEvent.m_142711_((float)progress);
            bossEvent.m_8321_(bossEventNBT.m_128471_("IsVisible"));
            return bossEvent;
        }

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                Exmodifier.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "exmodifier_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                Exmodifier.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.Sitemstack = original.Sitemstack;
            if (!event.isWasDeath()) {
                clone.craftIndex = original.craftIndex;
                clone.syncContent = original.syncContent;
                clone.attriGetherEffectInstances = original.attriGetherEffectInstances;
                clone.itemsDamage = original.itemsDamage;
                clone.SuitsNum = original.SuitsNum;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    Exmodifier.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    Exmodifier.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                Exmodifier.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

