/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.exmo.exmodifier.content.dynamicAttributes.DynamicAttribute;
import net.exmo.exmodifier.content.dynamicAttributes.DynamicAttributeRegister;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public record SyncDynamicAttributeMessage(Map<String, DynamicAttribute> map) {
    public static void encode(SyncDynamicAttributeMessage msg, FriendlyByteBuf buffer) {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<String, DynamicAttribute> entry : msg.map.entrySet()) {
            tag.m_128365_(entry.getKey(), (Tag)DynamicAttribute.SERIALIZER.toNbt(entry.getValue()));
        }
        buffer.m_130079_(tag);
    }

    public static SyncDynamicAttributeMessage decode(FriendlyByteBuf buffer) {
        CompoundTag tag = buffer.m_130260_();
        HashMap<String, DynamicAttribute> map = new HashMap<String, DynamicAttribute>();
        if (tag != null) {
            for (String key : tag.m_128431_()) {
                DynamicAttribute dynamicAttribute = DynamicAttribute.SERIALIZER.fromNbt(tag.m_128469_(key));
                map.put(key, dynamicAttribute);
            }
        }
        return new SyncDynamicAttributeMessage(map);
    }

    public static void handle(SyncDynamicAttributeMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            DynamicAttributeRegister.dynamicAttributes = msg.map;
        });
        ctx.get().setPacketHandled(true);
    }
}

