/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.network;

import java.util.UUID;
import java.util.function.Supplier;
import net.exmo.exmodifier.Config;
import net.exmo.exmodifier.content.element.ExElementEntityData;
import net.exmo.exmodifier.content.element.ExElementHandle;
import net.exmo.exmodifier.content.element.ExElementInstant;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public record SyncEntityElementMessage(UUID uuid, ExElementInstant exElementInstant) {
    public static void encode(SyncEntityElementMessage msg, FriendlyByteBuf buffer) {
        if (msg.exElementInstant.getElement() == null || msg.exElementInstant.getElement().getResId() == null) {
            return;
        }
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128405_("Level", msg.exElementInstant.getLevel());
        compoundTag.m_128359_("ID", msg.exElementInstant.getElement().getResId().toString());
        compoundTag.m_128359_("UUID", msg.uuid.toString());
        buffer.m_130079_(compoundTag);
    }

    public static SyncEntityElementMessage decode(FriendlyByteBuf buffer) {
        CompoundTag compoundTag = buffer.m_130260_();
        return new SyncEntityElementMessage(UUID.fromString(compoundTag.m_128461_("UUID")), new ExElementInstant(ExElementHandle.getExElement(compoundTag.m_128461_("ID")), compoundTag.m_128451_("Level")));
    }

    public static void handle(SyncEntityElementMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (!((Boolean)Config.ELEMENT_SYSTEM.get()).booleanValue()) {
                return;
            }
            ExElementEntityData.ELEMENT_ENTITY_DATA.put(msg.uuid, msg.exElementInstant);
        });
        ctx.get().setPacketHandled(true);
    }
}

