/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.network.sync.lang;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.exmo.exmodifier.content.client.LanguageLoader;
import net.exmo.exmodifier.util.exSerialize.ExSerialize;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public record LangMessage(LangMessageHandler langMessageHandler) {
    public static void encode(LangMessage msg, FriendlyByteBuf buffer) {
        buffer.m_130079_(LangMessageHandler.EX_SERIALIZE.toNbt(msg.langMessageHandler()));
    }

    public static LangMessage decode(FriendlyByteBuf buffer) {
        CompoundTag tag = buffer.m_130260_();
        if (tag != null) {
            return new LangMessage(LangMessageHandler.EX_SERIALIZE.fromNbt(tag));
        }
        return null;
    }

    public static void handle(LangMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            LangMessageHandler langMessageHandler1 = msg.langMessageHandler();
            LanguageLoader.LANGUAGES.clear();
            LanguageLoader.LANGUAGES.putAll(langMessageHandler1.LANGUAGES);
        });
        ctx.get().setPacketHandled(true);
    }

    public static class LangMessageHandler {
        public Map<String, Map<String, String>> LANGUAGES;
        public static final ExSerialize<LangMessageHandler> EX_SERIALIZE = ExSerialize.create(() -> new LangMessageHandler(new HashMap<String, Map<String, String>>())).addStringMapField("langs", langMessageHandler -> {
            HashMap map = Maps.newHashMap();
            langMessageHandler.LANGUAGES.forEach((a, b) -> map.put(a, LanguageLoader.mapToString(b)));
            return map;
        }, (k, v) -> {
            HashMap map = Maps.newHashMap();
            v.forEach((a, b) -> map.put(a, LanguageLoader.handle(b)));
            k.LANGUAGES = map;
        });

        public LangMessageHandler(Map<String, Map<String, String>> LANGUAGES) {
            this.LANGUAGES = LANGUAGES;
        }
    }
}

