/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.selector;

import com.google.gson.Gson;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.json.JsonObject;
import net.exmo.exmodifier.util.ExUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;

public class BaseItemSelector<T> {
    protected static final Codec<BaseItemSelector<?>> CODEC = Codec.unit(BaseItemSelector::new);
    protected List<String> onlyTypes;
    protected List<String> UnlessItemTags = new ArrayList<String>();
    protected List<String> UnlessItemIds = new ArrayList<String>();
    protected List<String> OnlySlots = new ArrayList<String>();
    protected List<String> OnlyTags = new ArrayList<String>();
    protected List<String> OnlyItems = new ArrayList<String>();

    public T setUnlessItemTags(List<String> unlessItemTags) {
        this.UnlessItemTags = unlessItemTags;
        return (T)this;
    }

    public T setOnlyTags(List<String> onlyTags) {
        this.OnlyTags = onlyTags;
        return (T)this;
    }

    public T setOnlyItems(List<String> onlyItems) {
        this.OnlyItems = onlyItems;
        return (T)this;
    }

    public T setUnlessItemIds(List<String> unlessItemIds) {
        this.UnlessItemIds = unlessItemIds;
        return (T)this;
    }

    public T setOnlySlots(List<String> onlySlots) {
        this.OnlySlots = onlySlots;
        return (T)this;
    }

    public T addOnlyTag(String tag) {
        this.OnlyTags.add(tag);
        return (T)this;
    }

    public T addOnlyItem(String item) {
        this.OnlyItems.add(item);
        return (T)this;
    }

    public T addUnlessItemTag(String tag) {
        this.UnlessItemTags.add(tag);
        return (T)this;
    }

    public T addUnlessItemId(String id) {
        this.UnlessItemIds.add(id);
        return (T)this;
    }

    public T addOnlySlot(String slot) {
        this.OnlySlots.add(slot);
        return (T)this;
    }

    public T addOnlyTags(List<String> tags) {
        this.OnlyTags.addAll(tags);
        return (T)this;
    }

    public T addOnlyItems(List<String> items) {
        this.OnlyItems.addAll(items);
        return (T)this;
    }

    public T addUnlessItemTags(List<String> tags) {
        this.UnlessItemTags.addAll(tags);
        return (T)this;
    }

    public T addUnlessItemIds(List<String> ids) {
        this.UnlessItemIds.addAll(ids);
        return (T)this;
    }

    public T addOnlySlots(List<String> slots) {
        this.OnlySlots.addAll(slots);
        return (T)this;
    }

    public List<String> getOnlyTags() {
        return this.OnlyTags;
    }

    public List<String> getOnlyItems() {
        return this.OnlyItems;
    }

    public List<String> getUnlessItemTags() {
        return this.UnlessItemTags;
    }

    public List<String> getUnlessItemIds() {
        return this.UnlessItemIds;
    }

    public List<String> getOnlySlots() {
        return this.OnlySlots;
    }

    public String toJson() {
        Gson gson = new Gson();
        return gson.toJson((Object)this);
    }

    public JsonObject toJsonObject() {
        Gson gson = new Gson();
        return (JsonObject)gson.fromJson(this.toJson(), JsonObject.class);
    }

    public BaseItemSelector fromJsonObject(JsonObject jsonObject) {
        Gson gson = new Gson();
        return (BaseItemSelector)gson.fromJson(gson.toJson((Object)jsonObject), BaseItemSelector.class);
    }

    public Consumer<CompoundTag> getExtraNBT() {
        return e -> {};
    }

    public Consumer<CompoundTag> disposeNBT() {
        return e -> {};
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128359_("OnlyTags", String.join((CharSequence)",", this.OnlyTags));
        compoundTag.m_128359_("OnlyItems", String.join((CharSequence)",", this.OnlyItems));
        compoundTag.m_128359_("UnlessItemTags", String.join((CharSequence)",", this.UnlessItemTags));
        compoundTag.m_128359_("UnlessItemIds", String.join((CharSequence)",", this.UnlessItemIds));
        compoundTag.m_128359_("OnlySlots", String.join((CharSequence)",", this.OnlySlots));
        this.getExtraNBT().accept(compoundTag);
        return compoundTag;
    }

    public static BaseItemSelector<?> deserializeNBT(CompoundTag compoundTag) {
        BaseItemSelector baseItemSelector = new BaseItemSelector();
        baseItemSelector.OnlyTags.addAll(List.of(compoundTag.m_128461_("OnlyTags").split(",")));
        baseItemSelector.OnlyItems.addAll(List.of(compoundTag.m_128461_("OnlyItems").split(",")));
        baseItemSelector.UnlessItemTags.addAll(List.of(compoundTag.m_128461_("UnlessItemTags").split(",")));
        baseItemSelector.UnlessItemIds.addAll(List.of(compoundTag.m_128461_("UnlessItemIds").split(",")));
        baseItemSelector.OnlySlots.addAll(List.of(compoundTag.m_128461_("OnlySlots").split(",")));
        baseItemSelector.disposeNBT().accept(compoundTag);
        return baseItemSelector;
    }

    public boolean containItem(ItemStack stack) {
        String itemId = ExUtil.getItemID(stack);
        if (!this.checkOnlyItems(itemId)) {
            return false;
        }
        if (this.isBlockedByUnlessItemIds(itemId)) {
            return false;
        }
        if (!this.checkOnlyTags(stack)) {
            return false;
        }
        return !this.isBlockedByUnlessItemTags(stack);
    }

    private boolean checkOnlyItems(String itemId) {
        if (this.OnlyItems.isEmpty()) {
            return true;
        }
        return this.OnlyItems.contains(itemId);
    }

    private boolean isBlockedByUnlessItemIds(String itemId) {
        if (this.UnlessItemIds.isEmpty()) {
            return false;
        }
        return this.UnlessItemIds.contains(itemId);
    }

    private boolean checkOnlyTags(ItemStack stack) {
        if (this.OnlyTags.isEmpty()) {
            return true;
        }
        return this.containTag(stack);
    }

    private boolean isBlockedByUnlessItemTags(ItemStack stack) {
        if (this.UnlessItemTags.isEmpty()) {
            return false;
        }
        return !this.unContainTag(stack);
    }

    public boolean containTag(ItemStack stack) {
        if (this.OnlyTags.isEmpty()) {
            return true;
        }
        for (String tag : this.OnlyTags) {
            if (!stack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation(tag)))) continue;
            return true;
        }
        return false;
    }

    public boolean unContainTag(ItemStack stack) {
        List<String> unlessItemTags = this.getUnlessItemTags();
        if (unlessItemTags.isEmpty()) {
            return true;
        }
        for (String tag : unlessItemTags) {
            if (!stack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation(tag)))) continue;
            return false;
        }
        return true;
    }

    private boolean checkTags(ItemStack stack) {
        for (TagKey s : stack.m_204131_().toList()) {
            if (!this.OnlyTags.contains(s.f_203868_().toString())) continue;
            return true;
        }
        return false;
    }
}

