/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.util;

import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.exmo.exmodifier.Exmodifier;
import net.exmo.exmodifier.commands.ExModifierReloadCommand;
import net.exmo.exmodifier.content.client.LanguageLoader;
import net.exmo.exmodifier.content.element.ExElementHandle;
import net.exmo.exmodifier.content.event.MainEvent;
import net.exmo.exmodifier.content.modifier.ModifierHandle;
import net.exmo.exmodifier.content.modifier.RefreshContainItemHandle;
import net.exmo.exmodifier.content.modifier.RefreshContainTagHandle;
import net.exmo.exmodifier.content.quality.ItemQualityHandle;
import net.exmo.exmodifier.content.resources.ZipHandle;
import net.exmo.exmodifier.content.selected.BaseItemSelected;
import net.exmo.exmodifier.content.slot.ModifierSlotHandle;
import net.exmo.exmodifier.content.suit.ExSuitHandle;
import net.exmo.exmodifier.content.type.ExTypeHandle;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.io.IOUtils;

public abstract class AbstractReloadListener<T>
extends SimplePreparableReloadListener<Map<ResourceLocation, JsonObject>> {
    private static final AtomicInteger loadedCount = new AtomicInteger(0);
    private static final AtomicInteger totalCount = new AtomicInteger(0);
    private final String resourcePath;
    private final String logPrefix;
    private final Function<JsonObject, Iterable<T>> deserializer;
    private final BiConsumer<ResourceLocation, T> consumer;
    private static ZipHandle.ZipFunction zipFunction = null;

    protected AbstractReloadListener(String resourcePath, String logPrefix, Function<JsonObject, Iterable<T>> deserializer, BiConsumer<ResourceLocation, T> consumer) {
        this.resourcePath = resourcePath;
        this.logPrefix = logPrefix;
        this.deserializer = deserializer;
        this.consumer = consumer;
        totalCount.incrementAndGet();
    }

    protected Map<ResourceLocation, JsonObject> prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        pProfiler.m_7242_();
        pProfiler.m_6180_(this.logPrefix);
        Map<ResourceLocation, JsonObject> loader = this.listResources(pResourceManager, pProfiler);
        pProfiler.m_7238_();
        return loader;
    }

    protected Map<ResourceLocation, JsonObject> listResources(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        HashMap<ResourceLocation, JsonObject> loader = new HashMap<ResourceLocation, JsonObject>();
        for (Map.Entry resource : pResourceManager.m_214159_(this.resourcePath, p -> p.m_135815_().endsWith(".json")).entrySet()) {
            ResourceLocation key = (ResourceLocation)resource.getKey();
            try {
                BufferedReader reader = ((Resource)resource.getValue()).m_215508_();
                try {
                    Resource packResources = (Resource)pResourceManager.m_213713_(key).orElseThrow(() -> new IOException("Resource not found: " + String.valueOf(key)));
                    String jsonString = IOUtils.toString((InputStream)packResources.m_215507_(), (Charset)StandardCharsets.UTF_8);
                    JsonObject jsonObject = (JsonObject)Exmodifier.GSON.fromJson(jsonString, JsonObject.class);
                    loader.put(key, jsonObject);
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                Exmodifier.LOGGER.Logger.error("Failed to load custom data pack: {}", (Object)key, (Object)e);
            }
        }
        return loader;
    }

    protected void apply(Map<ResourceLocation, JsonObject> jsonObjects, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        if (loadedCount.get() == 0) {
            MainEvent.clearOldData();
            BaseItemSelected.IDS = new HashMap<Integer, Object>();
            try {
                RefreshContainTagHandle.readConfig();
                RefreshContainItemHandle.readConfig();
                ModifierHandle.sendClearDataToAllClient();
                ExTypeHandle.readConfig();
                ItemQualityHandle.init();
                ExElementHandle.init();
                zipFunction = ZipHandle.init();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Exmodifier.LOGGER.Logger.info("Start loading reload listeners");
        }
        for (Map.Entry<ResourceLocation, JsonObject> entry : jsonObjects.entrySet()) {
            for (T element : this.deserializer.apply(entry.getValue())) {
                this.consumer.accept(entry.getKey(), (ResourceLocation)element);
            }
        }
        loadedCount.incrementAndGet();
        if (loadedCount.get() == totalCount.get()) {
            try {
                ItemQualityHandle.init2();
                ModifierHandle.readConfig();
                ExSuitHandle.readConfig();
                ModifierSlotHandle.reload();
                ExElementHandle.init2();
                ExElementHandle.init3();
                if (zipFunction != null) {
                    zipFunction.elementDefault().forEach(Runnable::run);
                    zipFunction.defaultEntry().forEach(Runnable::run);
                    zipFunction.suit().forEach(Runnable::run);
                }
                ModifierHandle.EEMatchQueueHandle();
                LanguageLoader.load(LanguageLoader.LANGUAGES_FILE_PATH);
                MainEvent.clearReadTempData();
                loadedCount.set(0);
                totalCount.set(0);
                MinecraftServer currentServer = ServerLifecycleHooks.getCurrentServer();
                if (currentServer != null) {
                    ExModifierReloadCommand.sendUpdatedModifiersToClients(currentServer);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Exmodifier.LOGGER.Logger.info("All reload listeners loaded");
        }
    }

    public static boolean isAllLoaded() {
        return loadedCount.get() == totalCount.get();
    }

    public static String getLoadingStatus() {
        return String.format("Loaded %d/%d reload listeners", loadedCount.get(), totalCount.get());
    }
}

