/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.util;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class ColorUtil {
    public static int toColor(String color) {
        return Color.getColor(color).getRGB();
    }

    public static int getColorRGB(int red, int green, int blue) {
        return new Color(red, green, blue).getRGB();
    }

    public static int getAverageColor(TextureAtlasSprite sprite) {
        try {
            int width = 16;
            int height = 16;
            BufferedImage image = new BufferedImage(width, height, 2);
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    int color = ColorUtil.fixColor(sprite.getPixelRGBA(1, x, y));
                    String hex = Integer.toHexString(color);
                    String rgba = ColorUtil.intToRGBA(color);
                    image.setRGB(x, y, color);
                }
            }
            AtomicInteger totalR = new AtomicInteger(0);
            AtomicInteger totalG = new AtomicInteger(0);
            AtomicInteger totalB = new AtomicInteger(0);
            AtomicInteger count = new AtomicInteger(0);
            for (int x = 0; x < image.getWidth(); ++x) {
                for (int y = 0; y < image.getHeight(); ++y) {
                    int pixel = image.getRGB(x, y);
                    if ((pixel & 0xFF000000) == 0) continue;
                    totalR.addAndGet(pixel >> 16 & 0xFF);
                    totalG.addAndGet(pixel >> 8 & 0xFF);
                    totalB.addAndGet(pixel & 0xFF);
                    count.incrementAndGet();
                }
            }
            if (count.get() == 0) {
                return 0;
            }
            int r = totalR.get() / count.get();
            int g = totalG.get() / count.get();
            int b = totalB.get() / count.get();
            return r << 16 | g << 8 | b;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static int fixColor(int color) {
        int originalRed = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int alpha = color >> 24 & 0xFF;
        return alpha << 24 | blue << 16 | green << 8 | originalRed;
    }

    public static String intToRGBA(int color) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int alpha = color >> 24 & 0xFF;
        return String.format("rgba(%d, %d, %d, %d)", red, green, blue, alpha);
    }

    public static int rgbaToArgb(int rgba) {
        int red = rgba >> 16 & 0xFF;
        int green = rgba >> 8 & 0xFF;
        int blue = rgba & 0xFF;
        int alpha = rgba >> 24 & 0xFF;
        return alpha << 24 | red << 16 | green << 8 | blue;
    }
}

