/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.exmo.exmodifier.util.ExUtil;
import net.exmo.exmodifier.util.SimpleAttrGather;
import net.exmo.exmodifier.util.gether.AttrGether;
import net.exmo.exmodifier.util.gether.AttrSimpleGether;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class CuriosUtil {
    public static void addAttributeModifierAffix(ItemStack itemStack, AttrSimpleGether attriGether) {
        CompoundTag tag = itemStack.m_41784_();
        if (!tag.m_128441_("ExCurioAttributeModifiers")) {
            tag.m_128365_("ExCurioAttributeModifiers", (Tag)new ListTag());
        }
        ListTag modifiersList = tag.m_128437_("ExCurioAttributeModifiers", 10);
        CompoundTag tag1 = new CompoundTag();
        String attributeID = ExUtil.getAttributeID(attriGether.attribute);
        tag1.m_128359_("AttributeName", attributeID);
        String name = attriGether.exAttributeModifier.getName();
        tag1.m_128359_("Name", name);
        tag1.m_128359_("UUID", UUID.nameUUIDFromBytes((itemStack.toString() + attributeID + name).getBytes()).toString());
        tag1.m_128347_("Amount", attriGether.exAttributeModifier.getAmount());
        tag1.m_128405_("Operation", attriGether.exAttributeModifier.getOperation().m_22235_());
        modifiersList.add((Object)tag1);
    }

    public static void addSimpleAttributeModifierAffix(ItemStack itemStack, SimpleAttrGather attrGather, double amount) {
        CompoundTag tag = itemStack.m_41784_();
        if (!tag.m_128441_("ExCurioAttributeModifiers")) {
            tag.m_128365_("ExCurioAttributeModifiers", (Tag)new ListTag());
        }
        ListTag modifiersList = tag.m_128437_("ExCurioAttributeModifiers", 10);
        CompoundTag tag1 = new CompoundTag();
        tag1.m_128359_("AttributeName", attrGather.attribute());
        tag1.m_128359_("Name", attrGather.name());
        tag1.m_128359_("UUID", String.valueOf(UUID.randomUUID()));
        tag1.m_128347_("Amount", amount);
        tag1.m_128405_("Operation", attrGather.operation().m_22235_());
        modifiersList.add((Object)tag1);
    }

    public static List<AttrGether> getAttributeModifiersAffix(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41783_();
        ArrayList<AttrGether> attrGethers = new ArrayList<AttrGether>();
        if (tag == null) {
            return attrGethers;
        }
        if (tag.m_128441_("ExCurioAttributeModifiers")) {
            ListTag modifiersList = tag.m_128437_("ExCurioAttributeModifiers", 10);
            for (int i = 0; i < modifiersList.size(); ++i) {
                CompoundTag modifier = modifiersList.m_128728_(i);
                String attributeName = modifier.m_128461_("AttributeName");
                String name = modifier.m_128461_("Name");
                double amount = modifier.m_128459_("Amount");
                String string = modifier.m_128461_("UUID");
                UUID uuid = UUID.nameUUIDFromBytes((itemStack.toString() + name + attributeName).getBytes());
                if (string.length() >= 36) {
                    uuid = UUID.fromString(string);
                }
                int operation = modifier.m_128451_("Operation");
                attrGethers.add(new AttrGether(ExUtil.getAttribute(attributeName), new AttributeModifier(uuid, name, amount, AttributeModifier.Operation.m_22236_((int)operation))));
            }
        }
        return attrGethers;
    }

    public static List<String> getSlotsFromItemstack(ItemStack itemStack) {
        Set curioTags = CuriosApi.getItemStackSlots((ItemStack)itemStack, (boolean)false).keySet();
        return new ArrayList<String>(curioTags);
    }

    public static boolean isCuriosItem(ItemStack itemStack) {
        return CuriosApi.getCurio((ItemStack)itemStack).isPresent();
    }

    public static boolean isCuriosItem2(ItemStack itemStack) {
        return !CuriosUtil.getSlotsFromItemstack(itemStack).isEmpty();
    }

    public static List<slotInfo> getCurioAttributeModifiers(ItemStack itemStack) {
        CompoundTag nbt;
        ArrayList<slotInfo> slotInfos = new ArrayList<slotInfo>();
        if (itemStack != null && !itemStack.m_41619_() && (nbt = itemStack.m_41783_()) != null && nbt.m_128425_("CurioAttributeModifiers", 9)) {
            ListTag modifiersList = nbt.m_128437_("CurioAttributeModifiers", 10);
            for (int i = 0; i < modifiersList.size(); ++i) {
                CompoundTag modifier = modifiersList.m_128728_(i);
                String slot = modifier.m_128461_("Slot");
                String attributeName = modifier.m_128461_("AttributeName");
                String name = modifier.m_128461_("Name");
                double amount = modifier.m_128459_("Amount");
                int operation = modifier.m_128451_("Operation");
                String uuid = modifier.m_128461_("UUID");
                UUID uuid1 = uuid.length() < 36 ? UUID.randomUUID() : UUID.fromString(uuid);
                slotInfos.add(new slotInfo(itemStack, attributeName, name, uuid1, amount, AttributeModifier.Operation.m_22236_((int)operation), slot));
            }
        }
        return slotInfos;
    }

    public static void removeAttributeModifierAffix(ItemStack itemStack, String attributeName, String name) {
        CompoundTag tag = itemStack.m_41784_();
        if (!tag.m_128441_("ExCurioAttributeModifiers")) {
            return;
        }
        ListTag modifiersList = tag.m_128437_("ExCurioAttributeModifiers", 10);
        for (int i = 0; i < modifiersList.size(); ++i) {
            CompoundTag modifier = modifiersList.m_128728_(i);
            if (!modifier.m_128461_("AttributeName").equals(attributeName) || !modifier.m_128461_("Name").equals(name)) continue;
            modifiersList.remove(i);
            tag.m_128365_("ExCurioAttributeModifiers", (Tag)modifiersList);
            break;
        }
    }

    public static void removeAttributeModifier(ItemStack itemStack, String attributeName, double amount, int operation, String slot) {
        if (itemStack.m_41783_() == null) {
            return;
        }
        CompoundTag itemTag = itemStack.m_41783_();
        if (itemTag.m_128425_("CurioAttributeModifiers", 9)) {
            ListTag modifiersList = itemTag.m_128437_("CurioAttributeModifiers", 10);
            ListTag newModifiersList = new ListTag();
            for (int i = 0; i < modifiersList.size(); ++i) {
                CompoundTag modifierTag = modifiersList.m_128728_(i);
                if (slot.equals(modifierTag.m_128461_("Slot")) && attributeName.equals(modifierTag.m_128461_("AttributeName")) && modifierTag.m_128459_("Amount") == amount && modifierTag.m_128451_("Operation") == operation) continue;
                newModifiersList.add((Object)modifierTag);
            }
            itemTag.m_128365_("CurioAttributeModifiers", (Tag)newModifiersList);
        }
        itemStack.m_41751_(itemTag);
    }

    public static void addAttributeModifier(ItemStack itemStack, String attributeName, double amount, int operation, String slot) {
        CompoundTag itemTag = itemStack.m_41784_();
        if (!itemTag.m_128425_("CurioAttributeModifiers", 9)) {
            itemTag.m_128365_("CurioAttributeModifiers", (Tag)new ListTag());
        }
        ListTag modifiersList = itemTag.m_128437_("CurioAttributeModifiers", 10);
        boolean found = false;
        for (int i = 0; i < modifiersList.size(); ++i) {
            CompoundTag modifierTag = modifiersList.m_128728_(i);
            if (!slot.equals(modifierTag.m_128461_("Slot")) || !attributeName.equals(modifierTag.m_128461_("AttributeName"))) continue;
            modifierTag.m_128347_("Amount", amount);
            modifierTag.m_128405_("Operation", operation);
            found = true;
            break;
        }
        if (!found) {
            CompoundTag newModifier = new CompoundTag();
            newModifier.m_128359_("Slot", slot);
            newModifier.m_128359_("AttributeName", attributeName);
            newModifier.m_128359_("Name", attributeName);
            newModifier.m_128347_("Amount", amount);
            newModifier.m_128405_("Operation", operation);
            modifiersList.add((Object)newModifier);
        }
        itemTag.m_128365_("CurioAttributeModifiers", (Tag)modifiersList);
        itemStack.m_41751_(itemTag);
    }

    public static boolean isLivingWear(Item item, LivingEntity entity) {
        LazyOptional curiosInventory = CuriosApi.getCuriosInventory((LivingEntity)entity);
        if (!curiosInventory.isPresent()) {
            return false;
        }
        return ((ICuriosItemHandler)curiosInventory.resolve().get()).isEquipped(item);
    }

    public static boolean isLivingWear(ItemStack itemStack, LivingEntity entity) {
        return CuriosUtil.isLivingWear(itemStack.m_41720_(), entity);
    }

    public static class slotInfo {
        public ItemStack stack;
        public String identifie;
        public String name;
        public UUID uuid;
        public double amount;
        public AttributeModifier.Operation operation;
        public String slot;

        public slotInfo(ItemStack stack, String identifie, String name, UUID uuid, double amount, AttributeModifier.Operation operation, String slot) {
            this.stack = stack;
            this.identifie = identifie;
            this.name = name;
            this.uuid = uuid;
            this.amount = amount;
            this.operation = operation;
            this.slot = slot;
        }
    }
}

