/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.util;

import com.google.common.base.CaseFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.exmo.exmodifier.content.dynamicAttributes.DynamicAttribute;
import net.exmo.exmodifier.content.dynamicAttributes.DynamicAttributeRegister;
import net.exmo.exmodifier.content.helper.ModifierEntryHelper;
import net.exmo.exmodifier.content.modifier.ModifierEntry;
import net.exmo.exmodifier.content.specialEffects.SpecialEffect;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ExUtil {
    static HashMap<ResourceLocation, TagKey<ModifierEntry>> _IT = new HashMap();
    static HashMap<Item, String> _IS = new HashMap();
    static Map<Attribute, String> _AS = new HashMap<Attribute, String>();

    public static boolean hasSpecialEffect(SpecialEffect effect, Player player) {
        for (ItemStack eq : player.m_150109_().f_35975_) {
            for (ModifierEntry modifierEntry : ModifierEntryHelper.of(eq).getModifierEntriesB()) {
                if (!modifierEntry.hasSpecialEffect(effect)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasSpecialEffect(String effect, Player player) {
        for (ItemStack eq : player.m_150109_().f_35975_) {
            for (ModifierEntry modifierEntry : ModifierEntryHelper.of(eq).getModifierEntriesB()) {
                if (!modifierEntry.hasSpecialEffect(effect)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean ifHasSpecialEffect(SpecialEffect effect, Player player, Consumer<ModifierEntry> consumer) {
        for (ItemStack eq : player.m_150109_().f_35975_) {
            for (ModifierEntry modifierEntry : ModifierEntryHelper.of(eq).getModifierEntriesB()) {
                if (!modifierEntry.hasSpecialEffect(effect)) continue;
                consumer.accept(modifierEntry);
                return true;
            }
        }
        return false;
    }

    public static boolean ifHasSpecialEffect(String effect, Player player, Consumer<ModifierEntry> consumer) {
        for (ItemStack eq : player.m_150109_().f_35975_) {
            for (ModifierEntry modifierEntry : ModifierEntryHelper.of(eq).getModifierEntriesB()) {
                if (!modifierEntry.hasSpecialEffect(effect)) continue;
                consumer.accept(modifierEntry);
                return true;
            }
        }
        return false;
    }

    public static boolean ifHasSpecialEffectAll(String effect, Player player, Consumer<ModifierEntry> consumer) {
        for (EquipmentSlot eq : EquipmentSlot.values()) {
            ItemStack item = player.m_6844_(eq);
            for (ModifierEntry modifierEntry : ModifierEntryHelper.of(item).getModifierEntriesB()) {
                if (!modifierEntry.hasSpecialEffect(effect)) continue;
                consumer.accept(modifierEntry);
                return true;
            }
        }
        return false;
    }

    public static boolean hasSpecialEffect(SpecialEffect effect, Player player, EquipmentSlot equipmentSlot) {
        for (ModifierEntry modifierEntry : ModifierEntryHelper.of(player.m_6844_(equipmentSlot)).getModifierEntriesB()) {
            if (!modifierEntry.hasSpecialEffect(effect)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSpecialEffect(String effect, Player player, EquipmentSlot equipmentSlot) {
        for (ModifierEntry modifierEntry : ModifierEntryHelper.of(player.m_6844_(equipmentSlot)).getModifierEntriesB()) {
            if (!modifierEntry.hasSpecialEffect(effect)) continue;
            return true;
        }
        return false;
    }

    public static boolean ifHasSpecialEffect(SpecialEffect effect, Player player, EquipmentSlot equipmentSlot, Consumer<ModifierEntry> consumer) {
        for (ModifierEntry modifierEntry : ModifierEntryHelper.of(player.m_6844_(equipmentSlot)).getModifierEntriesB()) {
            if (!modifierEntry.hasSpecialEffect(effect)) continue;
            consumer.accept(modifierEntry);
            return true;
        }
        return false;
    }

    public static boolean ifHasSpecialEffect(SpecialEffect effect, Player player, Consumer<ModifierEntry> consumer, EquipmentSlot ... equipmentSlot) {
        for (EquipmentSlot e : equipmentSlot) {
            for (ModifierEntry modifierEntry : ModifierEntryHelper.of(player.m_6844_(e)).getModifierEntriesB()) {
                if (!modifierEntry.hasSpecialEffect(effect)) continue;
                consumer.accept(modifierEntry);
                return true;
            }
        }
        return false;
    }

    public static boolean ifHasSpecialEffect(String effect, Player player, EquipmentSlot equipmentSlot, Consumer<ModifierEntry> consumer) {
        for (ModifierEntry modifierEntry : ModifierEntryHelper.of(player.m_6844_(equipmentSlot)).getModifierEntriesB()) {
            if (!modifierEntry.hasSpecialEffect(effect)) continue;
            consumer.accept(modifierEntry);
            return true;
        }
        return false;
    }

    public static TagKey<ModifierEntry> createOrGetModifierTagKey(ResourceLocation key) {
        if (_IT.containsKey(key)) {
            return _IT.get(key);
        }
        TagKey tagKey = TagKey.m_203882_(ModifierEntry.MODIFIER_KEY, (ResourceLocation)key);
        _IT.put(key, (TagKey<ModifierEntry>)tagKey);
        return tagKey;
    }

    public static String classToString(Class<?> clazz) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, clazz.getSimpleName());
    }

    public static String getItemID(Item item) {
        if (_IS.containsKey(item)) {
            return _IS.get(item);
        }
        String id = ForgeRegistries.ITEMS.getKey((Object)item).toString();
        _IS.put(item, id);
        return id;
    }

    public static String getItemID(RegistryObject<Item> registryObject) {
        return registryObject.getKey().toString();
    }

    public static String getItemID(ItemStack stack) {
        return ExUtil.getItemID(stack.m_41720_());
    }

    public static String getAttributeID(Attribute attribute) {
        DynamicAttribute dynamicAttribute;
        if (attribute == null) {
            return "";
        }
        if (attribute instanceof DynamicAttribute && DynamicAttributeRegister.dynamicAttributes.containsValue((Object)(dynamicAttribute = (DynamicAttribute)attribute))) {
            return dynamicAttribute.attributeId();
        }
        if (_AS.containsKey(attribute)) {
            return _AS.get(attribute);
        }
        String string = ForgeRegistries.ATTRIBUTES.getKey((Object)attribute).toString();
        _AS.put(attribute, string);
        return string;
    }

    public static Attribute getAttribute(String attribute) {
        return _AS.values().stream().filter(s -> s.equals(attribute)).findFirst().map(s -> (Attribute)_AS.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(s)).findFirst().get().getKey()).orElse(null);
    }

    public static String getAttributeID(RegistryObject<Attribute> attribute) {
        return ExUtil.getAttributeID((Attribute)attribute.get());
    }
}

