/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.exmo.exmodifier.Exmodifier;
import net.exmo.exmodifier.util.ExAttributeModifier;
import net.exmo.exmodifier.util.ExUtil;
import net.exmo.exmodifier.util.gether.AttriGether;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemAttrUtil {
    public static Map<String, attrgroup> attmap = new HashMap<String, attrgroup>();

    @SubscribeEvent
    public static void addbaseattributes(ItemAttributeModifierEvent event) {
        ArrayList removelist = new ArrayList();
        attmap.forEach((id, attrgroup2) -> {
            EquipmentSlot slot;
            ItemStack itemStack = event.getItemStack();
            String itemKey = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()).toString();
            if (Objects.equals(id, itemKey) && (slot = attrgroup2.getEquipmentSlot()) != null && slot == event.getSlotType()) {
                event.addModifier(attrgroup2.attr, attrgroup2.attributeModifier);
            }
        });
        for (int i = 0; i < removelist.size(); ++i) {
            attmap.remove(removelist.get(i));
        }
    }

    public EquipmentSlot getEquipmentSlot(String s) {
        return EquipmentSlot.m_20747_((String)s);
    }

    public static String getattrstringamount(ItemStack itemStack, EquipmentSlot equipmentSlot, Attribute pAttribute) {
        HashMap<Attribute, String> zh = new HashMap<Attribute, String>();
        ArrayList amount = new ArrayList();
        zh.put(Attributes.f_22281_, "\u653b\u51fb\u4f24\u5bb3");
        String[] disattrname = new String[1];
        zh.forEach((k1, v1) -> {
            if (k1 == pAttribute) {
                disattrname[0] = v1;
            }
        });
        itemStack.m_41638_(equipmentSlot).forEach((k, v) -> {
            if (k == pAttribute) {
                amount.add(v.m_22218_());
            }
        });
        double finalamount = 0.0;
        for (int i = 0; i < amount.size(); ++i) {
            finalamount += ((Double)amount.get(i)).doubleValue();
        }
        String finalstring = disattrname[0] + ":" + (finalamount + 1.0);
        return finalstring;
    }

    public static double getAmountFromAttributeName(ItemStack stack, Attribute attribute, String name) {
        if (attribute == null) {
            return 0.0;
        }
        ListTag listtag = stack.m_41783_().m_128437_("ExAttributeModifiers", 10);
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundTag = listtag.m_128728_(i);
            if (!compoundTag.m_128461_("AttributeName").equals(ExUtil.getAttributeID(attribute).toString()) || !compoundTag.m_128461_("Name").equals(name)) continue;
            return compoundTag.m_128459_("Amount");
        }
        return 0.0;
    }

    public static List<AttributeModifier> getAttributeModifiers(ItemStack stack, Attribute attribute) {
        ArrayList<AttributeModifier> list = new ArrayList<AttributeModifier>();
        if (stack.m_41783_() != null && stack.m_41783_().m_128425_("ExAttributeModifiers", 9)) {
            ListTag listtag = stack.m_41783_().m_128437_("ExAttributeModifiers", 10);
            int i = 0;
            while (i < listtag.size()) {
                CompoundTag compoundTag;
                if (!(compoundTag = listtag.m_128728_(++i)).m_128461_("AttributeName").equals(ExUtil.getAttributeID(attribute).toString())) continue;
                String modifierName = compoundTag.m_128461_("Name");
                AttributeModifier.Operation operation = AttributeModifier.Operation.m_22236_((int)compoundTag.m_128451_("Operation"));
                double amount = compoundTag.m_128459_("Amount");
                list.add(new AttributeModifier(modifierName, amount, operation));
            }
        }
        return list;
    }

    public static List<AttriGether> getAttributeModifiers(ItemStack stack) {
        ArrayList<AttriGether> list = new ArrayList<AttriGether>();
        if (stack.m_41783_() != null && stack.m_41783_().m_128425_("ExAttributeModifiers", 9)) {
            ListTag listtag = stack.m_41783_().m_128437_("ExAttributeModifiers", 10);
            int i = 0;
            while (i < listtag.size()) {
                CompoundTag compoundTag = listtag.m_128728_(++i);
                String modifierName = compoundTag.m_128461_("Name");
                AttributeModifier.Operation operation = AttributeModifier.Operation.m_22236_((int)compoundTag.m_128451_("Operation"));
                double amount = compoundTag.m_128459_("Amount");
                Attribute pAttribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(ResourceLocation.m_135820_((String)compoundTag.m_128461_("AttributeName")));
                list.add(new AttriGether(pAttribute, new ExAttributeModifier(modifierName, amount, operation), EquipmentSlot.m_20747_((String)compoundTag.m_128461_("Slot"))));
            }
        }
        return list;
    }

    public static ExAttributeModifier getAttributeModifierFromNamed(String name, ItemStack stack) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128425_("ExAttributeModifiers", 9)) {
            ListTag listtag = stack.m_41783_().m_128437_("ExAttributeModifiers", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundTag = listtag.m_128728_(i);
                if (!compoundTag.m_128461_("Name").equals(name)) continue;
                return ItemAttrUtil.getAttributeModifierFromCompoundTag(compoundTag);
            }
        }
        return null;
    }

    public static void addItemAttributeModifier(ItemStack itemStack, Attribute pAttribute, ExAttributeModifier pModifier, EquipmentSlot[] pSlot) {
        if (!ForgeRegistries.ATTRIBUTES.containsValue((Object)pAttribute)) {
            Exmodifier.LOGGER.Logger.error("Attribute " + String.valueOf(pAttribute) + " does not exist");
            return;
        }
        Exmodifier.LOGGER.debug("add attribute: " + String.valueOf(pAttribute) + " " + pAttribute.m_22087_());
        itemStack.m_41784_();
        if (!itemStack.m_41783_().m_128425_("ExAttributeModifiers", 9)) {
            itemStack.m_41783_().m_128365_("ExAttributeModifiers", (Tag)new ListTag());
        }
        ListTag listtag = itemStack.m_41783_().m_128437_("ExAttributeModifiers", 10);
        for (EquipmentSlot slot : pSlot) {
            listtag.add((Object)ItemAttrUtil.getAttributeModifierCompoundTag(pAttribute, pModifier, slot));
        }
    }

    public static boolean hasDifferentAttributeValue(ItemStack itemStack, Attribute pAttribute, ExAttributeModifier pModifier, EquipmentSlot pSlot) {
        if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128425_("ExAttributeModifiers", 9)) {
            ListTag listtag = itemStack.m_41783_().m_128437_("ExAttributeModifiers", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundTag = listtag.m_128728_(i);
                if (!compoundTag.m_128441_("AttributeName") || !compoundTag.m_128461_("AttributeName").equals(ExUtil.getAttributeID(pAttribute)) || !compoundTag.m_128441_("Name") || !compoundTag.m_128461_("Name").equals(pModifier.getName()) || !compoundTag.m_128441_("Operation") || compoundTag.m_128451_("Operation") != pModifier.getOperation().m_22235_() || compoundTag.m_128441_("Slot") && pSlot != null && (!compoundTag.m_128441_("Slot") || !compoundTag.m_128461_("Slot").equals(pSlot.m_20751_())) || !compoundTag.m_128441_("Amount") || compoundTag.m_128459_("Amount") == pModifier.getAmount()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasAttributeModifierCompoundTagNoAmount(ItemStack itemStack, Attribute pAttribute, ExAttributeModifier pModifier, EquipmentSlot pSlot) {
        if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128425_("ExAttributeModifiers", 9)) {
            ListTag listtag = itemStack.m_41783_().m_128437_("ExAttributeModifiers", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundTag = listtag.m_128728_(i);
                if (!compoundTag.m_128441_("AttributeName") || !compoundTag.m_128461_("AttributeName").equals(ExUtil.getAttributeID(pAttribute).toString()) || !compoundTag.m_128441_("Name") || !compoundTag.m_128461_("Name").equals(pModifier.getName()) || !compoundTag.m_128441_("Operation") || compoundTag.m_128451_("Operation") != pModifier.getOperation().m_22235_() || compoundTag.m_128441_("Slot") && pSlot != null && (!compoundTag.m_128441_("Slot") || !compoundTag.m_128461_("Slot").equals(pSlot.m_20751_()))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasAttributeModifierByUUID(ItemStack itemStack, Attribute pAttribute, UUID pModifierUUID, EquipmentSlot pSlot) {
        if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128425_("ExAttributeModifiers", 9)) {
            ListTag listtag = itemStack.m_41783_().m_128437_("ExAttributeModifiers", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundTag = listtag.m_128728_(i);
                if (!compoundTag.m_128441_("AttributeName") || !compoundTag.m_128461_("AttributeName").equals(ExUtil.getAttributeID(pAttribute).toString()) || !compoundTag.m_128441_("UUIDMost") || compoundTag.m_128454_("UUIDMost") != pModifierUUID.getMostSignificantBits() || !compoundTag.m_128441_("UUIDLeast") || compoundTag.m_128454_("UUIDLeast") != pModifierUUID.getLeastSignificantBits() || compoundTag.m_128441_("Slot") && pSlot != null && (!compoundTag.m_128441_("Slot") || !compoundTag.m_128461_("Slot").equals(pSlot.m_20751_()))) continue;
                return true;
            }
        }
        return false;
    }

    public static void removeAttributeModifierNoAmout(ItemStack itemStack, Attribute pAttribute, ExAttributeModifier pModifier, EquipmentSlot pSlot) {
        if (!ForgeRegistries.ATTRIBUTES.containsValue((Object)pAttribute)) {
            return;
        }
        if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128425_("ExAttributeModifiers", 9)) {
            ListTag listtag = itemStack.m_41783_().m_128437_("ExAttributeModifiers", 10);
            int i = 0;
            while (i < listtag.size()) {
                CompoundTag compoundTag = listtag.m_128728_(i);
                if (compoundTag.m_128441_("AttributeName") && compoundTag.m_128461_("AttributeName").equals(ExUtil.getAttributeID(pAttribute).toString()) && compoundTag.m_128441_("Name") && compoundTag.m_128461_("Name").equals(pModifier.getName()) && compoundTag.m_128441_("Operation") && compoundTag.m_128451_("Operation") == pModifier.getOperation().m_22235_() && (!compoundTag.m_128441_("Slot") || pSlot == null || compoundTag.m_128441_("Slot") && compoundTag.m_128461_("Slot").equals(pSlot.m_20751_()))) {
                    listtag.remove(i);
                    continue;
                }
                ++i;
            }
        }
    }

    public static void removeAttributeModifier(ItemStack itemStack, Attribute pAttribute, ExAttributeModifier pModifier, EquipmentSlot pSlot) {
        if (!ForgeRegistries.ATTRIBUTES.containsValue((Object)pAttribute)) {
            return;
        }
        if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128425_("ExAttributeModifiers", 9)) {
            ListTag listtag = itemStack.m_41783_().m_128437_("ExAttributeModifiers", 10);
            int i = 0;
            while (i < listtag.size()) {
                CompoundTag compoundTag = listtag.m_128728_(i);
                if (compoundTag.m_128441_("AttributeName") && compoundTag.m_128461_("AttributeName").equals(ExUtil.getAttributeID(pAttribute).toString()) && compoundTag.m_128441_("Name") && compoundTag.m_128459_("Amount") == pModifier.getAmount() && compoundTag.m_128461_("Name").equals(pModifier.getName()) && compoundTag.m_128441_("Operation") && compoundTag.m_128451_("Operation") == pModifier.getOperation().m_22235_() && (!compoundTag.m_128441_("Slot") || pSlot == null || compoundTag.m_128441_("Slot") && compoundTag.m_128461_("Slot").equals(pSlot.m_20751_()))) {
                    listtag.remove(i);
                    continue;
                }
                ++i;
            }
        }
    }

    public static void removeAttributeModifierINUUID(ItemStack itemStack, Attribute pAttribute, AttributeModifier pModifier, EquipmentSlot pSlot) {
        if (!ForgeRegistries.ATTRIBUTES.containsValue((Object)pAttribute)) {
            return;
        }
        if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128425_("ExAttributeModifiers", 9)) {
            ListTag listtag = itemStack.m_41783_().m_128437_("ExAttributeModifiers", 10);
            int i = 0;
            while (i < listtag.size()) {
                CompoundTag compoundTag = listtag.m_128728_(i);
                if (compoundTag.m_128441_("AttributeName") && compoundTag.m_128461_("AttributeName").equals(ExUtil.getAttributeID(pAttribute).toString()) && compoundTag.m_128459_("Amount") == pModifier.m_22218_() && compoundTag.m_128441_("Name") && compoundTag.m_128461_("Name").equals(pModifier.m_22214_()) && compoundTag.m_128441_("Operation") && compoundTag.m_128451_("Operation") == pModifier.m_22217_().m_22235_() && (!compoundTag.m_128441_("Slot") || pSlot == null || compoundTag.m_128441_("Slot") && compoundTag.m_128461_("Slot").equals(pSlot.m_20751_()))) {
                    listtag.remove(i);
                    continue;
                }
                ++i;
            }
        }
    }

    public static void addItemAttributeModifier2(ItemStack itemStack, Attribute pAttribute, ExAttributeModifier pModifier, EquipmentSlot pSlot) {
        try {
            if (ItemAttrUtil.hasDifferentAttributeValue(itemStack, pAttribute, pModifier, pSlot)) {
                ExAttributeModifier currentModifier = ItemAttrUtil.getAttributeModifierFromCompoundTag(ItemAttrUtil.getAttributeModifierCompoundTag(pAttribute, pModifier, pSlot));
                if (currentModifier != null) {
                    double oldAmount = currentModifier.getAmount();
                    double updatedAmount = Math.min(oldAmount + pModifier.getAmount(), Double.MAX_VALUE);
                    ExAttributeModifier updatedModifier = new ExAttributeModifier(pModifier.getName(), updatedAmount, pModifier.getOperation());
                    ItemAttrUtil.removeAttributeModifier(itemStack, pAttribute, currentModifier, pSlot);
                    ItemAttrUtil.addItemAttributeModifier(itemStack, pAttribute, updatedModifier, new EquipmentSlot[]{pSlot});
                } else {
                    System.err.println("Failed to retrieve the current attribute modifier.");
                }
            } else {
                ItemAttrUtil.addItemAttributeModifier(itemStack, pAttribute, pModifier, new EquipmentSlot[]{pSlot});
            }
        }
        catch (Exception e) {
            System.err.println("An error occurred while adding or updating an item attribute modifier: " + e.getMessage());
        }
    }

    public static void putattinattmap(String name, attrgroup attgroup) {
        attmap.put(name, attgroup);
    }

    public static CompoundTag getAttributeModifierCompoundTag(Attribute attribute, ExAttributeModifier modifier, EquipmentSlot slot) {
        if (modifier == null) {
            return null;
        }
        if (attribute == null) {
            return null;
        }
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.m_128359_("AttributeName", ExUtil.getAttributeID(attribute));
        compoundtag.m_128405_("Operation", modifier.getOperation().m_22235_());
        compoundtag.m_128362_("UUID", Mth.m_216261_((RandomSource)RandomSource.m_216343_()));
        compoundtag.m_128347_("Amount", modifier.getAmount());
        compoundtag.m_128359_("Name", modifier.getName());
        if (slot != null) {
            compoundtag.m_128359_("Slot", slot.m_20751_());
        }
        return compoundtag;
    }

    public static ExAttributeModifier getAttributeModifierFromCompoundTag(CompoundTag compoundTag) {
        if (compoundTag.m_128441_("AttributeName") && compoundTag.m_128441_("Name") && compoundTag.m_128441_("Operation")) {
            ResourceLocation attributeId = new ResourceLocation(compoundTag.m_128461_("AttributeName"));
            String modifierName = compoundTag.m_128461_("Name");
            AttributeModifier.Operation operation = AttributeModifier.Operation.m_22236_((int)compoundTag.m_128451_("Operation"));
            double amount = compoundTag.m_128459_("Amount");
            return new ExAttributeModifier(modifierName, amount, operation);
        }
        return null;
    }

    public static void EntityAddAttr(LivingEntity livingEntity, UUID uuid, String name, double amount, Attribute attribute, AttributeModifier.Operation operation) {
        if (!Objects.requireNonNull(livingEntity.m_21051_(attribute)).m_22109_(new AttributeModifier(uuid, name, amount, operation))) {
            Objects.requireNonNull(livingEntity.m_21051_(attribute)).m_22125_(new AttributeModifier(uuid, name, amount, operation));
        }
    }

    public static class attrgroup {
        private EquipmentSlot slot;
        private Attribute attr;
        private AttributeModifier attributeModifier;

        public attrgroup(EquipmentSlot slot, Attribute attr, AttributeModifier attributeModifier) {
            if (slot == null || attr == null || attributeModifier == null) {
                throw new IllegalArgumentException("All arguments must be non-null");
            }
            this.slot = slot;
            this.attr = attr;
            this.attributeModifier = attributeModifier;
        }

        public EquipmentSlot getEquipmentSlot() {
            return this.slot;
        }

        public Attribute getAttr() {
            return this.attr;
        }

        public AttributeModifier getAttributeModifier() {
            return this.attributeModifier;
        }
    }
}

