/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.util;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import net.exmo.exmodifier.util.ExUtil;
import net.exmo.exmodifier.util.exSerialize.ExSerialize;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public final class ItemSelector {
    public static final ExSerialize<ItemSelector> EX_SERIALIZE = ExSerialize.create(() -> new ItemSelector(null, new ArrayList<String>(), new ArrayList<CompoundTag>(), CompareType.EMPTY, new ArrayList<TagKey<Item>>(), null)).addStringListField("itemId", itemSelector -> itemSelector.itemId, (itemSelector, s) -> itemSelector.itemId.addAll((Collection<String>)s)).addStringListField("nbt", itemSelector -> itemSelector.containNBT.stream().map(Tag::m_7916_).toList(), (itemSelector, s) -> {
        for (String a : s) {
            try {
                itemSelector.containNBT.add(TagParser.m_129359_((String)a));
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }).addStringListField("containTag", itemSelector -> itemSelector.containTag.stream().map(TagKey::f_203868_).map(ResourceLocation::toString).toList(), (itemSelector, s) -> {
        for (String a : s) {
            itemSelector.containTag.add((TagKey<Item>)TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)new ResourceLocation(a)));
        }
    }).addStringField("type", ItemSelector::getTypeID, (itemSelector, s) -> {
        itemSelector.type = CompareType.valueOf(s);
    });
    private final Item item;
    private final List<String> itemId;
    private final List<CompoundTag> containNBT;
    private CompareType type;
    private final List<TagKey<Item>> containTag;
    private final BiConsumer<ItemStack, AtomicBoolean> customCompare;

    public String getTypeID() {
        return this.type.name();
    }

    public ItemSelector(Item item, String itemId, List<CompoundTag> containNBT, CompareType type2, List<TagKey<Item>> containTag, BiConsumer<ItemStack, AtomicBoolean> customCompare) {
        this(item, Collections.singletonList(itemId), containNBT, type2, containTag, customCompare);
    }

    public ItemSelector(Item item, List<String> itemId, List<CompoundTag> containNBT, CompareType type2, List<TagKey<Item>> containTag, BiConsumer<ItemStack, AtomicBoolean> customCompare) {
        this.item = item;
        this.itemId = itemId;
        this.containNBT = containNBT != null ? containNBT : List.of();
        this.type = type2;
        this.containTag = containTag != null ? containTag : List.of();
        this.customCompare = customCompare;
    }

    public ItemSelector(Item item, String itemId, List<CompoundTag> containNBT, CompareType type2, List<TagKey<Item>> containTag) {
        this(item, itemId, containNBT, type2, containTag, (ItemStack e, AtomicBoolean b) -> b.set(false));
    }

    public ItemSelector(BiConsumer<ItemStack, AtomicBoolean> customCompare) {
        this(null, List.of(), List.of(), CompareType.CUSTOM, List.of(), customCompare);
    }

    public ItemSelector() {
        this(null, null, List.of(), CompareType.EMPTY, List.of());
    }

    public static ItemSelector fromItem(Item item) {
        return new ItemSelector(item, null, null, CompareType.ITEM, null);
    }

    public boolean compare(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        String itemID = ExUtil.getItemID(stack);
        return switch (this.type) {
            case CompareType.TAG -> this.checkTags(stack);
            case CompareType.CUSTOM -> {
                AtomicBoolean u = new AtomicBoolean(false);
                this.customCompare.accept(stack, u);
                yield u.get();
            }
            case CompareType.ID -> this.itemId.contains(itemID);
            case CompareType.ITEM -> Objects.equals(stack.m_41720_(), this.item);
            case CompareType.NBT -> this.checkNBT(stack);
            case CompareType.NBT_AND_ITEM -> {
                if (Objects.equals(stack.m_41720_(), this.item) && this.checkNBT(stack)) {
                    yield true;
                }
                yield false;
            }
            case CompareType.NBT_AND_ID -> {
                if (this.itemId.contains(itemID) && this.checkNBT(stack)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public boolean compareItemSelector(ItemSelector itemSelector) {
        if (itemSelector.item != null && this.item != null && itemSelector.item != this.item) {
            return false;
        }
        if (itemSelector.itemId != null && this.itemId != null && !itemSelector.itemId.equals(this.itemId)) {
            return false;
        }
        if (itemSelector.containNBT != null && this.containNBT != null && !itemSelector.containNBT.equals(this.containNBT)) {
            return false;
        }
        return itemSelector.containTag == null || this.containTag == null || itemSelector.containTag.equals(this.containTag);
    }

    private boolean checkTags(ItemStack stack) {
        for (TagKey<Item> tag : this.containTag) {
            if (!stack.m_204117_(tag)) continue;
            return true;
        }
        return false;
    }

    private boolean checkNBT(ItemStack stack) {
        CompoundTag stackTag = stack.m_41783_();
        if (stackTag == null) {
            return this.containNBT.isEmpty();
        }
        for (CompoundTag conditionNBT : this.containNBT) {
            if (!this.isSubset(conditionNBT, stackTag)) continue;
            return true;
        }
        return false;
    }

    private boolean isSubset(CompoundTag condition, CompoundTag target) {
        for (String key : condition.m_128431_()) {
            Tag conditionTag = condition.m_128423_(key);
            Tag targetTag = target.m_128423_(key);
            if (targetTag == null) {
                return false;
            }
            if (conditionTag instanceof CompoundTag) {
                CompoundTag targetCompound;
                CompoundTag conditionCompound = (CompoundTag)conditionTag;
                if (targetTag instanceof CompoundTag && this.isSubset(conditionCompound, targetCompound = (CompoundTag)targetTag)) continue;
                return false;
            }
            if (conditionTag.equals(targetTag)) continue;
            return false;
        }
        return true;
    }

    public static ItemSelector fromNBT(CompoundTag tag) {
        Item item = null;
        String itemId = tag.m_128461_("ItemId");
        if (!itemId.isEmpty()) {
            item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId));
        }
        CompareType type2 = CompareType.valueOf(tag.m_128461_("CompareType"));
        ArrayList<CompoundTag> containNBT = new ArrayList<CompoundTag>();
        if (tag.m_128425_("ContainNBT", 9)) {
            ListTag nbtList = tag.m_128437_("ContainNBT", 10);
            for (Tag nbtTag : nbtList) {
                if (!(nbtTag instanceof CompoundTag)) continue;
                CompoundTag compoundTag = (CompoundTag)nbtTag;
                containNBT.add(compoundTag);
            }
        }
        ArrayList<TagKey<Item>> containTag = new ArrayList<TagKey<Item>>();
        if (tag.m_128425_("ContainTag", 9)) {
            ListTag tagList = tag.m_128437_("ContainTag", 8);
            for (Tag stringTag : tagList) {
                if (!(stringTag instanceof StringTag)) continue;
                StringTag stringTagInstance = (StringTag)stringTag;
                containTag.add((TagKey<Item>)TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)new ResourceLocation(stringTagInstance.m_7916_())));
            }
        }
        return new ItemSelector(item, itemId, containNBT, type2, containTag);
    }

    public Item item() {
        return this.item;
    }

    public List<String> itemId() {
        return this.itemId;
    }

    public List<CompoundTag> containNBT() {
        return this.containNBT;
    }

    public CompareType type() {
        return this.type;
    }

    public List<TagKey<Item>> containTag() {
        return this.containTag;
    }

    public BiConsumer<ItemStack, AtomicBoolean> customCompare() {
        return this.customCompare;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ItemSelector that = (ItemSelector)obj;
        return Objects.equals(this.item, that.item) && Objects.equals(this.itemId, that.itemId) && Objects.equals(this.containNBT, that.containNBT) && Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.containTag, that.containTag) && Objects.equals(this.customCompare, that.customCompare);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.item, this.itemId, this.containNBT, this.type, this.containTag, this.customCompare});
    }

    public String toString() {
        return "ItemSelector[item=" + String.valueOf(this.item) + ", itemId=" + String.valueOf(this.itemId) + ", containNBT=" + String.valueOf(this.containNBT) + ", type=" + String.valueOf((Object)this.type) + ", containTag=" + String.valueOf(this.containTag) + ", customCompare=" + String.valueOf(this.customCompare) + "]";
    }

    public static enum CompareType {
        EMPTY,
        TAG,
        ID,
        ITEM,
        NBT,
        NBT_AND_ITEM,
        NBT_AND_ID,
        CUSTOM;

    }
}

