/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.exmo.exmodifier.Exmodifier;
import net.exmo.exmodifier.content.modifier.ModifierAttriGether;
import net.exmo.exmodifier.content.modifier.ModifierEntry;
import net.exmo.exmodifier.content.modifier.ModifierHandle;
import net.exmo.exmodifier.util.WeightedUtil;

public class ModifierSelector {
    public static SelectionResult selectEntries(WeightedUtil<String> weightedUtil, int refreshments, Function<String, ModifierEntry> entryGetter) {
        ArrayList<ModifierEntry> selectedEntries = new ArrayList<ModifierEntry>();
        ArrayList<ModifierAttriGether> attributes = new ArrayList<ModifierAttriGether>();
        boolean hasExclusive = false;
        int remaining = Math.min(refreshments, weightedUtil.weights.size());
        WeightedUtil<String> workingUtil = weightedUtil.copy();
        while (selectedEntries.size() < remaining && !hasExclusive) {
            String selectedKey = workingUtil.selectRandomKeyBasedOnWeights();
            ModifierEntry entry = entryGetter.apply(selectedKey);
            if (entry == null || selectedEntries.contains(entry)) {
                Exmodifier.LOGGER.Logger.debug("Skipping invalid or duplicate entry: {}", (Object)selectedKey);
                continue;
            }
            workingUtil.removeKey(selectedKey);
            selectedEntries.add(entry);
            Exmodifier.LOGGER.Logger.debug("Added modifier entry: {}", (Object)entry.id);
            if (entry.OnlyHasThisEntry) {
                hasExclusive = true;
                attributes.clear();
                attributes.addAll(ModifierSelector.processAttributes(entry));
                break;
            }
            attributes.addAll(ModifierSelector.processAttributes(entry));
        }
        return new SelectionResult(selectedEntries, attributes, hasExclusive);
    }

    public static SimpleSelectionResult selectEntriesOnly(WeightedUtil<String> weightedUtil, int maxEntries, Function<String, ModifierEntry> entryGetter) {
        List<ModifierEntry> selectedEntries = new ArrayList<ModifierEntry>();
        boolean hasExclusive = false;
        int remaining = Math.min(maxEntries, weightedUtil.weights.size());
        WeightedUtil<String> workingUtil = weightedUtil.copy();
        while (selectedEntries.size() < remaining && !hasExclusive) {
            String selectedKey = workingUtil.selectRandomKeyBasedOnWeights();
            ModifierEntry entry = entryGetter.apply(selectedKey);
            if (entry == null || selectedEntries.contains(entry)) {
                Exmodifier.LOGGER.Logger.debug("\u8df3\u8fc7\u65e0\u6548\u6216\u91cd\u590d\u8bcd\u6761: {}", (Object)selectedKey);
                continue;
            }
            workingUtil.removeKey(selectedKey);
            selectedEntries.add(entry);
            Exmodifier.LOGGER.Logger.debug("\u5df2\u9009\u62e9\u8bcd\u6761: {}", (Object)entry.id);
            if (!entry.OnlyHasThisEntry) continue;
            hasExclusive = true;
            if (selectedEntries.size() <= 1) break;
            selectedEntries = List.of(entry);
            break;
        }
        return new SimpleSelectionResult(selectedEntries, hasExclusive);
    }

    private static List<ModifierAttriGether> processAttributes(ModifierEntry entry) {
        return ModifierHandle.CommonEvent.selectModifierAttributes(entry);
    }

    public record SelectionResult(List<ModifierEntry> entries, List<ModifierAttriGether> attributes, boolean hasExclusiveEntry) {
    }

    public static class SimpleSelectionResult {
        public final List<ModifierEntry> entries;
        public final boolean hasExclusiveEntry;

        public SimpleSelectionResult(List<ModifierEntry> entries, boolean hasExclusiveEntry) {
            this.entries = entries;
            this.hasExclusiveEntry = hasExclusiveEntry;
        }
    }
}

