/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class WeightedUtil<T> {
    public Map<T, Float> weights = new HashMap<T, Float>();
    private float totalWeight;
    private float[] cumulativeWeights;

    public WeightedUtil(Map<T, Float> weights) {
        this.weights.putAll(weights);
        this.totalWeight = this.calculateTotalWeight();
        this.cumulativeWeights = this.calculateCumulativeWeights();
    }

    public void merge(WeightedUtil<T> other) {
        other.weights.forEach((key, value) -> this.weights.merge((T)key, (Float)value, Float::sum));
    }

    public void removeKey(T key) {
        this.weights.remove(key);
        this.totalWeight = this.calculateTotalWeight();
        this.cumulativeWeights = this.calculateCumulativeWeights();
    }

    private float calculateTotalWeight() {
        float total = 0.0f;
        for (Float weight : this.weights.values()) {
            total += weight.floatValue();
        }
        return total;
    }

    private float[] calculateCumulativeWeights() {
        int size = 0;
        for (Float ignored : this.weights.values()) {
            ++size;
        }
        float[] cumulativeWeights = new float[size];
        float sum = 0.0f;
        int index = 0;
        for (Float weight : this.weights.values()) {
            cumulativeWeights[index++] = sum += weight.floatValue();
        }
        return cumulativeWeights;
    }

    public float getProbability(T key) {
        Float weight = this.weights.get(key);
        return weight != null ? weight.floatValue() / this.totalWeight : 0.0f;
    }

    public T selectRandomKeyBasedOnWeights() {
        if (this.weights.isEmpty()) {
            return null;
        }
        Random random = new Random();
        float value = random.nextFloat() * this.totalWeight;
        int index = this.findIndexForValue(value);
        Object[] keys = this.weights.keySet().toArray();
        if (index >= 0 && index < keys.length) {
            return (T)keys[index];
        }
        return null;
    }

    public int size() {
        return this.weights.size();
    }

    public T selectRandomKeyBasedOnWeightsAndRemoved() {
        if (this.weights.isEmpty()) {
            return null;
        }
        T t = this.selectRandomKeyBasedOnWeights();
        this.weights.remove(t);
        return t;
    }

    private int findIndexForValue(float value) {
        int index = -1;
        for (int i = 0; i < this.cumulativeWeights.length; ++i) {
            if (!(value <= this.cumulativeWeights[i])) continue;
            index = i;
            break;
        }
        return index;
    }

    public void increaseWeightsByRarity(int rarity) {
        HashMap<T, Float> newWeights = new HashMap<T, Float>();
        for (Map.Entry<T, Float> entry : this.weights.entrySet()) {
            float newWeight = entry.getValue().floatValue() + (float)rarity / 2.0f / entry.getValue().floatValue();
            if (newWeight <= 0.0f) {
                newWeight = 1.0f;
            }
            newWeights.put(entry.getKey(), Float.valueOf(newWeight));
        }
        this.weights = newWeights;
        this.totalWeight = this.calculateTotalWeight();
        this.cumulativeWeights = this.calculateCumulativeWeights();
    }

    public boolean isEmpty() {
        return this.weights.isEmpty();
    }

    public WeightedUtil<T> copy() {
        WeightedUtil<T> copy = new WeightedUtil<T>(new HashMap<T, Float>(this.weights));
        copy.totalWeight = this.totalWeight;
        copy.cumulativeWeights = (float[])this.cumulativeWeights.clone();
        return copy;
    }
}

