/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.util.exSerialize;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.exmo.exmodifier.Exmodifier;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import oshi.util.tuples.Pair;

public class ExSerialize<T> {
    private final Supplier<T> constructor;
    private autoID autoIdSetter;
    private Map<Pair<Function<T, Object>, BiConsumer<T, Object>>, ExSerialize<Object>> subclasses = new HashMap<Pair<Function<T, Object>, BiConsumer<T, Object>>, ExSerialize<Object>>();
    private List<String> dontSyncToClientField = new ArrayList<String>();
    private List<String> onlyReadField = new ArrayList<String>();
    private String lastField = "";
    private final List<FieldHandler<T, ?>> fields = new ArrayList();

    public ExSerialize<T> dontSyncToClient(String fieldName) {
        this.dontSyncToClientField.add(fieldName);
        return this;
    }

    public ExSerialize<T> dontSyncToClient() {
        this.dontSyncToClientField.add(this.lastField);
        return this;
    }

    public ExSerialize<T> onlyRead(String fieldName) {
        this.onlyReadField.add(fieldName);
        return this;
    }

    public ExSerialize<T> onlyRead() {
        this.onlyReadField.add(this.lastField);
        return this;
    }

    public List<FieldHandler<T, ?>> getFields() {
        return this.fields;
    }

    public ExSerialize<T> marge(ExSerialize<? extends T> other) {
        this.fields.addAll(other.fields);
        return this;
    }

    private ExSerialize(Supplier<T> constructor) {
        this.constructor = constructor;
    }

    public ExSerialize<T> addSubclass(Function<T, Object> getter, BiConsumer<T, Object> setter, ExSerialize<Object> ser) {
        this.subclasses.put(new Pair(getter, setter), ser);
        return this;
    }

    public static <T> ExSerialize<T> create(Supplier<T> constructor) {
        return new ExSerialize<T>(constructor);
    }

    public ExSerialize<T> withAutoId(Function<T, String> getter, BiConsumer<T, String> autoIdSetter) {
        this.autoIdSetter = new autoID(getter, autoIdSetter);
        return this;
    }

    public ExSerialize<T> addIntStringMapField(String name, BiConsumer<T, Map<Integer, String>> setter) {
        return this.addIntStringMapField(name, t -> Collections.emptyMap(), setter);
    }

    public ExSerialize<T> addIntStringMapField(String name, Function<T, Map<Integer, String>> getter, BiConsumer<T, Map<Integer, String>> setter) {
        return this.addField(name, json -> this.parseIntStringMap(json.getAsJsonObject()), setter, tag -> this.parseNbtIntStringMap((CompoundTag)tag), (nbt, value) -> this.serializeNbtIntStringMap((CompoundTag)nbt, name, (Map<Integer, String>)value), getter);
    }

    public ExSerialize<T> addIntStringListMapField(String name, BiConsumer<T, Map<Integer, List<String>>> setter) {
        return this.addIntStringListMapField(name, t -> Collections.emptyMap(), setter);
    }

    public ExSerialize<T> addIntStringListMapField(String name, Function<T, Map<Integer, List<String>>> getter, BiConsumer<T, Map<Integer, List<String>>> setter) {
        return this.addField(name, json -> this.parseIntListStringMap(json.getAsJsonObject()), setter, tag -> this.parseNbtIntListStringMap((CompoundTag)tag), (nbt, value) -> this.serializeNbtIntListStringMap((CompoundTag)nbt, name, (Map<Integer, List<String>>)value), getter);
    }

    public ExSerialize<T> addStringField(String name, BiConsumer<T, String> setter) {
        return this.addStringField(name, t -> null, setter);
    }

    public ExSerialize<T> addStringField(String name, Function<T, String> getter, BiConsumer<T, String> setter) {
        return this.addField(name, json -> this.getJsonPrimitive((JsonElement)json).getAsString(), setter, Tag::m_7916_, (nbt, value) -> nbt.m_128359_(name, value), getter);
    }

    public ExSerialize<T> addBooleanField(String name, BiConsumer<T, Boolean> setter) {
        return this.addBooleanField(name, t -> false, setter);
    }

    public ExSerialize<T> addBooleanField(String name, Function<T, Boolean> getter, BiConsumer<T, Boolean> setter) {
        return this.addField(name, json -> this.getJsonPrimitive((JsonElement)json).getAsBoolean(), setter, tag -> ((ByteTag)tag).m_7063_() != 0, (nbt, value) -> nbt.m_128379_(name, value.booleanValue()), getter);
    }

    public ExSerialize<T> addIntField(String name, BiConsumer<T, Integer> setter) {
        return this.addIntField(name, t -> 0, setter);
    }

    public ExSerialize<T> addIntField(String name, Function<T, Integer> getter, BiConsumer<T, Integer> setter) {
        return this.addField(name, json -> this.getJsonPrimitive((JsonElement)json).getAsInt(), setter, tag -> ((IntTag)tag).m_7047_(), (nbt, value) -> nbt.m_128405_(name, value.intValue()), getter);
    }

    public ExSerialize<T> addFloatField(String name, BiConsumer<T, Float> setter) {
        return this.addFloatField(name, t -> Float.valueOf(0.0f), setter);
    }

    public ExSerialize<T> addDoubleField(String name, BiConsumer<T, Double> setter) {
        return this.addDoubleField(name, t -> 0.0, setter);
    }

    public ExSerialize<T> addDoubleField(String name, Function<T, Double> getter, BiConsumer<T, Double> setter) {
        return this.addField(name, json -> this.getJsonPrimitive((JsonElement)json).getAsDouble(), setter, tag -> ((DoubleTag)tag).m_7061_(), (nbt, value) -> nbt.m_128347_(name, value.doubleValue()), getter);
    }

    public ExSerialize<T> addFloatField(String name, Function<T, Float> getter, BiConsumer<T, Float> setter) {
        return this.addField(name, json -> Float.valueOf(this.getJsonPrimitive((JsonElement)json).getAsFloat()), setter, tag -> Float.valueOf(((FloatTag)tag).m_7057_()), (nbt, value) -> nbt.m_128350_(name, value.floatValue()), getter);
    }

    public ExSerialize<T> addResourceLocationField(String name, BiConsumer<T, ResourceLocation> setter) {
        return this.addResourceLocationField(name, t -> null, setter);
    }

    public ExSerialize<T> addResourceLocationField(String name, Function<T, ResourceLocation> getter, BiConsumer<T, ResourceLocation> setter) {
        return this.addField(name, json -> new ResourceLocation(json.getAsString()), setter, tag -> new ResourceLocation(tag.m_7916_()), (nbt, value) -> nbt.m_128359_(name, value.toString()), getter);
    }

    public ExSerialize<T> addFloatMapField(String name, BiConsumer<T, Map<String, Float>> setter) {
        return this.addFloatMapField(name, t -> Collections.emptyMap(), setter);
    }

    public ExSerialize<T> addFloatMapField(String name, Function<T, Map<String, Float>> getter, BiConsumer<T, Map<String, Float>> setter) {
        return this.addField(name, json -> this.parseFloatMap(json.getAsJsonObject()), setter, tag -> this.parseNbtFloatMap((CompoundTag)tag), (nbt, value) -> this.serializeNbtFloatMap((CompoundTag)nbt, name, (Map<String, Float>)value), getter);
    }

    public ExSerialize<T> addStringListField(String name, BiConsumer<T, List<String>> setter) {
        return this.addStringListField(name, t -> Collections.emptyList(), setter);
    }

    public ExSerialize<T> addStringListField(String name, Function<T, List<String>> getter, BiConsumer<T, List<String>> setter) {
        return this.addField(name, json -> this.parseStringList(json.getAsJsonArray()), setter, tag -> this.parseNbtStringList((ListTag)tag), (nbt, value) -> this.serializeNbtStringList((CompoundTag)nbt, name, (List<String>)value), getter);
    }

    public ExSerialize<T> addJsonObjectField(String name, BiConsumer<T, JsonObject> setter) {
        return this.addJsonObjectField(name, t -> new JsonObject(), setter);
    }

    public ExSerialize<T> addJsonObjectField(String name, Function<T, JsonObject> getter, BiConsumer<T, JsonObject> setter) {
        return this.addField(name, JsonElement::getAsJsonObject, setter, tag -> this.parseNbtJsonObject((CompoundTag)tag), (nbt, value) -> nbt.m_128365_(name, (Tag)this.serializeJsonObjectToNbt((JsonObject)value)), getter);
    }

    public ExSerialize<T> addJsonObjectList(String name, BiConsumer<T, List<JsonObject>> setter) {
        return this.addJsonObjectList(name, t -> Collections.emptyList(), setter);
    }

    public ExSerialize<T> addJsonObjectList(String name, Function<T, List<JsonObject>> getter, BiConsumer<T, List<JsonObject>> setter) {
        return this.addField(name, json -> this.parseJsonObjectList(json.getAsJsonArray()), setter, tag -> this.parseNbtJsonObjectList((ListTag)tag), (nbt, value) -> this.serializeNbtJsonObjectList((CompoundTag)nbt, name, (List<JsonObject>)value), getter);
    }

    public ExSerialize<T> addStringMapField(String name, BiConsumer<T, Map<String, String>> setter) {
        return this.addStringMapField(name, t -> Collections.emptyMap(), setter);
    }

    public ExSerialize<T> addStringMapField(String name, Function<T, Map<String, String>> getter, BiConsumer<T, Map<String, String>> setter) {
        return this.addField(name, json -> this.parseStringMap(json.getAsJsonObject()), setter, tag -> this.parseNbtStringMap((CompoundTag)tag), (nbt, value) -> this.serializeNbtStringMap((CompoundTag)nbt, name, (Map<String, String>)value), getter);
    }

    public JsonObject toSingleJson(T object) {
        JsonObject json = new JsonObject();
        this.fields.forEach(field -> {
            try {
                JsonElement value = this.serializeFieldToJson((FieldHandler)field, object);
                if (value != null && !value.isJsonNull()) {
                    json.add(field.name, value);
                }
            }
            catch (Exception e) {
                ExSerialize.getError("Field '{}' serialization failed: {}", field.name, e);
            }
        });
        this.subclasses.forEach((tFunction, exSerialize) -> {
            JsonObject singleJson = exSerialize.toSingleJson(((Function)tFunction.getA()).apply(object));
            singleJson.asMap().forEach((arg_0, arg_1) -> ((JsonObject)json).add(arg_0, arg_1));
        });
        return json;
    }

    public JsonArray toJson(List<T> objects) {
        JsonArray array = new JsonArray();
        objects.forEach(obj -> array.add((JsonElement)this.toSingleJson(obj)));
        return array;
    }

    public T fromJsonSingle(JsonObject json) {
        return this.createInstance("", json);
    }

    public List<T> fromJson(JsonObject json) {
        ArrayList<T> result = new ArrayList<T>();
        for (Map.Entry entry : json.entrySet()) {
            if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
            result.add(this.createInstance((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject()));
        }
        return result;
    }

    public List<T> fromJson(JsonArray array) {
        return this.fromJson(array, obj -> obj.get("id").getAsString());
    }

    public List<T> fromJson(JsonArray array, Function<JsonObject, String> idExtractor) {
        ArrayList result = new ArrayList();
        array.forEach(element -> {
            JsonObject json = null;
            if (element.isJsonObject()) {
                try {
                    json = element.getAsJsonObject();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (json != null) {
                result.add(this.createInstance((String)idExtractor.apply(json), json));
            }
        });
        return result;
    }

    public CompoundTag toNbt(T object) {
        CompoundTag tag = new CompoundTag();
        this.subclasses.forEach((tFunction, exSerialize) -> tag.m_128391_(exSerialize.toNbt(object)));
        this.fields.forEach(field -> {
            if (field.nbtSerializer != null && !this.onlyReadField.contains(field.name)) {
                try {
                    field.serializeToNbt(object, tag);
                }
                catch (Exception e) {
                    ExSerialize.getError("NBT serialization failed for field '{}': {}", field.name, e);
                }
            }
        });
        if (this.autoIdSetter != null) {
            tag.m_128359_("id", this.autoIdSetter.getter.apply(object));
        }
        return tag;
    }

    private static <T> void getError(String s, String field, Exception e) {
        Exmodifier.LOGGER.Logger.error(s, (Object)field, (Object)e.getMessage());
    }

    public CompoundTag toSyncNbt(T object) {
        CompoundTag tag = new CompoundTag();
        this.fields.forEach(field -> {
            if (field.nbtSerializer != null && !this.dontSyncToClientField.contains(field.name) && !this.onlyReadField.contains(field.name)) {
                try {
                    field.serializeToNbt(object, tag);
                }
                catch (Exception e) {
                    ExSerialize.getError("NBT serialization failed for field '{}': {}", field.name, e);
                }
            }
        });
        if (this.autoIdSetter != null) {
            tag.m_128359_("id", this.autoIdSetter.getter.apply(object));
        }
        return tag;
    }

    public T fromNbt(CompoundTag tag) {
        Object instance = this.constructor.get();
        this.fields.forEach(field -> {
            if (field.nbtDeserializer != null && tag.m_128441_(field.name)) {
                try {
                    field.deserializeFromNbt(tag, instance);
                }
                catch (Exception e) {
                    ExSerialize.getError("NBT deserialization failed for field '{}': {}", field.name, e);
                }
            }
        });
        if (this.autoIdSetter != null) {
            this.autoIdSetter.autoIdSetter.accept(instance, tag.m_128461_("id"));
        }
        this.subclasses.forEach((tFunction, exSerialize) -> ((BiConsumer)tFunction.getB()).accept(instance, exSerialize.fromNbt(tag)));
        return instance;
    }

    private <V> ExSerialize<T> addField(String name, Function<JsonElement, V> jsonDeserializer, BiConsumer<T, V> setter, Function<Tag, V> nbtDeserializer, BiConsumer<CompoundTag, V> nbtSerializer, Function<T, V> getter) {
        this.lastField = name;
        this.fields.add(new FieldHandler<Object, V>(name, jsonDeserializer, setter, (obj, tag) -> nbtSerializer.accept((CompoundTag)tag, (Object)getter.apply(obj)), nbtDeserializer));
        return this;
    }

    private T createInstance(String id, JsonObject json) {
        Object instance = this.constructor.get();
        if (this.autoIdSetter != null) {
            this.autoIdSetter.autoIdSetter.accept(instance, id);
        }
        this.fields.forEach(field -> {
            if (json.has(field.name)) {
                try {
                    JsonElement element = json.get(field.name);
                    FieldHandler typedHandler = field;
                    Object value = typedHandler.deserializer.apply(element);
                    BiConsumer setter = typedHandler.setter;
                    setter.accept(instance, value);
                }
                catch (Exception e) {
                    ExSerialize.getError("Field '{}' parsing failed: {}", field.name, e);
                }
            }
        });
        this.subclasses.forEach((tFunction, exSerialize) -> ((BiConsumer)tFunction.getB()).accept(instance, exSerialize.fromJson(json)));
        return instance;
    }

    private <V> JsonElement serializeFieldToJson(FieldHandler<T, V> field, T object) {
        try {
            if (field.nbtSerializer != null) {
                CompoundTag tempTag = new CompoundTag();
                field.nbtSerializer.accept(object, tempTag);
                return this.parseNbtValueToJson(tempTag.m_128423_(field.name));
            }
            return JsonNull.INSTANCE;
        }
        catch (Exception e) {
            ExSerialize.getError("JSON serialization failed for field '{}': {}", field.name, e);
            return JsonNull.INSTANCE;
        }
    }

    private CompoundTag serializeJsonObjectToNbt(JsonObject json) {
        CompoundTag tag = new CompoundTag();
        json.entrySet().forEach(entry -> tag.m_128365_((String)entry.getKey(), this.serializeJsonValueToNbt((JsonElement)entry.getValue())));
        return tag;
    }

    private Tag serializeJsonValueToNbt(JsonElement json) {
        if (json.isJsonPrimitive()) {
            JsonPrimitive prim = json.getAsJsonPrimitive();
            if (prim.isString()) {
                return StringTag.m_129297_((String)prim.getAsString());
            }
            if (prim.isNumber()) {
                float num = prim.getAsFloat();
                return num == (float)((int)num) ? IntTag.m_128679_((int)prim.getAsInt()) : FloatTag.m_128566_((float)num);
            }
        }
        if (json.isJsonObject()) {
            return this.serializeJsonObjectToNbt(json.getAsJsonObject());
        }
        if (json.isJsonArray()) {
            ListTag list = new ListTag();
            json.getAsJsonArray().forEach(e -> list.add((Object)this.serializeJsonValueToNbt((JsonElement)e)));
            return list;
        }
        return new CompoundTag();
    }

    private JsonObject parseNbtJsonObject(CompoundTag tag) {
        JsonObject json = new JsonObject();
        tag.m_128431_().forEach(key -> json.add(key, this.parseNbtValueToJson(tag.m_128423_(key))));
        return json;
    }

    private JsonElement parseNbtValueToJson(Tag tag) {
        if (tag instanceof StringTag) {
            return new JsonPrimitive(tag.m_7916_());
        }
        if (tag instanceof IntTag) {
            return new JsonPrimitive((Number)((IntTag)tag).m_7047_());
        }
        if (tag instanceof FloatTag) {
            return new JsonPrimitive((Number)Float.valueOf(((FloatTag)tag).m_7057_()));
        }
        if (tag instanceof CompoundTag) {
            return this.parseNbtJsonObject((CompoundTag)tag);
        }
        if (tag instanceof ListTag) {
            JsonArray array = new JsonArray();
            ((ListTag)tag).forEach(t -> array.add(this.parseNbtValueToJson((Tag)t)));
            return array;
        }
        return JsonNull.INSTANCE;
    }

    private Map<String, Float> parseNbtFloatMap(CompoundTag tag) {
        return tag.m_128431_().stream().collect(Collectors.toMap(k -> k, k -> Float.valueOf(tag.m_128457_(k))));
    }

    private void serializeNbtFloatMap(CompoundTag parent, String name, Map<String, Float> map) {
        CompoundTag mapTag = new CompoundTag();
        map.forEach((arg_0, arg_1) -> ((CompoundTag)mapTag).m_128350_(arg_0, arg_1));
        parent.m_128365_(name, (Tag)mapTag);
    }

    private List<String> parseNbtStringList(ListTag listTag) {
        ArrayList<String> list = new ArrayList<String>();
        listTag.forEach(t -> list.add(t.m_7916_()));
        return list;
    }

    private CompoundTag serializeNbtStringList(CompoundTag parent, String name, List<String> list) {
        ListTag listTag = new ListTag();
        list.forEach(s -> listTag.add((Object)StringTag.m_129297_((String)s)));
        parent.m_128365_(name, (Tag)listTag);
        return parent;
    }

    private List<JsonObject> parseNbtJsonObjectList(ListTag listTag) {
        ArrayList<JsonObject> list = new ArrayList<JsonObject>();
        listTag.forEach(t -> list.add(this.parseNbtJsonObject((CompoundTag)t)));
        return list;
    }

    private void serializeNbtJsonObjectList(CompoundTag parent, String name, List<JsonObject> list) {
        ListTag listTag = new ListTag();
        list.forEach(json -> listTag.add((Object)this.serializeJsonObjectToNbt((JsonObject)json)));
        parent.m_128365_(name, (Tag)listTag);
    }

    private JsonPrimitive getJsonPrimitive(JsonElement element) {
        if (!element.isJsonPrimitive()) {
            throw new JsonSyntaxException("Expected primitive value");
        }
        return element.getAsJsonPrimitive();
    }

    private JsonObject getJsonObject(JsonElement element) {
        if (!element.isJsonObject()) {
            throw new JsonSyntaxException("Expected JSON object");
        }
        return element.getAsJsonObject();
    }

    private JsonArray getJsonArray(JsonElement element) {
        if (!element.isJsonArray()) {
            throw new JsonSyntaxException("Expected JSON array");
        }
        return element.getAsJsonArray();
    }

    private Map<String, Float> parseFloatMap(JsonObject json) {
        return json.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Float.valueOf(((JsonElement)e.getValue()).getAsFloat())));
    }

    private List<String> parseStringList(JsonArray array) {
        ArrayList<String> list = new ArrayList<String>();
        array.forEach(e -> list.add(e.getAsString()));
        return list;
    }

    private List<JsonObject> parseJsonObjectList(JsonArray array) {
        ArrayList<JsonObject> list = new ArrayList<JsonObject>();
        array.forEach(e -> list.add(e.getAsJsonObject()));
        return list;
    }

    private Map<String, String> parseStringMap(JsonObject json) {
        return json.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((JsonElement)e.getValue()).getAsString()));
    }

    private Map<String, String> parseNbtStringMap(CompoundTag tag) {
        return tag.m_128431_().stream().collect(Collectors.toMap(k -> k, k -> tag.m_128461_(k)));
    }

    private void serializeNbtStringMap(CompoundTag parent, String name, Map<String, String> map) {
        CompoundTag mapTag = new CompoundTag();
        map.forEach((arg_0, arg_1) -> ((CompoundTag)mapTag).m_128359_(arg_0, arg_1));
        parent.m_128365_(name, (Tag)mapTag);
    }

    private Map<Integer, String> parseIntStringMap(JsonObject json) {
        return json.entrySet().stream().collect(Collectors.toMap(e -> Integer.parseInt((String)e.getKey()), e -> ((JsonElement)e.getValue()).getAsString()));
    }

    private Map<Integer, String> parseNbtIntStringMap(CompoundTag tag) {
        return tag.m_128431_().stream().collect(Collectors.toMap(k -> Integer.parseInt(k), k -> tag.m_128461_(k)));
    }

    private void serializeNbtIntStringMap(CompoundTag parent, String name, Map<Integer, String> map) {
        CompoundTag mapTag = new CompoundTag();
        map.forEach((k, v) -> mapTag.m_128359_(k.toString(), v));
        parent.m_128365_(name, (Tag)mapTag);
    }

    private Map<Integer, List<String>> parseIntListStringMap(JsonObject json) {
        return json.entrySet().stream().collect(Collectors.toMap(e -> Integer.parseInt((String)e.getKey()), e -> this.parseStringList(((JsonElement)e.getValue()).getAsJsonArray())));
    }

    private Map<Integer, List<String>> parseNbtIntListStringMap(CompoundTag tag) {
        return tag.m_128431_().stream().collect(Collectors.toMap(k -> Integer.parseInt(k), k -> this.parseNbtStringList(tag.m_128437_(k, 8))));
    }

    private void serializeNbtIntListStringMap(CompoundTag parent, String name, Map<Integer, List<String>> map) {
        CompoundTag mapTag = new CompoundTag();
        map.forEach((k, v) -> mapTag.m_128365_(k.toString(), (Tag)this.serializeNbtStringList(new CompoundTag(), "list", (List<String>)v)));
        parent.m_128365_(name, (Tag)mapTag);
    }

    public class autoID {
        public Function<T, String> getter;
        public BiConsumer<T, String> autoIdSetter;

        public autoID(Function<T, String> getter, BiConsumer<T, String> autoIdSetter) {
            this.getter = getter;
            this.autoIdSetter = autoIdSetter;
        }
    }

    public static class FieldHandler<T, V> {
        final String name;
        final Function<JsonElement, V> deserializer;
        final BiConsumer<T, V> setter;
        final BiConsumer<T, CompoundTag> nbtSerializer;
        final Function<Tag, V> nbtDeserializer;

        FieldHandler(String name, Function<JsonElement, V> deserializer, BiConsumer<T, V> setter, BiConsumer<T, CompoundTag> nbtSerializer, Function<Tag, V> nbtDeserializer) {
            this.name = name;
            this.deserializer = deserializer;
            this.setter = setter;
            this.nbtSerializer = nbtSerializer;
            this.nbtDeserializer = nbtDeserializer;
        }

        void serializeToNbt(T object, CompoundTag tag) {
            if (this.nbtSerializer != null) {
                this.nbtSerializer.accept(object, tag);
            }
        }

        void deserializeFromNbt(CompoundTag tag, T object) {
            if (this.nbtDeserializer != null && tag.m_128441_(this.name)) {
                Tag nbtValue = tag.m_128423_(this.name);
                V value = this.nbtDeserializer.apply(nbtValue);
                this.setter.accept(object, value);
            }
        }
    }
}

