/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.util.gether;

import com.google.gson.JsonObject;
import java.text.DecimalFormat;
import net.exmo.exmodifier.content.modifier.ModifierHandle;
import net.exmo.exmodifier.util.ExAttributeModifier;
import net.exmo.exmodifier.util.ExUtil;
import net.exmo.exmodifier.util.exSerialize.ExSerialize;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class AttriGether {
    public static ExSerialize<AttriGether> ExSer = ExSerialize.create(AttriGether::new).addResourceLocationField("attribute", e -> ResourceLocation.m_135820_((String)ExUtil.getAttributeID(e.attribute)), (e, v) -> {
        e.attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(v);
    }).addStringField("slot", e -> e.slot != null ? e.slot.m_20751_() : "", (e, v) -> {
        e.slot = EquipmentSlot.m_20747_((String)v);
    }).addBooleanField("IsAutoEquipmentSlot", e -> e.IsAutoEquipmentSlot, (e, v) -> {
        e.IsAutoEquipmentSlot = v;
    }).addJsonObjectField("modifier", e -> {
        JsonObject obj = new JsonObject();
        obj.addProperty("name", e.modifier.getName());
        obj.addProperty("amount", (Number)e.modifier.getAmount());
        obj.addProperty("operation", (Number)e.modifier.getOperation().m_22235_());
        return obj;
    }, (e, json) -> {
        String name = json.get("name").getAsString();
        double amount = json.get("amount").getAsDouble();
        AttributeModifier.Operation operation = AttributeModifier.Operation.m_22236_((int)json.get("operation").getAsInt());
        e.modifier = new ExAttributeModifier(name, amount, operation);
    });
    public EquipmentSlot slot = null;
    public boolean IsAutoEquipmentSlot = false;
    public Attribute attribute;
    public ExAttributeModifier modifier;

    public AttriGether(Attribute attribute, ExAttributeModifier modifier, EquipmentSlot slot) {
        this.attribute = attribute;
        this.modifier = modifier;
        this.slot = slot;
    }

    public AttriGether() {
    }

    public CompoundTag toNBT1() {
        CompoundTag tag = new CompoundTag();
        String sslot = "";
        if (this.slot != null) {
            sslot = this.slot.m_20751_();
        }
        tag.m_128359_("slot", sslot);
        tag.m_128379_("IsAutoEquipmentSlot", this.IsAutoEquipmentSlot);
        ResourceLocation key = ResourceLocation.m_135820_((String)ExUtil.getAttributeID(this.attribute));
        if (key != null) {
            tag.m_128359_("attribute", key.toString());
        }
        tag.m_128359_("modifierName", this.modifier.getName());
        tag.m_128347_("modifierAmount", this.modifier.getAmount());
        if (this.modifier.getOperation() != null) {
            tag.m_128405_("modifierOperation", this.modifier.getOperation().m_22235_());
        }
        return tag;
    }

    public static AttriGether fromNBT1(CompoundTag tag) {
        AttriGether attriGether = new AttriGether(null, null, null);
        String slot1 = tag.m_128461_("slot");
        attriGether.slot = slot1.isEmpty() ? null : EquipmentSlot.m_20747_((String)slot1);
        attriGether.IsAutoEquipmentSlot = tag.m_128471_("IsAutoEquipmentSlot");
        String attributeId = tag.m_128461_("attribute");
        String modifierId1 = tag.m_128461_("modifierId");
        attriGether.attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(ResourceLocation.m_135820_((String)attributeId));
        String modifierName = tag.m_128461_("modifierName");
        double modifierAmount = tag.m_128459_("modifierAmount");
        AttributeModifier.Operation modifierOperation = AttributeModifier.Operation.m_22236_((int)tag.m_128451_("modifierOperation"));
        attriGether.modifier = new ExAttributeModifier(modifierName, modifierAmount, modifierOperation);
        return attriGether;
    }

    public AttriGether(Attribute attribute, ExAttributeModifier modifier) {
        this.attribute = attribute;
        this.modifier = modifier;
    }

    public AttriGether(Attribute attribute, ExAttributeModifier modifier, boolean isAutoEquipmentSlot) {
        this.attribute = attribute;
        this.modifier = modifier;
        this.IsAutoEquipmentSlot = isAutoEquipmentSlot;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public ExAttributeModifier getModifier() {
        return this.modifier;
    }

    public MutableComponent generateTooltipBase() {
        ExAttributeModifier attributemodifier = this.getModifier();
        Attribute attribute = this.getAttribute();
        if (attribute == null) {
            return Component.m_237115_((String)"exmodifier.tooltip.error1");
        }
        if (attributemodifier == null) {
            return Component.m_237115_((String)"exmodifier.tooltip.error2");
        }
        double d0 = attributemodifier.getAmount();
        boolean flag = false;
        String percent = "";
        double d1 = attributemodifier.getOperation() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier.getOperation() != AttributeModifier.Operation.MULTIPLY_TOTAL && !ModifierHandle.percentAtr.contains(ExUtil.getAttributeID(attribute).toString()) ? (attribute.equals(Attributes.f_22278_) ? d0 * 10.0 : d0) : d0 * 100.0;
        String amouta2 = "";
        if (ModifierHandle.percentAtr.contains(ExUtil.getAttributeID(attribute).toString())) {
            percent = "%";
            DecimalFormat df = new DecimalFormat("#.####");
            amouta2 = df.format(attributemodifier.getAmount() * 100.0);
            if (this.attribute.m_22087_().length() >= 4 && (ExUtil.getAttributeID(attribute).toString().startsWith("twtp") || ExUtil.getAttributeID(attribute).toString().startsWith("isfix"))) {
                amouta2 = df.format(attributemodifier.getAmount());
            }
        }
        if (flag) {
            return Component.m_237113_((String)" ").m_7220_((Component)Component.m_237110_((String)("attribute.modifier.equals." + attributemodifier.getOperation().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)attribute.m_22087_())})).m_130940_(ChatFormatting.DARK_GREEN);
        }
        if (d0 > 0.0) {
            if (percent.equals("%")) {
                return Component.m_237115_((String)"add").m_130946_(amouta2).m_130946_(percent).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)attribute.m_22087_())).m_130940_(ChatFormatting.BLUE);
            }
            return Component.m_237110_((String)("attribute.modifier.plus." + attributemodifier.getOperation().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)attribute.m_22087_())}).m_130940_(ChatFormatting.BLUE);
        }
        if (d0 < 0.0) {
            d1 *= -1.0;
            if (percent.equals("%")) {
                return Component.m_237115_((String)"subtract").m_130946_(amouta2).m_130946_(percent).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)attribute.m_22087_())).m_130940_(ChatFormatting.RED);
            }
            return Component.m_237110_((String)("attribute.modifier.take." + attributemodifier.getOperation().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)attribute.m_22087_())}).m_130940_(ChatFormatting.RED);
        }
        return Component.m_237115_((String)"exmodifier.tooltip.error3");
    }
}

