/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.util.gether;

import java.util.ArrayList;
import java.util.List;
import net.exmo.exmodifier.util.ExAttributeModifier;
import net.exmo.exmodifier.util.ExUtil;
import net.exmo.exmodifier.util.gether.AttriGether;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class AttriGetherPlus
extends AttriGether {
    public List<String> OnlyItems = new ArrayList<String>();
    public List<String> OnlyTags = new ArrayList<String>();

    public AttriGetherPlus(Attribute attribute, ExAttributeModifier modifier, EquipmentSlot slot, List<String> tags, List<String> items) {
        super(attribute, modifier, slot);
        this.OnlyItems.addAll(items);
        this.OnlyTags.addAll(tags);
    }

    public AttriGetherPlus(Attribute attribute, ExAttributeModifier modifier, EquipmentSlot slot) {
        super(attribute, modifier, slot);
    }

    public AttriGetherPlus(Attribute attribute, ExAttributeModifier modifier) {
        super(attribute, modifier);
    }

    public AttriGetherPlus(Attribute attribute, ExAttributeModifier modifier, boolean isAutoEquipmentSlot) {
        super(attribute, modifier, isAutoEquipmentSlot);
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("AttributeName", this.getAttribute().m_22087_());
        compound.m_128365_("AttributeModifier", (Tag)this.getModifier().toModifier().m_22219_());
        if (this.slot != null) {
            compound.m_128359_("Slot", this.slot.m_20751_());
        }
        ListTag itemsTag = new ListTag();
        for (String item : this.OnlyItems) {
            itemsTag.add((Object)StringTag.m_129297_((String)item));
        }
        compound.m_128365_("OnlyItems", (Tag)itemsTag);
        ListTag tagsTag = new ListTag();
        for (String tag : this.OnlyTags) {
            tagsTag.add((Object)StringTag.m_129297_((String)tag));
        }
        compound.m_128365_("OnlyTags", (Tag)tagsTag);
        return compound;
    }

    public static Attribute getAttribute(String attribute) {
        for (Attribute attr : ForgeRegistries.ATTRIBUTES) {
            if (!ExUtil.getAttributeID(attr).equals(attribute)) continue;
            return attr;
        }
        return null;
    }

    public static AttriGetherPlus deserializeNBT(CompoundTag nbt) {
        Attribute attribute = AttriGetherPlus.getAttribute(nbt.m_128461_("AttributeName"));
        ExAttributeModifier modifier = ExAttributeModifier.fromModifier(AttributeModifier.m_22212_((CompoundTag)nbt.m_128469_("AttributeModifier")));
        EquipmentSlot slot = nbt.m_128441_("Slot") ? EquipmentSlot.m_20747_((String)nbt.m_128461_("Slot")) : null;
        ArrayList<String> items = new ArrayList<String>();
        ListTag itemsTag = nbt.m_128437_("OnlyItems", 8);
        for (int i = 0; i < itemsTag.size(); ++i) {
            items.add(itemsTag.m_128778_(i));
        }
        ArrayList<String> tags = new ArrayList<String>();
        ListTag tagsTag = nbt.m_128437_("OnlyTags", 8);
        for (int i = 0; i < tagsTag.size(); ++i) {
            tags.add(tagsTag.m_128778_(i));
        }
        AttriGetherPlus instance = new AttriGetherPlus(attribute, modifier, slot, tags, items);
        return instance;
    }
}

