/*
 * Decompiled with CFR 0.152.
 */
package web;

import com.google.common.util.concurrent.AtomicDouble;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sun.management.OperatingSystemMXBean;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.exmo.exmodifier.Exmodifier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class RealTimeWebServer {
    public static AtomicInteger entityCount = new AtomicInteger(0);
    public static AtomicReference<List<ServerPlayer>> onlinePlayers = new AtomicReference(new ArrayList());
    public static final AtomicDouble cpuUsage = new AtomicDouble(0.0);
    public static final AtomicDouble memoryUsage = new AtomicDouble(0.0);
    public static final AtomicReference<JsonArray> playersData = new AtomicReference<JsonArray>(new JsonArray());
    public static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final OperatingSystemMXBean osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    private static final Runtime runtime = Runtime.getRuntime();

    public static void main(String[] args) throws Exception {
        HttpServer server = HttpServer.create(new InetSocketAddress(8081), 0);
        server.createContext("/", exchange -> {
            int bytesRead;
            FileInputStream fileInputStream;
            FileInputStream is;
            String path = exchange.getRequestURI().getPath();
            if (path.equals("/")) {
                path = "/index.html";
            }
            if ((is = (fileInputStream = new FileInputStream(String.valueOf("G:\\MC\\ExModifier1.20.1\\static\\" + path)))) == null) {
                RealTimeWebServer.sendResponse(exchange, "404 Not Found", 404);
                return;
            }
            String mimeType = "text/html";
            if (path.endsWith(".css")) {
                mimeType = "text/css";
            }
            if (path.endsWith(".js")) {
                mimeType = "application/javascript";
            }
            exchange.getResponseHeaders().set("Content-Type", mimeType + "; charset=UTF-8");
            OutputStream os = exchange.getResponseBody();
            exchange.sendResponseHeaders(200, 0L);
            byte[] buffer = new byte[4096];
            while ((bytesRead = ((InputStream)is).read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            ((InputStream)is).close();
            os.close();
        });
        server.createContext("/api/serverinfo", exchange -> {
            JsonObject data = new JsonObject();
            data.addProperty("entityCount", (Number)entityCount.get());
            data.addProperty("onlinePlayers", (Number)onlinePlayers.get().size());
            data.addProperty("cpuUsage", (Number)((double)Math.round(cpuUsage.get() * 100.0) / 100.0));
            data.addProperty("memoryUsage", (Number)((double)Math.round(memoryUsage.get() * 100.0) / 100.0));
            JsonObject systemInfo = new JsonObject();
            systemInfo.addProperty("os", System.getProperty("os.name"));
            systemInfo.addProperty("javaVersion", System.getProperty("java.version"));
            systemInfo.addProperty("serverTime", new Date().toString());
            data.add("system", (JsonElement)systemInfo);
            data.add("players", (JsonElement)playersData.get());
            RealTimeWebServer.sendResponse(exchange, gson.toJson((JsonElement)data));
        });
        new Thread(() -> {
            Random rand = new Random();
            while (!Thread.interrupted()) {
                try {
                    double cpuLoad = osBean.getCpuLoad() * 100.0;
                    cpuUsage.set(Double.isNaN(cpuLoad) ? 0.0 : cpuLoad);
                    double usedMemory = (double)(runtime.totalMemory() - runtime.freeMemory()) / 1024.0 / 1024.0;
                    double totalMemory = (double)runtime.maxMemory() / 1024.0 / 1024.0;
                    memoryUsage.set(usedMemory / totalMemory * 100.0);
                    double memoryUsageValue = (totalMemory - usedMemory) * 100.0;
                    cpuUsage.set(Double.isNaN(cpuLoad) ? 0.0 : cpuLoad);
                    memoryUsage.set(memoryUsageValue);
                    JsonArray players = new JsonArray();
                    for (ServerPlayer player : onlinePlayers.get()) {
                        if (player == null) continue;
                        JsonObject playerJson = new JsonObject();
                        playerJson.addProperty("name", player.m_6302_());
                        JsonObject position = new JsonObject();
                        position.addProperty("x", (Number)Math.round(player.m_20185_()));
                        position.addProperty("y", (Number)Math.round(player.m_20186_()));
                        position.addProperty("z", (Number)Math.round(player.m_20189_()));
                        playerJson.add("position", (JsonElement)position);
                        JsonArray equipment = new JsonArray();
                        for (ItemStack stack : player.m_150109_().f_35974_) {
                            if (stack.m_41619_()) continue;
                            JsonObject item = new JsonObject();
                            item.addProperty("name", stack.m_41786_().getString());
                            item.addProperty("id", ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString());
                            item.addProperty("durability", (Number)stack.m_41773_());
                            item.addProperty("maxDurability", (Number)stack.m_41776_());
                            equipment.add((JsonElement)item);
                        }
                        playerJson.add("equipment", (JsonElement)equipment);
                        playerJson.addProperty("health", (Number)Float.valueOf(player.m_21223_()));
                        playerJson.addProperty("dimension", player.m_284548_().m_46472_().m_135782_().toString());
                        players.add((JsonElement)playerJson);
                    }
                    playersData.set(players);
                    playersData.set(players);
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }).start();
        server.start();
        System.out.println("\u670d\u52a1\u5668\u8fd0\u884c\u5728 http://localhost:8081");
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            server.stop(0);
            Exmodifier.LOGGER.info("\u76d1\u63a7\u670d\u52a1\u5668\u5df2\u5173\u95ed");
        }));
    }

    private static void sendResponse(HttpExchange exchange, String content) throws IOException {
        byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
        exchange.sendResponseHeaders(200, bytes.length);
        try (OutputStream os = exchange.getResponseBody();){
            os.write(bytes);
        }
    }

    private static void sendResponse(HttpExchange exchange, String content, int code) throws IOException {
        byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
        exchange.sendResponseHeaders(code, bytes.length);
        try (OutputStream os = exchange.getResponseBody();){
            os.write(bytes);
        }
    }
}

