/*
 * Decompiled with CFR 0.152.
 */
package puns;

import com.mojang.logging.LogUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.slf4j.Logger;
import puns.client.ClientEventHandler;
import puns.common.PunCommand;
import puns.data.PunDataLoader;

@Mod(value="puns")
public class Puns {
    public static final String MOD_ID = "puns";
    public static final String MOD_NAME = "Puns";
    public static final Logger LOGGER = LogUtils.getLogger();

    public Puns() {
        PunDataLoader.forceLoad();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(Puns::onAddReloadListener);
        forgeBus.addListener(PunCommand::onRegisterCommands);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientEventHandler.init(forgeBus);
        }
        LOGGER.info("Loaded!");
    }

    public static void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new PunDataLoader());
    }

    public static ResourceLocation identifier(String name) {
        return Puns.resourceLocation(MOD_ID, name);
    }

    public static ResourceLocation resourceLocation(String name) {
        return new ResourceLocation(name);
    }

    public static ResourceLocation resourceLocation(String domain, String path) {
        return new ResourceLocation(domain, path);
    }
}

