/*
 * Decompiled with CFR 0.152.
 */
package puns.client;

import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import puns.Puns;
import puns.client.ClientEventHandler;
import puns.data.PunDataLoader;

public class PunIntroScreen
extends Screen {
    public static String[] REACTIONS = new String[]{"angry", "cool", "cringe", "crossed", "expressionless", "grimace", "neutral", "rolling", "smiling", "zany"};
    public static final String SCREEN_NAME = "puns.screen.pun";
    public PunDataLoader.PunEntry pun = PunDataLoader.getRandomPun(RandomSource.m_216327_());
    public final Screen parent;
    public boolean animating = false;
    public boolean fadingOut = false;
    public long fadeStart;
    private boolean shaking = false;
    private long shakeStart;
    private float shakeDuration = 2.0f;

    public PunIntroScreen(Screen parent) {
        super((Component)Component.m_237115_((String)SCREEN_NAME));
        this.parent = parent;
        REACTIONS = PunIntroScreen.getShuffledReactions();
        ClientEventHandler.HAS_SHOWN_PUN_SCREEN = true;
    }

    public static String[] getShuffledReactions() {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(REACTIONS));
        Collections.shuffle(list);
        return list.toArray(new String[0]);
    }

    public Screen getParent() {
        return this.parent;
    }

    public boolean m_6913_() {
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == ClientEventHandler.REFRESH_PUN_SCREEN.getKey().m_84873_()) {
            REACTIONS = PunIntroScreen.getShuffledReactions();
            this.pun = PunDataLoader.getRandomPun(RandomSource.m_216327_());
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected void m_7856_() {
        int spacing = 30;
        int totalWidth = 5 * spacing;
        int startX = this.f_96543_ / 2 - totalWidth / 2;
        int rowY1 = this.f_96544_ / 2 + 20;
        int rowY2 = rowY1 + 30;
        for (int i = 0; i < REACTIONS.length; ++i) {
            boolean row = i >= 5;
            int col = i % 5;
            int x = startX + col * spacing;
            int y = !row ? rowY1 : rowY2;
            ResourceLocation tex = Puns.identifier("textures/gui/reaction/" + REACTIONS[i] + ".png");
            String langKey = "puns.reaction." + REACTIONS[i];
            this.m_142416_((GuiEventListener)new ReactionButton(x, y, tex, langKey, b -> this.startAnimation((ReactionButton)b)));
        }
    }

    public void startAnimation(ReactionButton pressed) {
        if (this.animating) {
            return;
        }
        this.animating = true;
        this.shaking = true;
        this.shakeStart = System.currentTimeMillis();
        for (Renderable widget : this.f_169369_) {
            ReactionButton rb;
            if (!(widget instanceof ReactionButton)) continue;
            rb.beginAnimation((rb = (ReactionButton)widget) == pressed, pressed.m_252754_(), pressed.m_252907_(), this.f_96543_, this.f_96544_);
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        float safetyMargin;
        float buttonsY;
        float maxBottom;
        float t;
        float alpha = 1.0f;
        if (this.fadingOut) {
            t = (float)(System.currentTimeMillis() - this.fadeStart) / 1000.0f;
            alpha = Math.max(0.0f, 1.0f - t / 1.5f);
        }
        graphics.m_280168_().m_85836_();
        if (this.shaking) {
            t = (float)(System.currentTimeMillis() - this.shakeStart) / 1000.0f;
            if (t > this.shakeDuration) {
                this.shaking = false;
            } else {
                float progress = t / this.shakeDuration;
                float c1 = 1.70158f;
                float c3 = c1 + 1.0f;
                float eased = c3 * progress * progress * progress - c1 * progress * progress;
                float intensity = 3.0f * (1.0f - eased);
                float offsetX = intensity * (Mth.m_14031_((float)(t * 25.0f)) + Mth.m_14031_((float)(t * 40.0f))) * 0.5f;
                float offsetY = intensity * (Mth.m_14089_((float)(t * 30.0f)) + Mth.m_14089_((float)(t * 45.0f))) * 0.5f;
                graphics.m_280168_().m_252880_(offsetX, offsetY, 0.0f);
            }
        }
        this.renderFadingBackground(graphics, alpha);
        int textColor = -1;
        int subColor = -3355444;
        MutableComponent questionComp = Component.m_237113_((String)this.pun.question()).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        MutableComponent answerComp = Component.m_237113_((String)this.pun.answer()).m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)));
        float questionScale = 1.5f;
        int questionMaxWidth = (int)((float)this.f_96543_ / questionScale) - 40;
        List questionLines = this.f_96547_.m_92923_((FormattedText)questionComp, questionMaxWidth);
        Objects.requireNonNull(this.f_96547_);
        int lineHeight = 9;
        float questionBlockHeight = (float)(questionLines.size() * lineHeight) * questionScale + 2.0f;
        float answerScale = 1.25f;
        ArrayList answerLines = this.pun.answer().isEmpty() ? new ArrayList() : this.f_96547_.m_92923_((FormattedText)answerComp, (int)((float)this.f_96543_ / answerScale) - 40);
        int answerLinesCount = answerLines.size();
        float answerBlockHeight = (float)(answerLinesCount * lineHeight) * answerScale;
        float margin = 4.5f;
        float fixedAnswerBottom = (float)this.f_96544_ / 2.0f - 0.75f;
        float virtualAnswerHeight = (float)((answerLinesCount == 0 ? 1 : answerLinesCount) * lineHeight) * answerScale;
        float virtualAnswerTop = fixedAnswerBottom - virtualAnswerHeight;
        float questionBottom = virtualAnswerTop - margin;
        float questionTopEffective = questionBottom - questionBlockHeight;
        int questionStartYPre = (int)(questionTopEffective / questionScale);
        int questionCenterXPre = (int)((float)(this.f_96543_ / 2) / questionScale);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(questionScale, questionScale, 1.0f);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, alpha);
        for (int i = 0; i < questionLines.size(); ++i) {
            FormattedCharSequence line = (FormattedCharSequence)questionLines.get(i);
            int lineWidth = this.f_96547_.m_92724_(line);
            graphics.m_280649_(this.f_96547_, line, questionCenterXPre - lineWidth / 2, questionStartYPre + i * lineHeight, textColor, false);
        }
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.m_280168_().m_85849_();
        float actualBottom = questionTopEffective + questionBlockHeight;
        if (!this.pun.answer().isEmpty()) {
            float answerTopEffective = fixedAnswerBottom - answerBlockHeight;
            int answerStartYPre = (int)(answerTopEffective / answerScale);
            int answerCenterXPre = (int)((float)(this.f_96543_ / 2) / answerScale);
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(answerScale, answerScale, 1.0f);
            graphics.m_280246_(0.8f, 0.8f, 0.8f, alpha);
            for (int i = 0; i < answerLines.size(); ++i) {
                FormattedCharSequence line = (FormattedCharSequence)answerLines.get(i);
                int lineWidth = this.f_96547_.m_92724_(line);
                graphics.m_280649_(this.f_96547_, line, answerCenterXPre - lineWidth / 2, answerStartYPre + i * lineHeight, subColor, false);
            }
            graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            graphics.m_280168_().m_85849_();
            actualBottom = answerTopEffective + answerBlockHeight;
        }
        if (actualBottom > (maxBottom = (buttonsY = (float)(this.f_96544_ / 2 + 20)) - (safetyMargin = 10.0f))) {
            float excess = actualBottom - maxBottom;
            questionStartYPre = (int)((questionTopEffective -= excess) / questionScale);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280168_().m_85849_();
        if (this.animating && !this.fadingOut) {
            boolean allGone = true;
            for (Renderable widget : this.f_169369_) {
                ReactionButton rb;
                if (!(widget instanceof ReactionButton) || (rb = (ReactionButton)widget).isFadedOut()) continue;
                allGone = false;
                break;
            }
            if (allGone) {
                this.fadingOut = true;
                this.fadeStart = System.currentTimeMillis();
            }
        }
        if (this.fadingOut && alpha <= 0.0f) {
            Minecraft.m_91087_().m_91152_(this.parent);
        }
    }

    public void renderFadingBackground(GuiGraphics graphics, float alpha) {
        alpha = Mth.m_14036_((float)alpha, (float)0.0f, (float)1.0f);
        graphics.m_280168_().m_85836_();
        graphics.m_280246_(0.25f, 0.25f, 0.25f, alpha);
        graphics.m_280398_(f_279548_, 0, 0, 0, 0.0f, 0.0f, this.f_96543_, this.f_96544_, 32, 32);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.m_280168_().m_85849_();
    }

    public static class ReactionButton
    extends ImageButton {
        private boolean animating = false;
        private boolean isPressedButton = false;
        private float alpha = 1.0f;
        private float scale = 1.0f;
        private float targetScale = 1.0f;
        private long hoverStart;
        private boolean hovering = false;
        private float px;
        private float py;
        private float vx;
        private float vy;
        private float spin;
        private float angle;
        private long animStart;
        private long lastUpdateTime;
        private boolean shockwaveActive = false;
        private long shockwaveStart;
        private float shockwaveScale = 0.0f;
        private float shockwaveAlpha = 1.0f;
        private static final ResourceLocation SHOCKWAVE_TEX = Puns.identifier("textures/gui/reaction_press.png");

        public ReactionButton(int x, int y, ResourceLocation texture, String langKey, Button.OnPress onPress) {
            super(x, y, 24, 24, 0, 0, 24, texture, 24, 24, onPress, (Component)Component.m_237115_((String)langKey));
            this.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)langKey)));
            this.px = x;
            this.py = y;
        }

        public void beginAnimation(boolean pressed, int pressedX, int pressedY, int screenWidth, int screenHeight) {
            this.animating = true;
            this.isPressedButton = pressed;
            this.lastUpdateTime = this.animStart = System.currentTimeMillis();
            RandomSource r = RandomSource.m_216327_();
            if (pressed) {
                this.vy = 0.0f;
                this.vx = 0.0f;
                this.spin = (r.m_188501_() - 0.5f) * 360.0f;
                this.shockwaveActive = true;
                this.shockwaveStart = System.currentTimeMillis();
                this.shockwaveScale = 0.0f;
                this.shockwaveAlpha = 1.0f;
            } else {
                float dy;
                float dx = this.m_252754_() - pressedX;
                float dist = (float)Math.sqrt(dx * dx + (dy = (float)(this.m_252907_() - pressedY)) * dy);
                if (dist == 0.0f) {
                    dist = 1.0f;
                }
                float dirAngle = (float)Math.atan2(dy, dx);
                float nx = (float)Math.cos(dirAngle += (r.m_188501_() - 0.5f) * 0.3f);
                float ny = (float)Math.sin(dirAngle);
                float delay = dist / 600.0f;
                this.animStart += (long)(delay * 1000.0f);
                float speed = (r.m_188501_() * 10000.0f + 15000.0f) / (dist + 30.0f) + r.m_188501_() * 100.0f - 50.0f;
                this.vx = nx * speed;
                this.vy = ny * speed;
                this.spin = (r.m_188501_() - 0.5f) * 720.0f;
            }
            this.m_257544_(null);
        }

        public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            long now = System.currentTimeMillis();
            boolean currentlyHovering = this.m_198029_();
            if (currentlyHovering != this.hovering) {
                this.hovering = currentlyHovering;
                this.hoverStart = now;
                this.targetScale = this.hovering ? 1.25f : 1.0f;
            }
            float elapsed = (float)(now - this.hoverStart) / 200.0f;
            elapsed = Mth.m_14036_((float)elapsed, (float)0.0f, (float)1.0f);
            float easedScale = 1.0f - (float)Math.pow(1.0f - elapsed, 3.0);
            this.scale = Mth.m_14179_((float)easedScale, (float)this.scale, (float)this.targetScale);
            if (this.animating && now < this.animStart) {
                this.px = this.m_252754_();
                this.py = this.m_252907_();
                this.angle = 0.0f;
                this.alpha = 1.0f;
            } else if (this.animating) {
                float dt = (float)(now - this.lastUpdateTime) / 1000.0f;
                this.lastUpdateTime = now;
                float t = (float)(now - this.animStart) / 1000.0f;
                float fadeProgress = Math.max(0.0f, 1.0f - t / 2.0f);
                this.alpha = Math.max(0.0f, (float)Math.pow(fadeProgress, 2.0));
                if (this.isPressedButton) {
                    this.angle += this.spin * dt;
                    this.px = this.m_252754_();
                    this.py = this.m_252907_();
                    float progress = t / 2.0f;
                    float c1 = 1.70158f;
                    float c3 = c1 + 1.0f;
                    float eased = c3 * progress * progress * progress - c1 * progress * progress;
                    float shrinkFactor = 1.0f - eased;
                    this.scale = (this.scale + 0.3f * (float)Math.sin((double)(t * 2.0f) * Math.PI * 3.0)) * shrinkFactor;
                } else {
                    this.vx = (float)((double)this.vx * Math.pow(0.9, dt));
                    this.vy += 980.0f * dt;
                    this.px += this.vx * dt;
                    this.py += this.vy * dt;
                    this.angle += this.spin * dt;
                }
            } else {
                this.px = this.m_252754_();
                this.py = this.m_252907_();
                this.angle = 0.0f;
                this.alpha = 1.0f;
            }
            this.alpha = Mth.m_14036_((float)this.alpha, (float)0.0f, (float)1.0f);
            this.scale = Math.max(this.scale, 0.0f);
            if (this.shockwaveActive) {
                float elapsedSW = (float)(now - this.shockwaveStart) / 1000.0f;
                this.shockwaveScale = 600.0f * elapsedSW / 12.0f;
                this.shockwaveAlpha = 1.0f;
                if (this.shockwaveScale > 20.0f) {
                    float excess = this.shockwaveScale - 20.0f;
                    this.shockwaveAlpha = Math.max(0.0f, 1.0f - excess / 30.0f);
                }
                if (this.shockwaveAlpha <= 0.0f) {
                    this.shockwaveActive = false;
                }
                this.shockwaveAlpha = Mth.m_14036_((float)this.shockwaveAlpha, (float)0.0f, (float)1.0f);
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_(this.px + (float)this.f_93618_ / 2.0f, this.py + (float)this.f_93619_ / 2.0f, 0.0f);
                graphics.m_280168_().m_85841_(this.shockwaveScale, this.shockwaveScale, 1.0f);
                graphics.m_280246_(1.0f, 1.0f, 1.0f, this.shockwaveAlpha);
                graphics.m_280163_(SHOCKWAVE_TEX, -this.f_93618_ / 2, -this.f_93619_ / 2, 0.0f, 0.0f, this.f_93618_, this.f_93619_, this.f_93618_, this.f_93619_);
                graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
                graphics.m_280168_().m_85849_();
            }
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(this.px + (float)this.f_93618_ / 2.0f, this.py + (float)this.f_93619_ / 2.0f, 0.0f);
            graphics.m_280168_().m_85841_(this.scale, this.scale, 1.0f);
            graphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(this.angle));
            graphics.m_280246_(1.0f, 1.0f, 1.0f, this.alpha);
            graphics.m_280163_(this.f_94223_, -this.f_93618_ / 2, -this.f_93619_ / 2, 0.0f, 0.0f, this.f_93618_, this.f_93619_, this.f_93618_, this.f_93619_);
            graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            graphics.m_280168_().m_85849_();
        }

        public boolean isFadedOut() {
            return this.alpha <= 0.0f;
        }
    }
}

