/*
 * Decompiled with CFR 0.152.
 */
package puns.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import puns.Puns;

public class PunDataLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new Gson();
    private static final List<PunEntry> PUNS = new ArrayList<PunEntry>();

    public PunDataLoader() {
        super(GSON, "puns");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        PUNS.clear();
        objectMap.forEach((id, json) -> {
            try {
                if (json.isJsonArray()) {
                    for (JsonElement element : json.getAsJsonArray()) {
                        PunEntry entry = (PunEntry)GSON.fromJson(element, PunEntry.class);
                        if (entry == null) continue;
                        PUNS.add(entry);
                    }
                } else if (json.isJsonObject()) {
                    for (Map.Entry e : json.getAsJsonObject().entrySet()) {
                        PunEntry entry = (PunEntry)GSON.fromJson((JsonElement)e.getValue(), PunEntry.class);
                        if (entry == null) continue;
                        PUNS.add(entry);
                    }
                } else {
                    Puns.LOGGER.error("Invalid pun JSON format in " + String.valueOf(id));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    public static void forceLoad() {
        try (InputStreamReader reader = new InputStreamReader(PunDataLoader.class.getResourceAsStream("/data/puns/puns/puns.json"));){
            JsonElement root = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
            PUNS.clear();
            if (root.isJsonArray()) {
                for (JsonElement element : root.getAsJsonArray()) {
                    PunEntry entry = (PunEntry)GSON.fromJson(element, PunEntry.class);
                    if (entry == null) continue;
                    PUNS.add(entry);
                }
            }
            Puns.LOGGER.error("Found puns json!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<PunEntry> getPuns() {
        return PUNS;
    }

    public static PunEntry getRandomPun(RandomSource random) {
        if (PUNS.isEmpty()) {
            return null;
        }
        return PUNS.get(random.m_188503_(PUNS.size()));
    }

    public record PunEntry(String question, String answer) {
    }
}

