/*
 * Decompiled with CFR 0.152.
 */
package puns;

import com.mojang.logging.LogUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddServerReloadListenersEvent;
import org.slf4j.Logger;
import puns.client.ClientEventHandler;
import puns.common.PunCommand;
import puns.data.PunDataLoader;

@Mod(value="puns")
public class Puns {
    public static final String MOD_ID = "puns";
    public static final String MOD_NAME = "Puns";
    public static final Logger LOGGER = LogUtils.getLogger();

    public Puns(ModContainer mod, IEventBus bus) {
        PunDataLoader.forceLoad();
        IEventBus eventBus = NeoForge.EVENT_BUS;
        eventBus.addListener(PunCommand::onRegisterCommands);
        if (FMLEnvironment.getDist().isClient()) {
            ClientEventHandler.init(eventBus);
        }
        LOGGER.info("Loaded!");
    }

    public static void onAddReloadListener(AddServerReloadListenersEvent event) {
        event.addListener(Puns.identifier("puns_loader"), (PreparableReloadListener)new PunDataLoader());
    }

    public static ResourceLocation identifier(String name) {
        return Puns.resourceLocation(MOD_ID, name);
    }

    public static ResourceLocation resourceLocation(String name) {
        return ResourceLocation.parse((String)name);
    }

    public static ResourceLocation resourceLocation(String domain, String path) {
        return ResourceLocation.fromNamespaceAndPath((String)domain, (String)path);
    }

    public static int rgbaToInt(float r, float g, float b, float a) {
        int ri = (int)(r * 255.0f);
        int gi = (int)(g * 255.0f);
        int bi = (int)(b * 255.0f);
        int ai = (int)(a * 255.0f);
        return ai << 24 | ri << 16 | gi << 8 | bi;
    }
}

