/*
 * Decompiled with CFR 0.152.
 */
package puns.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import puns.Puns;
import puns.client.ClientEventHandler;
import puns.data.PunDataLoader;

public class PunIntroScreen
extends Screen {
    public static String[] REACTIONS = new String[]{"angry", "cool", "cringe", "crossed", "expressionless", "grimace", "neutral", "rolling", "smiling", "zany"};
    public static final ResourceLocation BACKGROUND_LOCATION = Puns.resourceLocation("textures/block/dirt.png");
    public static final String SCREEN_NAME = "puns.screen.pun";
    public PunDataLoader.PunEntry pun = PunDataLoader.getRandomPun(RandomSource.create());
    public final Screen parent;
    public boolean animating = false;
    public boolean fadingOut = false;
    public long fadeStart;
    private boolean shaking = false;
    private long shakeStart;
    private float shakeDuration = 2.0f;
    private float alpha = 1.0f;

    public PunIntroScreen(Screen parent) {
        super((Component)Component.translatable((String)SCREEN_NAME));
        this.parent = parent;
        REACTIONS = PunIntroScreen.getShuffledReactions();
        ClientEventHandler.HAS_SHOWN_PUN_SCREEN = true;
    }

    public static String[] getShuffledReactions() {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(REACTIONS));
        Collections.shuffle(list);
        return list.toArray(new String[0]);
    }

    public Screen getParent() {
        return this.parent;
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == ClientEventHandler.REFRESH_PUN_SCREEN.getKey().getValue()) {
            REACTIONS = PunIntroScreen.getShuffledReactions();
            this.pun = PunDataLoader.getRandomPun(RandomSource.create());
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected void init() {
        int spacing = 30;
        int totalWidth = 5 * spacing;
        int startX = this.width / 2 - totalWidth / 2;
        int rowY1 = this.height / 2 + 20;
        int rowY2 = rowY1 + 30;
        for (int i = 0; i < REACTIONS.length; ++i) {
            boolean row = i >= 5;
            int col = i % 5;
            int x = startX + col * spacing;
            int y = !row ? rowY1 : rowY2;
            ResourceLocation tex = Puns.identifier("textures/gui/reaction/" + REACTIONS[i] + ".png");
            String langKey = "puns.reaction." + REACTIONS[i];
            this.addRenderableWidget((GuiEventListener)new ReactionButton(x, y, tex, langKey, b -> this.startAnimation((ReactionButton)b)));
        }
    }

    public void startAnimation(ReactionButton pressed) {
        if (this.animating) {
            return;
        }
        this.animating = true;
        this.shaking = true;
        this.shakeStart = System.currentTimeMillis();
        for (Renderable widget : this.renderables) {
            ReactionButton rb;
            if (!(widget instanceof ReactionButton)) continue;
            rb.beginAnimation((rb = (ReactionButton)widget) == pressed, pressed.getX(), pressed.getY(), this.width, this.height);
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        float safetyMargin;
        float buttonsY;
        float maxBottom;
        float t;
        if (this.fadingOut) {
            t = (float)(System.currentTimeMillis() - this.fadeStart) / 1000.0f;
            this.alpha = Math.max(0.0f, 1.0f - t / 1.5f);
        }
        graphics.pose().pushMatrix();
        if (this.shaking) {
            t = (float)(System.currentTimeMillis() - this.shakeStart) / 1000.0f;
            if (t > this.shakeDuration) {
                this.shaking = false;
            } else {
                float progress = t / this.shakeDuration;
                float c1 = 1.70158f;
                float c3 = c1 + 1.0f;
                float eased = c3 * progress * progress * progress - c1 * progress * progress;
                float intensity = 3.0f * (1.0f - eased);
                float offsetX = intensity * (Mth.sin((float)(t * 25.0f)) + Mth.sin((float)(t * 40.0f))) * 0.5f;
                float offsetY = intensity * (Mth.cos((float)(t * 30.0f)) + Mth.cos((float)(t * 45.0f))) * 0.5f;
                graphics.pose().translate(offsetX, offsetY);
            }
        }
        this.renderFadingBackground(graphics, this.alpha);
        MutableComponent questionComp = Component.literal((String)this.pun.question()).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)));
        MutableComponent answerComp = Component.literal((String)this.pun.answer()).withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)));
        float questionScale = 1.5f;
        int questionMaxWidth = (int)((float)this.width / questionScale) - 40;
        List questionLines = this.font.split((FormattedText)questionComp, questionMaxWidth);
        Objects.requireNonNull(this.font);
        int lineHeight = 9;
        float questionBlockHeight = (float)(questionLines.size() * lineHeight) * questionScale + 2.0f;
        float answerScale = 1.25f;
        ArrayList answerLines = this.pun.answer().isEmpty() ? new ArrayList() : this.font.split((FormattedText)answerComp, (int)((float)this.width / answerScale) - 40);
        int answerLinesCount = answerLines.size();
        float answerBlockHeight = (float)(answerLinesCount * lineHeight) * answerScale;
        float margin = 4.5f;
        float fixedAnswerBottom = (float)this.height / 2.0f - 0.75f;
        float virtualAnswerHeight = (float)((answerLinesCount == 0 ? 1 : answerLinesCount) * lineHeight) * answerScale;
        float virtualAnswerTop = fixedAnswerBottom - virtualAnswerHeight;
        float questionBottom = virtualAnswerTop - margin;
        float questionTopEffective = questionBottom - questionBlockHeight;
        int questionStartYPre = (int)(questionTopEffective / questionScale);
        int questionCenterXPre = (int)((float)(this.width / 2) / questionScale);
        graphics.pose().pushMatrix();
        graphics.pose().scale(questionScale, questionScale);
        for (int i = 0; i < questionLines.size(); ++i) {
            FormattedCharSequence line = (FormattedCharSequence)questionLines.get(i);
            int lineWidth = this.font.width(line);
            graphics.drawString(this.font, line, questionCenterXPre - lineWidth / 2, questionStartYPre + i * lineHeight, Puns.rgbaToInt(1.0f, 1.0f, 1.0f, this.alpha), false);
        }
        graphics.pose().popMatrix();
        float actualBottom = questionTopEffective + questionBlockHeight;
        if (!this.pun.answer().isEmpty()) {
            float answerTopEffective = fixedAnswerBottom - answerBlockHeight;
            int answerStartYPre = (int)(answerTopEffective / answerScale);
            int answerCenterXPre = (int)((float)(this.width / 2) / answerScale);
            graphics.pose().pushMatrix();
            graphics.pose().scale(answerScale, answerScale);
            for (int i = 0; i < answerLines.size(); ++i) {
                FormattedCharSequence line = (FormattedCharSequence)answerLines.get(i);
                int lineWidth = this.font.width(line);
                graphics.drawString(this.font, line, answerCenterXPre - lineWidth / 2, answerStartYPre + i * lineHeight, Puns.rgbaToInt(0.8f, 0.8f, 0.8f, this.alpha), false);
            }
            graphics.pose().popMatrix();
            actualBottom = answerTopEffective + answerBlockHeight;
        }
        if (actualBottom > (maxBottom = (buttonsY = (float)(this.height / 2 + 20)) - (safetyMargin = 10.0f))) {
            float excess = actualBottom - maxBottom;
            questionStartYPre = (int)((questionTopEffective -= excess) / questionScale);
        }
        this.renderButtons(graphics, mouseX, mouseY, partialTicks);
        graphics.pose().popMatrix();
        if (this.animating && !this.fadingOut) {
            boolean allGone = true;
            for (Renderable widget : this.renderables) {
                ReactionButton rb;
                if (!(widget instanceof ReactionButton) || (rb = (ReactionButton)widget).isFadedOut()) continue;
                allGone = false;
                break;
            }
            if (allGone) {
                this.fadingOut = true;
                this.fadeStart = System.currentTimeMillis();
            }
        }
        if (this.fadingOut && this.alpha <= 0.0f) {
            Minecraft.getInstance().setScreen(this.parent);
        }
    }

    public void renderButtons(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public void renderFadingBackground(GuiGraphics graphics, float alpha) {
        alpha = Mth.clamp((float)alpha, (float)0.0f, (float)1.0f);
        graphics.pose().pushMatrix();
        graphics.blit(RenderPipelines.GUI_TEXTURED, BACKGROUND_LOCATION, 0, 0, 0.0f, 0.0f, this.width, this.height, 32, 32, Puns.rgbaToInt(0.25f, 0.25f, 0.25f, alpha));
        graphics.pose().popMatrix();
    }

    public static class ReactionButton
    extends ImageButton {
        private boolean animating = false;
        private boolean isPressedButton = false;
        private float alpha = 1.0f;
        private float scale = 1.0f;
        private float targetScale = 1.0f;
        private long hoverStart;
        private boolean hovering = false;
        private float px;
        private float py;
        private float vx;
        private float vy;
        private float spin;
        private float angle;
        private long animStart;
        private long lastUpdateTime;
        private boolean shockwaveActive = false;
        private long shockwaveStart;
        private float shockwaveScale = 0.0f;
        private float shockwaveAlpha = 1.0f;
        private static final ResourceLocation SHOCKWAVE_TEX = Puns.identifier("textures/gui/reaction_press.png");

        public ReactionButton(int x, int y, ResourceLocation texture, String langKey, Button.OnPress onPress) {
            super(x, y, 24, 24, new WidgetSprites(texture, texture), onPress, (Component)Component.translatable((String)langKey));
            this.setTooltip(Tooltip.create((Component)Component.translatable((String)langKey)));
            this.px = x;
            this.py = y;
        }

        public void beginAnimation(boolean pressed, int pressedX, int pressedY, int screenWidth, int screenHeight) {
            this.animating = true;
            this.isPressedButton = pressed;
            this.lastUpdateTime = this.animStart = System.currentTimeMillis();
            RandomSource r = RandomSource.create();
            if (pressed) {
                this.vy = 0.0f;
                this.vx = 0.0f;
                this.spin = (r.nextFloat() - 0.5f) * 360.0f;
                this.shockwaveActive = true;
                this.shockwaveStart = System.currentTimeMillis();
                this.shockwaveScale = 0.0f;
                this.shockwaveAlpha = 1.0f;
            } else {
                float dy;
                float dx = this.getX() - pressedX;
                float dist = (float)Math.sqrt(dx * dx + (dy = (float)(this.getY() - pressedY)) * dy);
                if (dist == 0.0f) {
                    dist = 1.0f;
                }
                float dirAngle = (float)Math.atan2(dy, dx);
                float nx = (float)Math.cos(dirAngle += (r.nextFloat() - 0.5f) * 0.3f);
                float ny = (float)Math.sin(dirAngle);
                float delay = dist / 600.0f;
                this.animStart += (long)(delay * 1000.0f);
                float speed = (r.nextFloat() * 10000.0f + 15000.0f) / (dist + 30.0f) + r.nextFloat() * 100.0f - 50.0f;
                this.vx = nx * speed;
                this.vy = ny * speed;
                this.spin = (r.nextFloat() - 0.5f) * 720.0f;
            }
            this.setTooltip(null);
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            long now = System.currentTimeMillis();
            boolean currentlyHovering = this.isHoveredOrFocused();
            if (currentlyHovering != this.hovering) {
                this.hovering = currentlyHovering;
                this.hoverStart = now;
                this.targetScale = this.hovering ? 1.25f : 1.0f;
            }
            float elapsed = (float)(now - this.hoverStart) / 200.0f;
            elapsed = Mth.clamp((float)elapsed, (float)0.0f, (float)1.0f);
            float easedScale = 1.0f - (float)Math.pow(1.0f - elapsed, 3.0);
            this.scale = Mth.lerp((float)easedScale, (float)this.scale, (float)this.targetScale);
            if (this.animating && now < this.animStart) {
                this.px = this.getX();
                this.py = this.getY();
                this.angle = 0.0f;
                this.alpha = 1.0f;
            } else if (this.animating) {
                float dt = (float)(now - this.lastUpdateTime) / 1000.0f;
                this.lastUpdateTime = now;
                float t = (float)(now - this.animStart) / 1000.0f;
                float fadeProgress = Math.max(0.0f, 1.0f - t / 2.0f);
                this.alpha = Math.max(0.0f, (float)Math.pow(fadeProgress, 2.0));
                if (this.isPressedButton) {
                    this.angle += this.spin * dt;
                    this.px = this.getX();
                    this.py = this.getY();
                    float progress = t / 2.0f;
                    float c1 = 1.70158f;
                    float c3 = c1 + 1.0f;
                    float eased = c3 * progress * progress * progress - c1 * progress * progress;
                    float shrinkFactor = 1.0f - eased;
                    this.scale = (this.scale + 0.3f * (float)Math.sin((double)(t * 2.0f) * Math.PI * 3.0)) * shrinkFactor;
                } else {
                    this.vx = (float)((double)this.vx * Math.pow(0.9, dt));
                    this.vy += 980.0f * dt;
                    this.px += this.vx * dt;
                    this.py += this.vy * dt;
                    this.angle += this.spin * dt;
                }
            } else {
                this.px = this.getX();
                this.py = this.getY();
                this.angle = 0.0f;
                this.alpha = 1.0f;
            }
            this.alpha = Mth.clamp((float)this.alpha, (float)0.0f, (float)1.0f);
            this.scale = Math.max(this.scale, 0.0f);
            if (this.shockwaveActive) {
                float elapsedSW = (float)(now - this.shockwaveStart) / 1000.0f;
                this.shockwaveScale = 600.0f * elapsedSW / 12.0f;
                this.shockwaveAlpha = 1.0f;
                if (this.shockwaveScale > 20.0f) {
                    float excess = this.shockwaveScale - 20.0f;
                    this.shockwaveAlpha = Math.max(0.0f, 1.0f - excess / 30.0f);
                }
                if (this.shockwaveAlpha <= 0.0f) {
                    this.shockwaveActive = false;
                }
                this.shockwaveAlpha = Mth.clamp((float)this.shockwaveAlpha, (float)0.0f, (float)1.0f);
                graphics.pose().pushMatrix();
                graphics.pose().translate(this.px + (float)this.width / 2.0f, this.py + (float)this.height / 2.0f);
                graphics.pose().scale(this.shockwaveScale, this.shockwaveScale);
                graphics.blit(RenderPipelines.GUI_TEXTURED, SHOCKWAVE_TEX, -this.width / 2, -this.height / 2, 0.0f, 0.0f, this.width, this.height, this.width, this.height, Puns.rgbaToInt(1.0f, 1.0f, 1.0f, this.shockwaveAlpha));
                graphics.pose().popMatrix();
            }
            graphics.pose().pushMatrix();
            graphics.pose().translate(this.px + (float)this.width / 2.0f, this.py + (float)this.height / 2.0f);
            graphics.pose().scale(this.scale, this.scale);
            graphics.pose().rotate((float)Math.toRadians(this.angle));
            graphics.blit(RenderPipelines.GUI_TEXTURED, this.sprites.get(this.isActive(), this.isHoveredOrFocused()), -this.width / 2, -this.height / 2, 0.0f, 0.0f, this.width, this.height, this.width, this.height, Puns.rgbaToInt(1.0f, 1.0f, 1.0f, this.alpha));
            graphics.pose().popMatrix();
        }

        public boolean isFadedOut() {
            return this.alpha <= 0.0f;
        }
    }
}

