/*
 * Decompiled with CFR 0.152.
 */
package puns.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import puns.Puns;

public class PunDataLoader
extends SimpleJsonResourceReloadListener<PunEntry> {
    private static final Gson GSON = new Gson();
    private static final List<PunEntry> PUNS = new ArrayList<PunEntry>();
    public static final Codec<PunEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("question").forGetter(PunEntry::question), (App)Codec.STRING.fieldOf("answer").forGetter(PunEntry::answer)).apply((Applicative)instance, PunEntry::new));
    private static final FileToIdConverter LISTER = new FileToIdConverter("puns", ".json");

    public PunDataLoader() {
        super(CODEC, LISTER);
    }

    protected void apply(Map<ResourceLocation, PunEntry> objectMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        PUNS.clear();
        objectMap.forEach((id, entry) -> {
            if (entry != null) {
                PUNS.add((PunEntry)entry);
            } else {
                Puns.LOGGER.error("Invalid pun JSON format in {}", id);
            }
        });
        Puns.LOGGER.info("Loaded {} puns", (Object)PUNS.size());
    }

    public static void forceLoad() {
        try (InputStreamReader reader = new InputStreamReader(PunDataLoader.class.getResourceAsStream("/data/puns/puns/puns.json"));){
            JsonElement root = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
            PUNS.clear();
            if (root.isJsonArray()) {
                for (JsonElement element : root.getAsJsonArray()) {
                    PunEntry entry = (PunEntry)GSON.fromJson(element, PunEntry.class);
                    if (entry == null) continue;
                    PUNS.add(entry);
                }
            }
            Puns.LOGGER.error("Found puns json!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<PunEntry> getPuns() {
        return PUNS;
    }

    public static PunEntry getRandomPun(RandomSource random) {
        if (PUNS.isEmpty()) {
            return null;
        }
        return PUNS.get(random.nextInt(PUNS.size()));
    }

    public record PunEntry(String question, String answer) {
    }
}

