/*
 * Decompiled with CFR 0.152.
 */
package puns.common;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraftforge.event.RegisterCommandsEvent;
import puns.data.PunDataLoader;

public class PunCommand {
    public static final String NONE_AVAILABLE = "puns.command.no_puns_available";

    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"pun").executes(ctx -> {
            List targets = ((CommandSourceStack)ctx.getSource()).m_81377_().m_6846_().m_11314_();
            return PunCommand.sendPun((CommandSourceStack)ctx.getSource(), targets, TextColor.m_131266_((int)0xFFFF55), false, false);
        })).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(ctx -> {
            Collection targets = EntityArgument.m_91477_((CommandContext)ctx, (String)"target");
            return PunCommand.sendPun((CommandSourceStack)ctx.getSource(), targets, TextColor.m_131266_((int)0xFFFF55), false, false);
        })).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"color", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            for (ChatFormatting format : ChatFormatting.values()) {
                if (!format.m_126664_()) continue;
                builder.suggest(format.m_126666_());
            }
            return builder.buildFuture();
        }).executes(ctx -> {
            Collection targets = EntityArgument.m_91477_((CommandContext)ctx, (String)"target");
            String colorName = StringArgumentType.getString((CommandContext)ctx, (String)"color");
            ChatFormatting chosen = ChatFormatting.m_126657_((String)colorName);
            if (chosen == null || !chosen.m_126664_()) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("Invalid color: " + colorName)));
                return 0;
            }
            return PunCommand.sendPun((CommandSourceStack)ctx.getSource(), targets, TextColor.m_131266_((int)chosen.m_126665_()), false, false);
        })).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"bold", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            Collection targets = EntityArgument.m_91477_((CommandContext)ctx, (String)"target");
            String colorName = StringArgumentType.getString((CommandContext)ctx, (String)"color");
            boolean bold = BoolArgumentType.getBool((CommandContext)ctx, (String)"bold");
            ChatFormatting chosen = ChatFormatting.m_126657_((String)colorName);
            if (chosen == null || !chosen.m_126664_()) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("Invalid color: " + colorName)));
                return 0;
            }
            return PunCommand.sendPun((CommandSourceStack)ctx.getSource(), targets, TextColor.m_131266_((int)chosen.m_126665_()), bold, false);
        })).then(Commands.m_82129_((String)"italic", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            Collection targets = EntityArgument.m_91477_((CommandContext)ctx, (String)"target");
            String colorName = StringArgumentType.getString((CommandContext)ctx, (String)"color");
            boolean bold = BoolArgumentType.getBool((CommandContext)ctx, (String)"bold");
            boolean italic = BoolArgumentType.getBool((CommandContext)ctx, (String)"italic");
            ChatFormatting chosen = ChatFormatting.m_126657_((String)colorName);
            if (chosen == null || !chosen.m_126664_()) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("Invalid color: " + colorName)));
                return 0;
            }
            return PunCommand.sendPun((CommandSourceStack)ctx.getSource(), targets, TextColor.m_131266_((int)chosen.m_126665_()), bold, italic);
        }))))));
    }

    public static int sendPun(CommandSourceStack source, Collection<ServerPlayer> targets, TextColor textColor, boolean bold, boolean italic) {
        Object object;
        PunDataLoader.PunEntry pun = PunDataLoader.getRandomPun(RandomSource.m_216327_());
        if (pun == null) {
            source.m_81352_((Component)Component.m_237115_((String)NONE_AVAILABLE));
            return 0;
        }
        String question = pun.question();
        String answer = pun.answer();
        String text = answer.isEmpty() ? question : question + " - " + answer;
        Style style = Style.f_131099_.m_131148_(textColor).m_131136_(Boolean.valueOf(bold)).m_131155_(Boolean.valueOf(italic));
        MutableComponent msg = Component.m_237113_((String)text).m_6270_(style);
        if (targets.isEmpty() && (object = source.m_81373_()) instanceof ServerPlayer) {
            ServerPlayer self = (ServerPlayer)object;
            self.m_213846_((Component)msg);
        } else {
            for (ServerPlayer player : targets) {
                player.m_213846_((Component)msg);
            }
        }
        return 1;
    }
}

