/*
 * Decompiled with CFR 0.152.
 */
package puns.config;

import java.util.function.Function;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final Config COMMON = Config.register(ModConfig.Type.COMMON, Config::new);
    public final ForgeConfigSpec.BooleanValue enableDebug;
    public final ForgeConfigSpec.BooleanValue enableOnline;
    public final ForgeConfigSpec.BooleanValue onlyPuns;

    public static void init() {
    }

    private static <C> C register(ModConfig.Type type, Function<ForgeConfigSpec.Builder, C> factory) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(factory);
        ModLoadingContext.get().registerConfig(type, (IConfigSpec)specPair.getRight());
        return (C)specPair.getLeft();
    }

    Config(ForgeConfigSpec.Builder innerBuilder) {
        Function<String, ForgeConfigSpec.Builder> builder = name -> innerBuilder.translation("puns.config.common." + name);
        innerBuilder.push("Debug");
        this.enableDebug = builder.apply("enableDebug").comment("If true, the mod will print detailed debug information to the log. Useful for troubleshooting or verifying server/client communication. Leave disabled for normal gameplay to avoid clutter in the logs.").define("enableDebug", false);
        innerBuilder.pop();
        this.enableOnline = builder.apply("enableOnline").comment("Where all the fun is kept and distributed from. Enable communication with the external stats server. When true, reactions and pun statistics are sent to and fetched from the backend API. When false, stats are only being stored in memory, and there will be no network requests.").define("enableOnline", true);
        this.onlyPuns = builder.apply("onlyPuns").comment("Controls what happens after reacting to a pun. If true, the game will proceed to the main title menu after a reaction. If false, the game will open another pun screen after a reaction instead, allowing continuous puns without returning to the menu.").define("onlyPuns", false);
    }
}

