/*
 * Decompiled with CFR 0.152.
 */
package puns.network;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import puns.Puns;
import puns.config.Config;
import puns.data.ReactionType;

public class PunStats {
    private static final String SERVER_URL = "http://158.178.157.217:5000/api";
    private static final Gson GSON = new Gson();
    private final Map<String, StatsCache> cache = new HashMap<String, StatsCache>();
    private static final long CACHE_TTL_MS = 30000L;

    public void addReaction(String punId, ReactionType reaction) {
        if (!((Boolean)Config.COMMON.enableOnline.get()).booleanValue()) {
            return;
        }
        new Thread(() -> {
            Puns.debugMessage("Sending reaction: punId=" + punId + ", reaction=" + reaction.name());
            this.sendReactionToServer(punId, reaction);
            StatsCache updated = this.fetchStatsFromServer(punId);
            Puns.debugMessage("Updated stats after reaction for punId=" + punId + " [pos=" + updated.positivePoints + ", neg=" + updated.negativePoints + ", approval=" + updated.approvalRating + ", count=" + updated.count + "]");
            this.cache.put(punId, updated);
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendReactionToServer(String punId, ReactionType reaction) {
        HttpURLConnection conn = null;
        try {
            String body;
            StringBuilder sb;
            BufferedReader br;
            URL url = new URL("http://158.178.157.217:5000/api/reaction");
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setDoOutput(true);
            conn.setConnectTimeout(4000);
            conn.setReadTimeout(6000);
            JsonObject payload = new JsonObject();
            payload.addProperty("pun_id", punId);
            payload.addProperty("reaction", reaction.name());
            String json = GSON.toJson((JsonElement)payload);
            Puns.debugMessage("POST /reaction payload: " + json);
            try (OutputStream os = conn.getOutputStream();){
                os.write(json.getBytes(StandardCharsets.UTF_8));
                os.flush();
            }
            int status = conn.getResponseCode();
            Puns.debugMessage("POST /reaction status=" + status);
            if (status >= 200 && status < 300) {
                br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
                try {
                    String line;
                    sb = new StringBuilder();
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                    }
                    body = sb.toString();
                }
                finally {
                    br.close();
                }
            }
            br = new BufferedReader(new InputStreamReader(conn.getErrorStream(), StandardCharsets.UTF_8));
            try {
                String line;
                sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                body = sb.toString();
            }
            finally {
                br.close();
            }
            Puns.debugMessage("POST /reaction body: " + body);
            if (status >= 200 && status < 300) {
                JsonObject response = (JsonObject)GSON.fromJson(body, JsonObject.class);
                StatsCache updated = this.updateCacheFromResponse(punId, response);
                Puns.debugMessage("Server returned stats after reaction for punId=" + punId + " [pos=" + updated.positivePoints + ", neg=" + updated.negativePoints + ", approval=" + updated.approvalRating + ", count=" + updated.count + "]");
            } else {
                Puns.LOGGER.warn("Reaction POST failed for punId=" + punId + " with status " + status + " and body: " + body);
            }
        }
        catch (Exception e) {
            Puns.LOGGER.error("Error sending reaction for punId=" + punId + ", reaction=" + reaction.name(), (Throwable)e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public int getApprovalRating(String punId) {
        StatsCache stats = this.fetchStatsIfNeeded(punId);
        return stats.approvalRating;
    }

    public int getPositivePoints(String punId) {
        StatsCache stats = this.fetchStatsIfNeeded(punId);
        return stats.positivePoints;
    }

    public int getNegativePoints(String punId) {
        StatsCache stats = this.fetchStatsIfNeeded(punId);
        return stats.negativePoints;
    }

    public int getStatsCount(String punId) {
        StatsCache stats = this.fetchStatsIfNeeded(punId);
        return stats.count;
    }

    private StatsCache fetchStatsIfNeeded(String punId) {
        StatsCache stats = this.cache.get(punId);
        if (((Boolean)Config.COMMON.enableOnline.get()).booleanValue()) {
            long now = System.currentTimeMillis();
            if (stats == null || now - stats.lastFetched > 30000L) {
                this.asyncFetchStats(punId);
            }
        }
        if (stats == null) {
            stats = new StatsCache();
            stats.positivePoints = 0;
            stats.negativePoints = 0;
            stats.approvalRating = 0;
            stats.count = 0;
            stats.lastFetched = System.currentTimeMillis();
            this.cache.put(punId, stats);
        }
        return stats;
    }

    public void asyncFetchStats(String punId) {
        new Thread(() -> {
            StatsCache stats = this.fetchStatsFromServer(punId);
            Map<String, StatsCache> map = this.cache;
            synchronized (map) {
                this.cache.put(punId, stats);
            }
            Puns.debugMessage("Async stats fetch complete for punId=" + punId);
        }, "PunStatsFetcher").start();
    }

    public StatsCache fetchStatsFromServer(String punId) {
        StatsCache stats = new StatsCache();
        try {
            URL url = new URL("http://158.178.157.217:5000/api/stats/" + punId);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                JsonObject response = (JsonObject)GSON.fromJson((Reader)br, JsonObject.class);
                stats = this.updateCacheFromResponse(punId, response);
            }
            conn.disconnect();
        }
        catch (Exception e) {
            Puns.LOGGER.error("Error fetching stats for punId=" + punId, (Throwable)e);
        }
        return stats;
    }

    private StatsCache updateCacheFromResponse(String punId, JsonObject response) {
        StatsCache stats = new StatsCache();
        if (response.has("positive_points")) {
            stats.positivePoints = response.get("positive_points").getAsInt();
        }
        if (response.has("negative_points")) {
            stats.negativePoints = response.get("negative_points").getAsInt();
        }
        if (response.has("approval_rating")) {
            stats.approvalRating = response.get("approval_rating").getAsInt();
        }
        if (response.has("count")) {
            stats.count = response.get("count").getAsInt();
        }
        stats.lastFetched = System.currentTimeMillis();
        Puns.debugMessage("Updated cache for punId=" + punId + " [pos=" + stats.positivePoints + ", neg=" + stats.negativePoints + ", approval=" + stats.approvalRating + ", count=" + stats.count + "]");
        this.cache.put(punId, stats);
        return stats;
    }

    private static class StatsCache {
        int positivePoints;
        int negativePoints;
        int approvalRating;
        int count;
        long lastFetched;

        private StatsCache() {
        }
    }
}

