/*
 * Decompiled with CFR 0.152.
 */
package puns;

import com.mojang.logging.LogUtils;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import org.slf4j.Logger;
import puns.client.ClientEventHandler;
import puns.common.PunCommand;
import puns.common.ServerEventHandler;
import puns.config.Config;
import puns.data.PunDataLoader;
import puns.network.IPunStats;
import puns.network.PacketHandler;

@Mod(value="puns")
public class Puns {
    public static final String MOD_ID = "puns";
    public static final String MOD_NAME = "Puns";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static IPunStats SERVER_PUN_STATS_HANDLER;

    public Puns(ModContainer mod, IEventBus bus) {
        mod.registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)Config.SPEC);
        PunDataLoader.loadPuns();
        IEventBus eventBus = NeoForge.EVENT_BUS;
        eventBus.addListener(PunCommand::onRegisterCommands);
        if (FMLEnvironment.dist.isClient()) {
            ClientEventHandler.init(bus, eventBus);
        }
        PacketHandler.init(bus);
        ServerEventHandler.init(eventBus);
        LOGGER.info("Loaded!");
    }

    public static ResourceLocation identifier(String name) {
        return Puns.resourceLocation(MOD_ID, name);
    }

    public static ResourceLocation resourceLocation(String name) {
        return ResourceLocation.parse((String)name);
    }

    public static ResourceLocation resourceLocation(String domain, String path) {
        return ResourceLocation.fromNamespaceAndPath((String)domain, (String)path);
    }

    public static int rgbaToInt(float r, float g, float b, float a) {
        int ri = (int)(r * 255.0f);
        int gi = (int)(g * 255.0f);
        int bi = (int)(b * 255.0f);
        int ai = (int)(a * 255.0f);
        return ai << 24 | ri << 16 | gi << 8 | bi;
    }

    public static void debugMessage(String string) {
        if (((Boolean)Config.COMMON.enableDebug.get()).booleanValue()) {
            LOGGER.debug(string);
        }
    }

    public static void warnMessage(String string) {
        if (((Boolean)Config.COMMON.enableDebug.get()).booleanValue()) {
            LOGGER.warn(string);
        }
    }

    public static void warnMessage(String string, Exception e) {
        if (((Boolean)Config.COMMON.enableDebug.get()).booleanValue()) {
            LOGGER.warn(string, (Throwable)e);
        }
    }

    public static void errorMessage(String string, Exception e) {
        if (((Boolean)Config.COMMON.enableDebug.get()).booleanValue()) {
            LOGGER.error(string, (Throwable)e);
        }
    }
}

