/*
 * Decompiled with CFR 0.152.
 */
package puns.network;

import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import puns.Puns;
import puns.client.ClientPacketHandler;
import puns.config.Config;
import puns.data.PunDataLoader;
import puns.data.ReactionType;
import puns.network.NetworkedPunStats;
import puns.network.PunPackets;

public class PacketHandler {
    public static void init(IEventBus bus) {
        bus.addListener(PacketHandler::registerPayloads);
    }

    public static void registerPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToClient(PunPackets.SyncConfigPayload.TYPE, PunPackets.SyncConfigPayload.CODEC, (payload, context) -> {
            ClientPacketHandler.applyServerConfig(payload.enableLocalStats(), payload.enableOnline());
            Config.COMMON.enableOnline.set((Object)payload.enableOnline());
            Config.COMMON.enableLocalStats.set((Object)payload.enableLocalStats());
            Puns.debugMessage("Server config applied: enableOnline=" + payload.enableOnline() + ", enableLocalStats=" + payload.enableLocalStats());
        });
        registrar.playToClient(PunPackets.StatsResponsePayload.TYPE, PunPackets.StatsResponsePayload.CODEC, (payload, context) -> NetworkedPunStats.updateCacheFromResponse(payload.pun(), payload.positivePoints(), payload.negativePoints(), payload.approvalRating(), payload.count()));
        registrar.playToServer(PunPackets.SendReactionPayload.TYPE, PunPackets.SendReactionPayload.CODEC, (payload, context) -> {
            Player player = context.player();
            if (Puns.SERVER_PUN_STATS_HANDLER == null) {
                return;
            }
            try {
                ReactionType rt = ReactionType.valueOf(payload.reaction());
                Puns.SERVER_PUN_STATS_HANDLER.addReaction(payload.pun(), rt);
                int pos = Puns.SERVER_PUN_STATS_HANDLER.getPositivePoints(payload.pun());
                int neg = Puns.SERVER_PUN_STATS_HANDLER.getNegativePoints(payload.pun());
                int app = Puns.SERVER_PUN_STATS_HANDLER.getApprovalRating(payload.pun());
                int cnt = Puns.SERVER_PUN_STATS_HANDLER.getStatsCount(payload.pun());
                ((ServerPlayer)player).connection.send((Packet)new ClientboundCustomPayloadPacket((CustomPacketPayload)new PunPackets.StatsResponsePayload(payload.pun(), pos, neg, app, cnt)));
            }
            catch (IllegalArgumentException e) {
                Puns.LOGGER.warn("Invalid reaction from " + player.getName().getString() + ": " + payload.reaction());
            }
        });
        registrar.playToServer(PunPackets.FetchStatsPayload.TYPE, PunPackets.FetchStatsPayload.CODEC, (payload, context) -> {
            Player player = context.player();
            if (Puns.SERVER_PUN_STATS_HANDLER == null) {
                return;
            }
            int pos = Puns.SERVER_PUN_STATS_HANDLER.getPositivePoints(payload.pun());
            int neg = Puns.SERVER_PUN_STATS_HANDLER.getNegativePoints(payload.pun());
            int app = Puns.SERVER_PUN_STATS_HANDLER.getApprovalRating(payload.pun());
            int cnt = Puns.SERVER_PUN_STATS_HANDLER.getStatsCount(payload.pun());
            ((ServerPlayer)player).connection.send((Packet)new ClientboundCustomPayloadPacket((CustomPacketPayload)new PunPackets.StatsResponsePayload(payload.pun(), pos, neg, app, cnt)));
        });
        registrar.playToClient(PunPackets.SyncPunsPayload.TYPE, PunPackets.SyncPunsPayload.CODEC, (payload, context) -> PunDataLoader.receiveSyncedPuns(payload.puns()));
        registrar.playToClient(PunPackets.ListPunsPayload.TYPE, PunPackets.ListPunsPayload.CODEC, (payload, context) -> {
            Puns.LOGGER.info("Client Active Puns (" + payload.puns().size() + ")");
            for (PunDataLoader.PunEntry entry : payload.puns()) {
                Puns.LOGGER.info("[ID: " + entry.id() + "] " + entry.question() + " -> " + entry.answer());
            }
            context.player().sendSystemMessage((Component)Component.literal((String)("List of " + payload.puns().size() + " puns has been printed to your game log.")));
        });
        registrar.playToClient(PunPackets.OpenVoteScreenPayload.TYPE, PunPackets.OpenVoteScreenPayload.CODEC, (payload, context) -> ClientPacketHandler.openVoteScreen(payload.pun()));
    }
}

