/*
 * Decompiled with CFR 0.152.
 */
package puns.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import puns.Puns;
import puns.client.PunVoteScreen;
import puns.config.Config;
import puns.data.PunDataLoader;
import puns.network.HybridPunStatsHandler;
import puns.network.NetworkedPunStats;

public class ClientPacketHandler {
    public static void openVoteScreen(PunDataLoader.PunEntry pun) {
        Minecraft mc = Minecraft.getInstance();
        mc.setScreen((Screen)new PunVoteScreen(pun));
    }

    public static void applyServerConfig(boolean serverEnableLocalStats, boolean serverEnableOnline) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.getConnection() != null && !mc.getConnection().getConnection().isMemoryConnection()) {
            if (!(Puns.SERVER_PUN_STATS_HANDLER instanceof NetworkedPunStats)) {
                Puns.SERVER_PUN_STATS_HANDLER = new NetworkedPunStats();
                Puns.debugMessage("Remote server detected \u00e2\u2020\u2019 using NetworkedPunStats (packet-based)");
            }
        } else if (!(Puns.SERVER_PUN_STATS_HANDLER instanceof HybridPunStatsHandler)) {
            Puns.SERVER_PUN_STATS_HANDLER = new HybridPunStatsHandler();
            Puns.debugMessage("Singleplayer/LAN \u00e2\u2020\u2019 using direct HybridPunStatsHandler");
        }
        Config.COMMON.enableLocalStats.set((Object)serverEnableLocalStats);
        Config.COMMON.enableOnline.set((Object)serverEnableOnline);
    }
}

