/*
 * Decompiled with CFR 0.152.
 */
package puns.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import puns.Puns;
import puns.client.PunIntroScreen;
import puns.data.PunDataLoader;
import puns.data.ReactionType;

public class PunVoteScreen
extends PunIntroScreen {
    public static final ResourceLocation guiTex = Puns.identifier("textures/gui/pun_vote.png");
    public final int texWidth;
    public final int texHeight;

    public PunVoteScreen(PunDataLoader.PunEntry pun) {
        super(null);
        this.texWidth = 270;
        this.texHeight = 190;
        if (pun == null) {
            pun = new PunDataLoader.PunEntry(-1, "The pun was intended", "Though it was never received");
        }
        this.pun = pun;
        this.stats = Puns.SERVER_PUN_STATS_HANDLER;
        Puns.debugMessage("Opening PunVoteScreen for pun: " + String.valueOf(pun) + ", refreshing stats cache");
        this.stats.asyncFetchStats(this.pun);
        this.wheel = new PunIntroScreen.WheelOfFortune(this);
        this.ticksSinceLastStatsRefresh = 0;
        Puns.debugMessage("Using stats handler: " + Puns.SERVER_PUN_STATS_HANDLER.getClass().getSimpleName());
    }

    @Override
    public boolean canReloadPuns() {
        return false;
    }

    @Override
    protected void init() {
        int spacing = 30;
        int totalWidth = 5 * spacing;
        int startX = this.width / 2 - totalWidth / 2;
        int rowY1 = this.height / 2 + 5;
        int rowY2 = rowY1 + 30;
        ArrayList reactions = new ArrayList(ORDERED_REACTIONS_FOR_WHEEL);
        Collections.shuffle(reactions);
        for (int i = 0; i < reactions.size(); ++i) {
            boolean row = i >= 5;
            int col = i % 5;
            int x = startX + col * spacing;
            int y = !row ? rowY1 : rowY2;
            ReactionType reaction = (ReactionType)((Object)reactions.get(i));
            ResourceLocation tex = Puns.identifier("textures/gui/reaction/" + reaction.name().toLowerCase() + ".png");
            String langKey = "puns.reaction." + reaction.name().toLowerCase();
            this.addRenderableWidget((GuiEventListener)new PunIntroScreen.ReactionButton(this, x, y, tex, langKey, reaction));
        }
        int guiX = (this.width - 270) / 2;
        int guiY = (this.height - 190) / 2 - 10;
        int buttonX = guiX + 270 + 2;
        int buttonY = guiY + 190 - 30;
        float buttonScale = 1.5f;
        this.wheelButton = (PunIntroScreen.WheelOpenButton)this.addRenderableWidget((GuiEventListener)new PunIntroScreen.WheelOpenButton(this, buttonX, buttonY, buttonScale));
    }

    @Override
    public void resize(Minecraft mc, int width, int height) {
        boolean wasActive = this.wheel.isActive();
        float currentAngle = this.wheel.wheelAngle;
        float currentVel = this.wheel.angularVelocity;
        boolean exceeded = this.wheel.hasExceededThreshold;
        super.resize(mc, width, height);
        this.clearWidgets();
        this.init();
        this.setWheelActive(wasActive);
        if (wasActive) {
            this.wheel.wheelAngle = currentAngle;
            this.wheel.angularVelocity = currentVel;
            this.wheel.hasExceededThreshold = exceeded;
        }
    }

    @Override
    public void startAnimation(PunIntroScreen.ReactionButton pressed) {
        int startY;
        int startX;
        if (this.animating) {
            return;
        }
        this.animating = true;
        this.shaking = true;
        this.shakeStart = System.currentTimeMillis();
        this.reactionTime = System.currentTimeMillis();
        for (Renderable widget : this.renderables) {
            PunIntroScreen.ReactionButton rb;
            if (!(widget instanceof PunIntroScreen.ReactionButton)) continue;
            rb.beginAnimation((rb = (PunIntroScreen.ReactionButton)widget) == pressed, pressed.getX(), pressed.getY(), this.width, this.height);
        }
        if (this.wheelButton != null) {
            this.wheelButton.active = false;
        }
        ReactionType reaction = pressed.getReaction();
        this.stats.addReaction(this.pun, reaction);
        this.stats.asyncFetchStats(this.pun);
        if (this.wheel.isActive()) {
            startX = this.width / 2;
            startY = this.height / 2 + 10;
        } else {
            startX = pressed.getX() + pressed.getWidth() / 2;
            startY = pressed.getY() + pressed.getHeight() / 2;
        }
        this.floatingTexts.add(new PunIntroScreen.FloatingPointText(this, startX, startY, reaction));
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && !this.wheel.hasExceededThreshold()) {
            this.stats.addReaction(this.pun, ReactionType.NEUTRAL);
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        float safetyMargin;
        float buttonsY;
        float maxBottom;
        if (this.alpha <= 0.0f) {
            return;
        }
        graphics.pose().pushMatrix();
        if (this.title != null && this.title.equals((Object)Component.empty())) {
            graphics.drawCenteredString(this.font, this.title, this.width / 2, 24, 0xFFFFFF);
        }
        if (this.shaking) {
            float t = (float)(System.currentTimeMillis() - this.shakeStart) / 1000.0f;
            if (t > this.shakeDuration) {
                this.shaking = false;
            } else {
                float progress = t / this.shakeDuration;
                float c1 = 1.70158f;
                float c3 = c1 + 1.0f;
                float eased = c3 * progress * progress * progress - c1 * progress * progress;
                float intensity = 3.0f * (1.0f - eased);
                float offsetX = intensity * (Mth.sin((float)(t * 25.0f)) + Mth.sin((float)(t * 40.0f))) * 0.5f;
                float offsetY = intensity * (Mth.cos((float)(t * 30.0f)) + Mth.cos((float)(t * 45.0f))) * 0.5f;
                graphics.pose().translate(offsetX, offsetY);
            }
        }
        this.renderFadingBackground(graphics, 1.0f);
        MutableComponent questionComp = Component.literal((String)this.pun.question()).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)));
        MutableComponent answerComp = Component.literal((String)this.pun.answer()).withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)));
        float questionScale = 1.4f;
        int questionMaxWidth = (int)((float)this.texWidth * 0.65f);
        List questionLines = this.font.split((FormattedText)questionComp, questionMaxWidth);
        Objects.requireNonNull(this.font);
        int lineHeight = 9;
        float questionBlockHeight = (float)(questionLines.size() * lineHeight) * questionScale + 2.0f;
        float answerScale = 1.175f;
        ArrayList answerLines = this.pun.answer().isEmpty() ? new ArrayList() : this.font.split((FormattedText)answerComp, questionMaxWidth);
        int answerLinesCount = answerLines.size();
        float answerBlockHeight = (float)(answerLinesCount * lineHeight) * answerScale;
        float margin = 4.5f;
        float fixedAnswerBottom = (float)this.height / 2.0f - 17.0f;
        float virtualAnswerHeight = (float)((answerLinesCount == 0 ? 1 : answerLinesCount) * lineHeight) * answerScale;
        float virtualAnswerTop = fixedAnswerBottom - virtualAnswerHeight;
        float questionBottom = virtualAnswerTop - margin;
        float questionTopEffective = questionBottom - questionBlockHeight;
        int questionStartYPre = (int)(questionTopEffective / questionScale);
        int questionCenterXPre = (int)((float)(this.width / 2) / questionScale);
        int maxQuestionWidth = 0;
        for (FormattedCharSequence line : questionLines) {
            maxQuestionWidth = Math.max(maxQuestionWidth, this.font.width(line));
        }
        graphics.pose().pushMatrix();
        graphics.pose().scale(questionScale, questionScale);
        for (int i = 0; i < questionLines.size(); ++i) {
            FormattedCharSequence line;
            line = (FormattedCharSequence)questionLines.get(i);
            int lineWidth = this.font.width(line);
            graphics.drawString(this.font, line, questionCenterXPre - lineWidth / 2, questionStartYPre + i * lineHeight, Puns.rgbaToInt(1.0f, 1.0f, 1.0f, 1.0f), false);
        }
        graphics.pose().popMatrix();
        float actualBottom = questionTopEffective + questionBlockHeight;
        float answerTopEffective = 0.0f;
        if (!this.pun.answer().isEmpty()) {
            answerTopEffective = fixedAnswerBottom - answerBlockHeight;
            int answerStartYPre = (int)(answerTopEffective / answerScale);
            int answerCenterXPre = (int)((float)(this.width / 2) / answerScale);
            graphics.pose().pushMatrix();
            graphics.pose().scale(answerScale, answerScale);
            for (int i = 0; i < answerLines.size(); ++i) {
                FormattedCharSequence line = (FormattedCharSequence)answerLines.get(i);
                int lineWidth = this.font.width(line);
                graphics.drawString(this.font, line, answerCenterXPre - lineWidth / 2, answerStartYPre + i * lineHeight, Puns.rgbaToInt(0.8f, 0.8f, 0.8f, 1.0f), false);
            }
            graphics.pose().popMatrix();
            actualBottom = answerTopEffective + answerBlockHeight;
        }
        if (actualBottom > (maxBottom = (buttonsY = (float)(this.height / 2 + 20)) - (safetyMargin = 10.0f))) {
            float excess = actualBottom - maxBottom;
            questionStartYPre = (int)((questionTopEffective -= excess) / questionScale);
        }
        this.renderButtons(graphics, mouseX, mouseY, partialTicks);
        for (Renderable r : this.renderables) {
            if (!(r instanceof PunIntroScreen.ReactionButton)) continue;
            PunIntroScreen.ReactionButton rb = (PunIntroScreen.ReactionButton)r;
            rb.setTooltip(this.wheel.isActive() ? null : rb.toolTip);
        }
        graphics.nextStratum();
        if (this.wheel.isActive()) {
            graphics.blurBeforeThisStratum();
        }
        this.renderWheelButton(graphics, mouseX, mouseY, partialTicks);
        this.drawApprovalRating(graphics, this.alpha, questionTopEffective, questionBlockHeight, answerTopEffective, answerBlockHeight, questionCenterXPre, maxQuestionWidth, questionScale);
        if (this.wheel.isActive()) {
            this.wheel.tick(partialTicks);
            this.wheel.render(graphics, mouseX, mouseY, partialTicks);
        }
        this.floatingTexts.removeIf(PunIntroScreen.FloatingPointText::isExpired);
        for (PunIntroScreen.FloatingPointText ft : this.floatingTexts) {
            ft.render(graphics, this.font);
        }
        graphics.pose().popMatrix();
        if (this.animating && !this.fadingOut && this.reactionTime > 0L && System.currentTimeMillis() - this.reactionTime >= 2000L) {
            this.fadingOut = true;
            this.fadeStart = System.currentTimeMillis();
        }
        if (this.fadingOut) {
            this.goToWindow();
        }
    }

    @Override
    public void renderFadingBackground(GuiGraphics graphics, float alpha) {
        graphics.pose().pushMatrix();
        int x = (this.width - this.texWidth) / 2;
        int y = (this.height - this.texHeight) / 2 - 10;
        graphics.blit(RenderPipelines.GUI_TEXTURED, guiTex, x, y, 0.0f, 0.0f, this.texWidth, this.texHeight, this.texWidth, this.texHeight, Puns.rgbaToInt(1.0f, 1.0f, 1.0f, 1.0f));
        graphics.pose().popMatrix();
    }

    @Override
    public void goToWindow() {
        Minecraft.getInstance().setScreen(null);
    }

    @Override
    public void drawApprovalRating(GuiGraphics graphics, float alpha, float questionTopEffective, float questionBlockHeight, float answerTopEffective, float answerBlockHeight, int questionCenterXPre, int maxQuestionWidth, float questionScale) {
        int questionTopYScreen;
        int questionLeftXScreen;
        MutableComponent ratingComp;
        if (this.stats == null) {
            return;
        }
        int rating = this.stats.getApprovalRating(this.pun);
        String emoticon = rating >= 69 && rating < 70 ? "... nice" : (rating >= 75 ? ":)" : (rating <= 25 ? ":(" : ""));
        boolean noRatings = this.stats.getPositivePoints(this.pun) == 0 && this.stats.getNegativePoints(this.pun) == 0;
        MutableComponent noRating = Component.translatable((String)"puns.screen.no_rating");
        MutableComponent mutableComponent = ratingComp = noRatings ? noRating : Component.translatable((String)"puns.screen.approval", (Object[])new Object[]{rating + "%", emoticon});
        if (this.wheel.isActive()) {
            int centerX = (int)((double)this.width / 2.0 + (double)this.wheel.xOffset);
            int centerY = (int)((double)this.height / 2.0 + (double)this.wheel.yOffset);
            questionLeftXScreen = centerX - 63 - 14;
            questionTopYScreen = centerY - 84 + 12;
        } else {
            questionLeftXScreen = (int)((float)(questionCenterXPre - maxQuestionWidth / 2) * questionScale);
            questionTopYScreen = (int)questionTopEffective;
        }
        String raw = ratingComp.getString();
        ArrayList<String> lines = new ArrayList<String>();
        if (raw.contains("!")) {
            String[] parts = raw.split("\\!");
            for (int i = 0; i < parts.length; ++i) {
                Object line = parts[i].trim();
                if (((String)line).isEmpty()) continue;
                if (i < parts.length - 1) {
                    line = (String)line + "!";
                }
                lines.add((String)line);
            }
        } else {
            lines.add(raw);
        }
        int n = lines.size();
        Objects.requireNonNull(this.font);
        int ratingBlockHeight = n * 9;
        int anchorX = questionLeftXScreen - 5;
        int maxLineWidth = 0;
        for (String line : lines) {
            maxLineWidth = Math.max(maxLineWidth, this.font.width(line));
        }
        int leftEdge = anchorX - maxLineWidth / 2;
        int rightEdge = anchorX + maxLineWidth / 2;
        if (leftEdge < 0) {
            anchorX += -leftEdge + 2;
        } else if (rightEdge > this.width) {
            anchorX -= rightEdge - this.width + 2;
        }
        graphics.pose().pushMatrix();
        graphics.pose().translate((float)anchorX, (float)questionTopYScreen - 2.0f);
        graphics.pose().rotate((float)Math.toRadians(-20.0));
        float f = 1.8f - Mth.abs((float)(Mth.sin((float)((float)(Util.getMillis() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
        f = f * 100.0f / (float)(this.font.width((FormattedText)noRating) + 32);
        graphics.pose().scale(f, f);
        int color = Puns.rgbaToInt(1.0f, 1.0f, 0.0f, alpha);
        int y = -ratingBlockHeight;
        for (String line : lines) {
            graphics.drawCenteredString(this.font, (Component)Component.literal((String)line), 0, y, color);
            Objects.requireNonNull(this.font);
            y += 9;
        }
        graphics.pose().popMatrix();
    }
}

