/*
 * Decompiled with CFR 0.152.
 */
package puns.client;

import com.mojang.math.Axis;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.SplashRenderer;

public class MultiLineSplashRenderer
extends SplashRenderer {
    private final List<String> lines;
    private final Alignment alignment;

    public MultiLineSplashRenderer(List<String> lines, Alignment alignment) {
        super(lines.isEmpty() ? "" : lines.get(0));
        this.lines = lines;
        this.alignment = alignment;
    }

    public List<String> getLines() {
        return this.lines;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void render(GuiGraphics guiGraphics, int screenWidth, Font font, int color) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)screenWidth / 2.0f + 123.0f, 69.0f, 0.0f);
        guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(-20.0f));
        float f = 1.8f - Math.abs((float)Math.sin((double)((float)(System.currentTimeMillis() % 1000L) / 1000.0f) * (Math.PI * 2))) * 0.1f;
        int maxWidth = this.lines.stream().mapToInt(arg_0 -> ((Font)font).width(arg_0)).max().orElse(32);
        f = f * 100.0f / (float)(maxWidth + 32);
        guiGraphics.pose().scale(f, f, f);
        Objects.requireNonNull(font);
        int lineHeight = 9;
        int startY = -(this.lines.size() * lineHeight) / 2;
        block5: for (int i = 0; i < this.lines.size(); ++i) {
            String line = this.lines.get(i);
            int y = startY + i * lineHeight;
            switch (this.alignment.ordinal()) {
                case 0: {
                    guiGraphics.drawString(font, line, -maxWidth / 2, y, 0xFFFF00 | color, false);
                    continue block5;
                }
                case 2: {
                    guiGraphics.drawString(font, line, maxWidth / 2 - font.width(line), y, 0xFFFF00 | color, false);
                    continue block5;
                }
                case 1: {
                    guiGraphics.drawCenteredString(font, line, 0, y, 0xFFFF00 | color);
                }
            }
        }
        guiGraphics.pose().popPose();
    }

    public static enum Alignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

