/*
 * Decompiled with CFR 0.152.
 */
package puns.config;

import java.util.function.Function;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final Common COMMON;
    public static final ModConfigSpec SPEC;

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Common::new);
        COMMON = (Common)specPair.getLeft();
        SPEC = (ModConfigSpec)specPair.getRight();
    }

    public static class Common {
        public final ModConfigSpec.BooleanValue enableDebug;
        public final ModConfigSpec.BooleanValue enableOnline;
        public final ModConfigSpec.BooleanValue onlyPuns;

        Common(ModConfigSpec.Builder innerBuilder) {
            Function<String, ModConfigSpec.Builder> builder = name -> innerBuilder.translation("puns.config.common." + name);
            innerBuilder.push("Debug");
            this.enableDebug = builder.apply("enableDebug").comment("If true, the mod will print detailed debug information to the log. Useful for troubleshooting or verifying server/client communication. Leave disabled for normal gameplay to avoid clutter in the logs.").define("enableDebug", false);
            innerBuilder.pop();
            this.enableOnline = builder.apply("enableOnline").comment("Where all the fun is kept and distributed from. Enable communication with the external stats server. When true, reactions and pun statistics are sent to and fetched from the backend API. When false, stats are only being stored in memory, and there will be no network requests.").define("enableOnline", true);
            this.onlyPuns = builder.apply("onlyPuns").comment("Controls what happens after reacting to a pun. If true, the game will proceed to the main title menu after a reaction. If false, the game will open another pun screen after a reaction instead, allowing continuous puns without returning to the menu.").define("onlyPuns", false);
        }
    }
}

