/*
 * Decompiled with CFR 0.152.
 */
package puns.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import puns.Puns;
import puns.config.Config;

public class PunDataLoader
extends SimpleJsonResourceReloadListener<PunEntry> {
    private static final Gson GSON = new Gson();
    private static final List<PunEntry> PUNS = new ArrayList<PunEntry>();
    public static final String JSON_DATA_URL = "http://158.178.157.217:5000/api/puns";
    public static final Codec<PunEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(PunEntry::id), (App)Codec.STRING.fieldOf("question").forGetter(PunEntry::question), (App)Codec.STRING.fieldOf("answer").forGetter(PunEntry::answer)).apply((Applicative)instance, PunEntry::new));
    private static final FileToIdConverter LISTER = new FileToIdConverter("puns", ".json");

    public PunDataLoader() {
        super(CODEC, LISTER);
    }

    protected void apply(Map<ResourceLocation, PunEntry> objectMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        boolean loaded;
        PUNS.clear();
        boolean bl = loaded = (Boolean)Config.COMMON.enableOnline.get() != false ? PunDataLoader.loadFromUrl(JSON_DATA_URL) : false;
        if (!loaded) {
            objectMap.forEach((id, entry) -> {
                if (entry != null) {
                    PUNS.add((PunEntry)entry);
                } else {
                    Puns.debugMessage("Invalid pun JSON format in " + String.valueOf(id));
                }
            });
            if (!PUNS.isEmpty()) {
                Puns.debugMessage("Loaded puns from datapack resources.");
                loaded = true;
            }
        }
        if (!loaded) {
            Puns.debugMessage("Remote and datapack sources failed, falling back to local bundled JSON.");
            PunDataLoader.forceLoad();
        }
    }

    public static void forceLoad() {
        block10: {
            boolean loaded;
            PUNS.clear();
            boolean bl = loaded = (Boolean)Config.COMMON.enableOnline.get() != false ? PunDataLoader.loadFromUrl(JSON_DATA_URL) : false;
            if (!loaded) {
                try (InputStreamReader reader = new InputStreamReader(PunDataLoader.class.getResourceAsStream("/data/puns/puns/puns.json"));){
                    JsonElement root = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
                    if (root != null && root.isJsonArray()) {
                        for (JsonElement element : root.getAsJsonArray()) {
                            PunEntry entry = (PunEntry)GSON.fromJson(element, PunEntry.class);
                            if (entry == null) continue;
                            PUNS.add(entry);
                        }
                    }
                    Puns.debugMessage("Loaded puns from local resource!");
                }
                catch (Exception e) {
                    if (!((Boolean)Config.COMMON.enableDebug.get()).booleanValue()) break block10;
                    Puns.LOGGER.error("Failed to load local puns.json!", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean loadFromUrl(String url) {
        try {
            HttpURLConnection conn = (HttpURLConnection)URI.create(url).toURL().openConnection();
            conn.setConnectTimeout(2000);
            conn.setReadTimeout(3000);
            try (InputStreamReader reader = new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8);){
                JsonElement root = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
                if (root == null) {
                    boolean bl = false;
                    return bl;
                }
                List<PunEntry> list = PUNS;
                synchronized (list) {
                    PUNS.clear();
                    if (root.isJsonArray()) {
                        for (JsonElement element : root.getAsJsonArray()) {
                            PunEntry entry = (PunEntry)GSON.fromJson(element, PunEntry.class);
                            if (entry == null) continue;
                            PUNS.add(entry);
                        }
                    } else if (root.isJsonObject()) {
                        for (Map.Entry e : root.getAsJsonObject().entrySet()) {
                            PunEntry entry = (PunEntry)GSON.fromJson((JsonElement)e.getValue(), PunEntry.class);
                            if (entry == null) continue;
                            PUNS.add(entry);
                        }
                    }
                }
                Puns.debugMessage("Loaded puns from remote URL: " + url);
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            if ((Boolean)Config.COMMON.enableDebug.get() == false) return false;
            Puns.LOGGER.warn("Failed to fetch puns from " + url, (Throwable)e);
            return false;
        }
    }

    public static List<PunEntry> getPuns() {
        return PUNS;
    }

    public static PunEntry getRandomPun(RandomSource random) {
        if (PUNS.isEmpty()) {
            return null;
        }
        return PUNS.get(random.nextInt(PUNS.size()));
    }

    public record PunEntry(String id, String question, String answer) {
    }
}

