/*
 * Decompiled with CFR 0.152.
 */
package puns.common;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import puns.data.PunDataLoader;

public class PunCommand {
    public static final String NONE_AVAILABLE = "puns.command.no_puns_available";

    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"pun").executes(ctx -> {
            List targets = ((CommandSourceStack)ctx.getSource()).getServer().getPlayerList().getPlayers();
            return PunCommand.sendPun((CommandSourceStack)ctx.getSource(), targets, TextColor.fromRgb((int)0xFFFF55), false, false);
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.players()).executes(ctx -> {
            Collection targets = EntityArgument.getPlayers((CommandContext)ctx, (String)"target");
            return PunCommand.sendPun((CommandSourceStack)ctx.getSource(), targets, TextColor.fromRgb((int)0xFFFF55), false, false);
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"color", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            for (ChatFormatting format : ChatFormatting.values()) {
                if (!format.isColor()) continue;
                builder.suggest(format.getName());
            }
            return builder.buildFuture();
        }).executes(ctx -> {
            Collection targets = EntityArgument.getPlayers((CommandContext)ctx, (String)"target");
            String colorName = StringArgumentType.getString((CommandContext)ctx, (String)"color");
            ChatFormatting chosen = ChatFormatting.getByName((String)colorName);
            if (chosen == null || !chosen.isColor()) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("Invalid color: " + colorName)));
                return 0;
            }
            return PunCommand.sendPun((CommandSourceStack)ctx.getSource(), targets, TextColor.fromRgb((int)chosen.getColor()), false, false);
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"bold", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            Collection targets = EntityArgument.getPlayers((CommandContext)ctx, (String)"target");
            String colorName = StringArgumentType.getString((CommandContext)ctx, (String)"color");
            boolean bold = BoolArgumentType.getBool((CommandContext)ctx, (String)"bold");
            ChatFormatting chosen = ChatFormatting.getByName((String)colorName);
            if (chosen == null || !chosen.isColor()) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("Invalid color: " + colorName)));
                return 0;
            }
            return PunCommand.sendPun((CommandSourceStack)ctx.getSource(), targets, TextColor.fromRgb((int)chosen.getColor()), bold, false);
        })).then(Commands.argument((String)"italic", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            Collection targets = EntityArgument.getPlayers((CommandContext)ctx, (String)"target");
            String colorName = StringArgumentType.getString((CommandContext)ctx, (String)"color");
            boolean bold = BoolArgumentType.getBool((CommandContext)ctx, (String)"bold");
            boolean italic = BoolArgumentType.getBool((CommandContext)ctx, (String)"italic");
            ChatFormatting chosen = ChatFormatting.getByName((String)colorName);
            if (chosen == null || !chosen.isColor()) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("Invalid color: " + colorName)));
                return 0;
            }
            return PunCommand.sendPun((CommandSourceStack)ctx.getSource(), targets, TextColor.fromRgb((int)chosen.getColor()), bold, italic);
        }))))));
    }

    public static int sendPun(CommandSourceStack source, Collection<ServerPlayer> targets, TextColor textColor, boolean bold, boolean italic) {
        Object object;
        PunDataLoader.PunEntry pun = PunDataLoader.getRandomPun(RandomSource.create());
        if (pun == null) {
            source.sendFailure((Component)Component.translatable((String)NONE_AVAILABLE));
            return 0;
        }
        String question = pun.question();
        String answer = pun.answer();
        String text = answer.isEmpty() ? question : question + " - " + answer;
        Style style = Style.EMPTY.withColor(textColor).withBold(Boolean.valueOf(bold)).withItalic(Boolean.valueOf(italic));
        MutableComponent msg = Component.literal((String)text).setStyle(style);
        if (targets.isEmpty() && (object = source.getEntity()) instanceof ServerPlayer) {
            ServerPlayer self = (ServerPlayer)object;
            self.sendSystemMessage((Component)msg);
        } else {
            for (ServerPlayer player : targets) {
                player.sendSystemMessage((Component)msg);
            }
        }
        return 1;
    }
}

