/*
 * Decompiled with CFR 0.152.
 */
package puns;

import com.mojang.logging.LogUtils;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import org.slf4j.Logger;
import puns.client.ClientEventHandler;
import puns.common.PunCommand;
import puns.config.Config;
import puns.data.PunDataLoader;

@Mod(value="puns")
public class Puns {
    public static final String MOD_ID = "puns";
    public static final String MOD_NAME = "Puns";
    public static final Logger LOGGER = LogUtils.getLogger();

    public Puns(ModContainer mod, IEventBus bus) {
        mod.registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)Config.SPEC);
        PunDataLoader.forceLoad();
        IEventBus eventBus = NeoForge.EVENT_BUS;
        eventBus.addListener(PunCommand::onRegisterCommands);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientEventHandler.init(eventBus);
        }
        LOGGER.info("Loaded!");
    }

    public static ResourceLocation identifier(String name) {
        return Puns.resourceLocation(MOD_ID, name);
    }

    public static ResourceLocation resourceLocation(String name) {
        return ResourceLocation.parse((String)name);
    }

    public static ResourceLocation resourceLocation(String domain, String path) {
        return ResourceLocation.fromNamespaceAndPath((String)domain, (String)path);
    }

    public static int rgbaToInt(float r, float g, float b, float a) {
        int ri = (int)(r * 255.0f);
        int gi = (int)(g * 255.0f);
        int bi = (int)(b * 255.0f);
        int ai = (int)(a * 255.0f);
        return ai << 24 | ri << 16 | gi << 8 | bi;
    }

    public static void debugMessage(String string) {
        if (((Boolean)Config.COMMON.enableDebug.get()).booleanValue()) {
            LOGGER.debug(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasInternetConnection() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Boolean> future = executor.submit(() -> {
            try {
                URL url = URI.create("http://www.google.com").toURL();
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("HEAD");
                conn.setConnectTimeout(2000);
                conn.setReadTimeout(2000);
                int responseCode = conn.getResponseCode();
                return 200 <= responseCode && responseCode <= 399;
            }
            catch (Exception e) {
                return false;
            }
        });
        try {
            boolean bl = future.get(3L, TimeUnit.SECONDS);
            return bl;
        }
        catch (Exception e) {
            Thread.currentThread().interrupt();
            boolean bl = false;
            return bl;
        }
        finally {
            executor.shutdown();
        }
    }
}

