/*
 * Decompiled with CFR 0.152.
 */
package puns;

import com.mojang.logging.LogUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import org.slf4j.Logger;
import puns.client.ClientEventHandler;
import puns.common.PunCommand;
import puns.data.PunDataLoader;

@Mod(value="puns")
public class Puns {
    public static final String MOD_ID = "puns";
    public static final String MOD_NAME = "Puns";
    public static final Logger LOGGER = LogUtils.getLogger();

    public Puns(ModContainer mod, IEventBus bus) {
        PunDataLoader.forceLoad();
        IEventBus eventBus = NeoForge.EVENT_BUS;
        eventBus.addListener(Puns::onAddReloadListener);
        eventBus.addListener(PunCommand::onRegisterCommands);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientEventHandler.init(eventBus);
        }
        LOGGER.info("Loaded!");
    }

    public static void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new PunDataLoader());
    }

    public static ResourceLocation identifier(String name) {
        return Puns.resourceLocation(MOD_ID, name);
    }

    public static ResourceLocation resourceLocation(String name) {
        return ResourceLocation.parse((String)name);
    }

    public static ResourceLocation resourceLocation(String domain, String path) {
        return ResourceLocation.fromNamespaceAndPath((String)domain, (String)path);
    }
}

