/*
 * Decompiled with CFR 0.152.
 */
package puns.common;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import puns.data.PunDataLoader;

public class PunCommand {
    public static final String NONE_AVAILABLE = "puns.command.no_puns_available";

    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"pun").executes(ctx -> {
            List targets = ((CommandSourceStack)ctx.getSource()).getServer().getPlayerList().getPlayers();
            return PunCommand.sendPun((CommandSourceStack)ctx.getSource(), targets, null);
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.players()).executes(ctx -> {
            Collection targets = EntityArgument.getPlayers((CommandContext)ctx, (String)"target");
            return PunCommand.sendPun((CommandSourceStack)ctx.getSource(), targets, null);
        })).then(Commands.argument((String)"color", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            Collection targets = EntityArgument.getPlayers((CommandContext)ctx, (String)"target");
            return PunCommand.sendPun((CommandSourceStack)ctx.getSource(), targets, StringArgumentType.getString((CommandContext)ctx, (String)"color"));
        }))));
    }

    public static int sendPun(CommandSourceStack source, Collection<ServerPlayer> targets, String colorStr) {
        Object object;
        TextColor textColor;
        PunDataLoader.PunEntry pun = PunDataLoader.getRandomPun(RandomSource.create());
        if (pun == null) {
            source.sendFailure((Component)Component.translatable((String)NONE_AVAILABLE));
            return 0;
        }
        if (colorStr == null) {
            textColor = TextColor.fromRgb((int)0xFFFF55);
        } else {
            TextColor parsed = (TextColor)TextColor.parseColor((String)colorStr).getOrThrow();
            if (parsed != null) {
                textColor = parsed;
            } else if (colorStr.startsWith("\u00c2\u00a7") && colorStr.length() == 2) {
                char code = colorStr.charAt(1);
                ChatFormatting fmt = ChatFormatting.getByCode((char)code);
                textColor = fmt != null && fmt.getColor() != null ? TextColor.fromRgb((int)fmt.getColor()) : TextColor.fromRgb((int)0xFFFF55);
            } else {
                try {
                    ChatFormatting fmt = ChatFormatting.valueOf((String)colorStr.toUpperCase());
                    Integer rgb = fmt.getColor();
                    textColor = rgb != null ? TextColor.fromRgb((int)rgb) : TextColor.fromRgb((int)0xFFFF55);
                }
                catch (IllegalArgumentException ignored) {
                    textColor = TextColor.fromRgb((int)0xFFFF55);
                }
            }
        }
        String question = pun.question();
        String answer = pun.answer();
        String text = answer.isEmpty() ? question : question + " - " + answer;
        MutableComponent msg = Component.literal((String)text).setStyle(Style.EMPTY.withColor(textColor));
        if (targets.isEmpty() && (object = source.getEntity()) instanceof ServerPlayer) {
            ServerPlayer self = (ServerPlayer)object;
            self.sendSystemMessage((Component)msg);
        } else {
            for (ServerPlayer player : targets) {
                player.sendSystemMessage((Component)msg);
            }
        }
        return 1;
    }
}

