/*
 * Decompiled with CFR 0.152.
 */
package puns.client;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Collections;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import puns.Puns;
import puns.client.ClientPacketHandler;
import puns.client.PunIntroScreen;
import puns.config.Config;
import puns.data.PunDataLoader;
import puns.network.HybridPunStatsHandler;
import puns.network.LocalPunStats;
import puns.network.PunStats;

public class ClientEventHandler {
    public static final KeyMapping REFRESH_PUN_SCREEN = new KeyMapping("puns.key.refresh_pun_screen", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, InputConstants.Type.KEYSYM, 256, KeyMapping.Category.MISC);
    public static boolean HAS_SHOWN_PUN_SCREEN = false;
    public static boolean DRAW_SCREEN = false;

    public static void init(IEventBus modBus, IEventBus bus) {
        modBus.addListener(ClientEventHandler::onClientSetup);
        bus.addListener(ClientEventHandler::onScreenOpen);
        bus.addListener(ClientEventHandler::onClientLoggedOut);
        bus.addListener(ClientEventHandler::onClientLoggingIn);
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        if (!((Boolean)Config.COMMON.enableOnline.get()).booleanValue()) {
            Puns.SERVER_PUN_STATS_HANDLER = new LocalPunStats();
            Puns.debugMessage("Client config: enableOnline=false --> using LocalPunStats (global default)");
        } else if (((Boolean)Config.COMMON.enableLocalStats.get()).booleanValue()) {
            Puns.SERVER_PUN_STATS_HANDLER = new HybridPunStatsHandler();
            Puns.debugMessage("Client config: hybrid mode --> using HybridPunStatsHandler (global default)");
        } else {
            Puns.SERVER_PUN_STATS_HANDLER = new PunStats();
            Puns.debugMessage("Client config: pure remote --> using PunStats (global default)");
        }
    }

    public static void onScreenOpen(ScreenEvent.Opening event) {
        if (((Boolean)Config.COMMON.enablePunsBeforeTitle.get()).booleanValue() && !HAS_SHOWN_PUN_SCREEN && event.getScreen() instanceof TitleScreen) {
            event.setNewScreen((Screen)new PunIntroScreen(event.getScreen()));
        }
    }

    public static void onClientLoggedOut(ClientPlayerNetworkEvent.LoggingOut event) {
        PunDataLoader.receiveSyncedPuns(Collections.emptyList());
        Puns.SERVER_PUN_STATS_HANDLER = (Boolean)Config.COMMON.enableOnline.get() == false ? new LocalPunStats() : ((Boolean)Config.COMMON.enableLocalStats.get() != false ? new HybridPunStatsHandler() : new PunStats());
        Puns.debugMessage("Client disconnected --> reverted to client config stats handler");
    }

    public static void onClientLoggingIn(ClientPlayerNetworkEvent.LoggingIn event) {
        Minecraft.getInstance().execute(() -> ClientPacketHandler.applyServerConfig((Boolean)Config.COMMON.enableLocalStats.get(), (Boolean)Config.COMMON.enableOnline.get()));
    }
}

