/*
 * Decompiled with CFR 0.152.
 */
package puns.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import puns.Puns;
import puns.client.ClientEventHandler;
import puns.config.Config;
import puns.data.PunDataLoader;
import puns.data.ReactionType;
import puns.network.IPunStats;

public class PunIntroScreen
extends Screen {
    public static final ResourceLocation BACKGROUND_LOCATION = Puns.resourceLocation("textures/block/dirt.png");
    public static final ResourceLocation BLANK = Puns.identifier("textures/gui/blank.png");
    public ResourceLocation WHEEL_BUTTON_TEX = Puns.identifier("textures/gui/wheel_button.png");
    public ResourceLocation WHEEL_BUTTON_OFF_TEX = Puns.identifier("textures/gui/wheel_button_off.png");
    public ResourceLocation WHEEL_BUTTON_HOVER_TEX = Puns.identifier("textures/gui/wheel_button_hover.png");
    public static final int STATS_REFRESH_INTERVAL_TICKS = 200;
    public int ticksSinceLastStatsRefresh = 0;
    public static final String SCREEN_NAME = "puns.screen.pun";
    public final Screen parent;
    public final Component title;
    public PunDataLoader.PunEntry pun;
    public IPunStats stats;
    public final List<FloatingPointText> floatingTexts = new ArrayList<FloatingPointText>();
    public static final List<ReactionType> ORDERED_REACTIONS_FOR_WHEEL = Arrays.asList(ReactionType.ANGRY, ReactionType.ROLLING, ReactionType.EXPRESSIONLESS, ReactionType.NEUTRAL, ReactionType.COOL, ReactionType.ZANY, ReactionType.SMILING, ReactionType.GRIMACE, ReactionType.CRINGE, ReactionType.CROSSED);
    public boolean animating = false;
    public boolean fadingOut = false;
    public long fadeStart;
    public long reactionTime = -1L;
    public boolean shaking = false;
    public long shakeStart;
    public float shakeDuration = 2.0f;
    public float alpha = 1.0f;
    public WheelOfFortune wheel;
    public WheelOpenButton wheelButton;

    public PunIntroScreen(Screen parent) {
        this(parent, (Component)Component.empty());
    }

    public PunIntroScreen(Screen parent, Component title) {
        super((Component)Component.translatable((String)SCREEN_NAME));
        this.title = title;
        this.parent = parent;
        PunDataLoader.PunEntry pun = PunDataLoader.getRandomPun(RandomSource.create());
        if (pun == null) {
            pun = new PunDataLoader.PunEntry(-1, "The pun was intended", "Though it was never received");
        }
        this.pun = pun;
        ClientEventHandler.HAS_SHOWN_PUN_SCREEN = true;
        this.stats = Puns.SERVER_PUN_STATS_HANDLER;
        Puns.debugMessage("Opening PunIntroScreen for pun: " + String.valueOf(pun) + ", refreshing stats cache");
        this.stats.asyncFetchStats(this.pun);
        this.wheel = new WheelOfFortune(this, 0, 10);
        this.ticksSinceLastStatsRefresh = 0;
        Puns.debugMessage("Using stats handler: " + Puns.SERVER_PUN_STATS_HANDLER.getClass().getSimpleName());
    }

    public Screen getParent() {
        return this.parent;
    }

    public void resize(Minecraft mc, int width, int height) {
        boolean wasActive = this.wheel.isActive();
        float currentAngle = this.wheel.wheelAngle;
        float currentVel = this.wheel.angularVelocity;
        boolean exceeded = this.wheel.hasExceededThreshold;
        super.resize(mc, width, height);
        this.clearWidgets();
        this.init();
        this.setWheelActive(wasActive);
        if (wasActive) {
            this.wheel.wheelAngle = currentAngle;
            this.wheel.angularVelocity = currentVel;
            this.wheel.hasExceededThreshold = exceeded;
        }
    }

    public void setWheelActive(boolean active) {
        this.wheel.setActive(active);
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public boolean canReloadPuns() {
        return true;
    }

    public boolean keyPressed(KeyEvent event) {
        if (!this.wheel.isActive() && event.key() == ClientEventHandler.REFRESH_PUN_SCREEN.getKey().getValue() && this.canReloadPuns()) {
            Minecraft.getInstance().setScreen((Screen)new PunIntroScreen(this.parent));
        }
        if (this.wheel.isActive() && event.key() == 256 && !this.wheel.hasExceededThreshold()) {
            this.setWheelActive(false);
            return true;
        }
        return super.keyPressed(event);
    }

    public void tick() {
        super.tick();
        if (this.pun != null) {
            ++this.ticksSinceLastStatsRefresh;
            if (this.ticksSinceLastStatsRefresh >= 200) {
                this.ticksSinceLastStatsRefresh = 0;
                this.stats.asyncFetchStats(this.pun);
                Puns.debugMessage("Auto-refreshed stats for pun: " + this.pun.id());
            }
        }
    }

    protected void init() {
        int spacing = 30;
        int totalWidth = 5 * spacing;
        int startX = this.width / 2 - totalWidth / 2;
        int rowY1 = this.height / 2 + 20;
        int rowY2 = rowY1 + 30;
        ArrayList<ReactionType> reactions = new ArrayList<ReactionType>(ORDERED_REACTIONS_FOR_WHEEL);
        Collections.shuffle(reactions);
        for (int i = 0; i < reactions.size(); ++i) {
            boolean row = i >= 5;
            int col = i % 5;
            int x = startX + col * spacing;
            int y = !row ? rowY1 : rowY2;
            ReactionType reaction = (ReactionType)((Object)reactions.get(i));
            ResourceLocation tex = Puns.identifier("textures/gui/reaction/" + reaction.name().toLowerCase() + ".png");
            String langKey = "puns.reaction." + reaction.name().toLowerCase();
            this.addRenderableWidget((GuiEventListener)new ReactionButton(this, x, y, tex, langKey, reaction));
        }
        int guiX = (this.width - 270) / 2;
        int guiY = (this.height - 190) / 2 - 10;
        int buttonX = guiX + 270 + 2;
        int buttonY = guiY + 190 - 20;
        float buttonScale = 1.5f;
        this.wheelButton = (WheelOpenButton)this.addRenderableWidget((GuiEventListener)new WheelOpenButton(this, buttonX, buttonY, buttonScale));
    }

    public void startAnimation(ReactionButton pressed) {
        int startY;
        int startX;
        if (this.animating) {
            return;
        }
        this.animating = true;
        this.shaking = true;
        this.shakeStart = System.currentTimeMillis();
        this.reactionTime = System.currentTimeMillis();
        for (Renderable widget : this.renderables) {
            ReactionButton rb;
            if (!(widget instanceof ReactionButton)) continue;
            rb.beginAnimation((rb = (ReactionButton)widget) == pressed, pressed.getX(), pressed.getY(), this.width, this.height);
        }
        if (this.wheelButton != null) {
            this.wheelButton.active = false;
        }
        ReactionType reaction = pressed.getReaction();
        this.stats.addReaction(this.pun, reaction);
        this.stats.asyncFetchStats(this.pun);
        if (this.wheel.isActive()) {
            startX = this.width / 2;
            startY = this.height / 2 + 10;
        } else {
            startX = pressed.getX() + pressed.getWidth() / 2;
            startY = pressed.getY() + pressed.getHeight() / 2;
        }
        this.floatingTexts.add(new FloatingPointText(this, startX, startY, reaction));
    }

    public ReactionButton getButtonForReaction(ReactionType type) {
        for (Renderable widget : this.renderables) {
            ReactionButton rb;
            if (!(widget instanceof ReactionButton) || (rb = (ReactionButton)widget).getReaction() != type) continue;
            return rb;
        }
        return null;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        float safetyMargin;
        float buttonsY;
        float maxBottom;
        float t;
        if (this.alpha <= 0.0f) {
            return;
        }
        if (this.title.getString().toLowerCase(Locale.ROOT).contains("world")) {
            graphics.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
        }
        if (this.fadingOut) {
            t = (float)(System.currentTimeMillis() - this.fadeStart) / 1000.0f;
            float duration = 3.0f;
            float progress = Mth.clamp((float)(t / duration), (float)0.0f, (float)1.0f);
            float eased = progress * progress * progress;
            this.alpha = 1.0f - eased;
        }
        graphics.pose().pushMatrix();
        if (this.shaking) {
            t = (float)(System.currentTimeMillis() - this.shakeStart) / 1000.0f;
            if (t > this.shakeDuration) {
                this.shaking = false;
            } else {
                float progress = t / this.shakeDuration;
                float c1 = 1.70158f;
                float c3 = c1 + 1.0f;
                float eased = c3 * progress * progress * progress - c1 * progress * progress;
                float intensity = 3.0f * (1.0f - eased);
                float offsetX = intensity * (Mth.sin((float)(t * 25.0f)) + Mth.sin((float)(t * 40.0f))) * 0.5f;
                float offsetY = intensity * (Mth.cos((float)(t * 30.0f)) + Mth.cos((float)(t * 45.0f))) * 0.5f;
                graphics.pose().translate(offsetX, offsetY);
            }
        }
        this.renderFadingBackground(graphics, this.alpha);
        MutableComponent questionComp = Component.literal((String)this.pun.question()).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)));
        MutableComponent answerComp = Component.literal((String)this.pun.answer()).withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)));
        float questionScale = 1.5f;
        int questionMaxWidth = (int)((float)this.width / questionScale) - 50;
        List questionLines = this.font.split((FormattedText)questionComp, questionMaxWidth);
        Objects.requireNonNull(this.font);
        int lineHeight = 9;
        float questionBlockHeight = (float)(questionLines.size() * lineHeight) * questionScale + 2.0f;
        float answerScale = 1.25f;
        ArrayList answerLines = this.pun.answer().isEmpty() ? new ArrayList() : this.font.split((FormattedText)answerComp, (int)((float)this.width / answerScale) - 40);
        int answerLinesCount = answerLines.size();
        float answerBlockHeight = (float)(answerLinesCount * lineHeight) * answerScale;
        float margin = 4.5f;
        float fixedAnswerBottom = (float)this.height / 2.0f - 0.75f;
        float virtualAnswerHeight = (float)((answerLinesCount == 0 ? 1 : answerLinesCount) * lineHeight) * answerScale;
        float virtualAnswerTop = fixedAnswerBottom - virtualAnswerHeight;
        float questionBottom = virtualAnswerTop - margin;
        float questionTopEffective = questionBottom - questionBlockHeight;
        int questionStartYPre = (int)(questionTopEffective / questionScale);
        int questionCenterXPre = (int)((float)(this.width / 2) / questionScale);
        int maxQuestionWidth = 0;
        for (FormattedCharSequence line : questionLines) {
            maxQuestionWidth = Math.max(maxQuestionWidth, this.font.width(line));
        }
        graphics.pose().pushMatrix();
        graphics.pose().scale(questionScale, questionScale);
        for (int i = 0; i < questionLines.size(); ++i) {
            FormattedCharSequence line;
            line = (FormattedCharSequence)questionLines.get(i);
            int lineWidth = this.font.width(line);
            graphics.drawString(this.font, line, questionCenterXPre - lineWidth / 2, questionStartYPre + i * lineHeight, Puns.rgbaToInt(1.0f, 1.0f, 1.0f, this.alpha), false);
        }
        graphics.pose().popMatrix();
        float actualBottom = questionTopEffective + questionBlockHeight;
        float answerTopEffective = 0.0f;
        if (!this.pun.answer().isEmpty()) {
            answerTopEffective = fixedAnswerBottom - answerBlockHeight;
            int answerStartYPre = (int)(answerTopEffective / answerScale);
            int answerCenterXPre = (int)((float)(this.width / 2) / answerScale);
            graphics.pose().pushMatrix();
            graphics.pose().scale(answerScale, answerScale);
            for (int i = 0; i < answerLines.size(); ++i) {
                FormattedCharSequence line = (FormattedCharSequence)answerLines.get(i);
                int lineWidth = this.font.width(line);
                graphics.drawString(this.font, line, answerCenterXPre - lineWidth / 2, answerStartYPre + i * lineHeight, Puns.rgbaToInt(0.8f, 0.8f, 0.8f, this.alpha), false);
            }
            graphics.pose().popMatrix();
            actualBottom = answerTopEffective + answerBlockHeight;
        }
        if (actualBottom > (maxBottom = (buttonsY = (float)(this.height / 2 + 20)) - (safetyMargin = 10.0f))) {
            float excess = actualBottom - maxBottom;
            questionStartYPre = (int)((questionTopEffective -= excess) / questionScale);
        }
        this.renderButtons(graphics, mouseX, mouseY, partialTicks);
        for (Renderable r : this.renderables) {
            if (!(r instanceof ReactionButton)) continue;
            ReactionButton rb = (ReactionButton)r;
            rb.setTooltip(this.wheel.isActive() ? null : rb.toolTip);
        }
        graphics.nextStratum();
        if (this.wheel.isActive()) {
            graphics.blurBeforeThisStratum();
        }
        this.renderWheelButton(graphics, mouseX, mouseY, partialTicks);
        this.drawApprovalRating(graphics, this.alpha, questionTopEffective, questionBlockHeight, answerTopEffective, answerBlockHeight, questionCenterXPre, maxQuestionWidth, questionScale);
        if (this.wheel.isActive()) {
            this.wheel.tick(partialTicks);
            this.wheel.render(graphics, mouseX, mouseY, partialTicks);
        }
        this.floatingTexts.removeIf(FloatingPointText::isExpired);
        for (FloatingPointText ft : this.floatingTexts) {
            ft.render(graphics, this.font);
        }
        graphics.pose().popMatrix();
        if (this.animating && !this.fadingOut && this.reactionTime > 0L && System.currentTimeMillis() - this.reactionTime >= 200L) {
            this.fadingOut = true;
            this.fadeStart = System.currentTimeMillis();
        }
        if (this.fadingOut && this.alpha <= 0.0f) {
            this.goToWindow();
        }
    }

    public void goToWindow() {
        Minecraft.getInstance().setScreen((Screen)((Boolean)Config.COMMON.onlyPuns.get() != false ? new PunIntroScreen(this.parent) : this.parent));
    }

    public void drawApprovalRating(GuiGraphics graphics, float alpha, float questionTopEffective, float questionBlockHeight, float answerTopEffective, float answerBlockHeight, int questionCenterXPre, int maxQuestionWidth, float questionScale) {
        int questionTopYScreen;
        int questionLeftXScreen;
        MutableComponent ratingComp;
        if (this.stats == null) {
            return;
        }
        int rating = this.stats.getApprovalRating(this.pun);
        String emoticon = rating >= 69 && rating < 70 ? "... nice" : (rating >= 75 ? ":)" : (rating <= 25 ? ":(" : ""));
        boolean noRatings = this.stats.getPositivePoints(this.pun) == 0 && this.stats.getNegativePoints(this.pun) == 0;
        MutableComponent noRating = Component.translatable((String)"puns.screen.no_rating");
        MutableComponent mutableComponent = ratingComp = noRatings ? noRating : Component.translatable((String)"puns.screen.approval", (Object[])new Object[]{rating + "%", emoticon});
        if (this.wheel.isActive()) {
            int centerX = (int)((double)this.width / 2.0 + (double)this.wheel.xOffset);
            int centerY = (int)((double)this.height / 2.0 + (double)this.wheel.yOffset);
            questionLeftXScreen = centerX - 63 - 14;
            questionTopYScreen = centerY - 84 + 12;
        } else {
            questionLeftXScreen = (int)((float)(questionCenterXPre - maxQuestionWidth / 2) * questionScale);
            questionTopYScreen = (int)questionTopEffective;
        }
        String raw = ratingComp.getString();
        ArrayList<String> lines = new ArrayList<String>();
        if (raw.contains("!")) {
            String[] parts = raw.split("\\!");
            for (int i = 0; i < parts.length; ++i) {
                Object line = parts[i].trim();
                if (((String)line).isEmpty()) continue;
                if (i < parts.length - 1) {
                    line = (String)line + "!";
                }
                lines.add((String)line);
            }
        } else {
            lines.add(raw);
        }
        int n = lines.size();
        Objects.requireNonNull(this.font);
        int ratingBlockHeight = n * 9;
        int anchorX = questionLeftXScreen - 5;
        int maxLineWidth = 0;
        for (String line : lines) {
            maxLineWidth = Math.max(maxLineWidth, this.font.width(line));
        }
        int leftEdge = anchorX - maxLineWidth / 2;
        int rightEdge = anchorX + maxLineWidth / 2;
        if (leftEdge < 0) {
            anchorX += -leftEdge + 2;
        } else if (rightEdge > this.width) {
            anchorX -= rightEdge - this.width + 2;
        }
        graphics.pose().pushMatrix();
        graphics.pose().translate((float)anchorX, (float)questionTopYScreen - 2.0f);
        graphics.pose().rotate((float)Math.toRadians(-20.0));
        float f = 1.8f - Mth.abs((float)(Mth.sin((float)((float)(Util.getMillis() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
        f = f * 100.0f / (float)(this.font.width((FormattedText)noRating) + 32);
        graphics.pose().scale(f, f);
        int color = Puns.rgbaToInt(1.0f, 1.0f, 0.0f, alpha);
        int y = -ratingBlockHeight;
        for (String line : lines) {
            graphics.drawCenteredString(this.font, (Component)Component.literal((String)line), 0, y, color);
            Objects.requireNonNull(this.font);
            y += 9;
        }
        graphics.pose().popMatrix();
    }

    public void renderButtons(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (Renderable renderable : this.renderables) {
            if (renderable instanceof WheelOpenButton) continue;
            renderable.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public void renderWheelButton(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (Renderable renderable : this.renderables) {
            if (!(renderable instanceof WheelOpenButton)) continue;
            renderable.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public void renderFadingBackground(GuiGraphics graphics, float alpha) {
        alpha = Mth.clamp((float)alpha, (float)0.0f, (float)1.0f);
        graphics.pose().pushMatrix();
        graphics.blit(RenderPipelines.GUI_TEXTURED, BACKGROUND_LOCATION, 0, 0, 0.0f, 0.0f, this.width, this.height, 32, 32, Puns.rgbaToInt(0.25f, 0.25f, 0.25f, (Boolean)Config.COMMON.onlyPuns.get() != false ? 1.0f : alpha));
        graphics.pose().popMatrix();
    }

    public boolean mouseClicked(MouseButtonEvent buttonEvent, boolean bool) {
        if (this.wheel.isActive() && this.wheel.mouseClicked(buttonEvent, bool)) {
            return true;
        }
        return super.mouseClicked(buttonEvent, bool);
    }

    public boolean mouseDragged(MouseButtonEvent buttonEvent, double dragX, double dragY) {
        if (this.wheel.isActive() && this.wheel.mouseDragged(buttonEvent, dragX, dragY)) {
            return true;
        }
        return super.mouseDragged(buttonEvent, dragX, dragY);
    }

    public boolean mouseReleased(MouseButtonEvent buttonEvent) {
        if (this.wheel.isActive() && this.wheel.mouseReleased(buttonEvent)) {
            return true;
        }
        return super.mouseReleased(buttonEvent);
    }

    public static class WheelOfFortune {
        public final PunIntroScreen parent;
        public final int xOffset;
        public final int yOffset;
        public boolean active = false;
        public float wheelAngle = 0.0f;
        public float angularVelocity = 0.0f;
        public float friction = 0.99f;
        public float inertiaMultiplier = 1.8f;
        public boolean grabbing = false;
        public double lastMouseAngle = 0.0;
        public long lastDragTime = 0L;
        public float previousAngularVelocity = 0.0f;
        public boolean hasExceededThreshold = false;
        public boolean showTooSlowMessage = false;
        public boolean wasActiveDrag = false;
        public long tooSlowMessageStart = 0L;
        public float speedThreshold = 70.0f;
        public long stopTime = -1L;
        public boolean fading = false;
        public long fadeStart = -1L;
        public float fadeDuration = 1.5f;
        public float wheelAlpha = 1.0f;
        public boolean hasReacted = false;
        public long burstStart = 0L;
        public final RandomSource burstRandom = RandomSource.create();
        public static final ResourceLocation LIGHTS_TEX = Puns.identifier("textures/gui/wheel_lights_sheet.png");
        public static final ResourceLocation LIGHTS_OFF_TEX = Puns.identifier("textures/gui/wheel_lights_off.png");
        public static final ResourceLocation WHEEL_BASE_TEX = Puns.identifier("textures/gui/wheel_of_fortune_base.png");
        public static final ResourceLocation WHEEL_TEX = Puns.identifier("textures/gui/wheel_of_fortune.png");
        public static final ResourceLocation HAND_0_TEX = Puns.identifier("textures/gui/hand_0.png");
        public static final ResourceLocation HAND_CW_TEX = Puns.identifier("textures/gui/hand_1.png");
        public static final ResourceLocation HAND_CCW_TEX = Puns.identifier("textures/gui/hand_2.png");
        public static final int WHEEL_SIZE = 254;
        public static final float SLICE_ANGLE = 36.0f;
        public static final float DOT_OFFSET_1 = 5.4f;
        public static final float DOT_OFFSET_2 = 30.6f;
        public static final float CLOSE_DISTANCE = 1.7f;
        public static final float HAND_ANGLE = 270.0f;
        public static final int SPRITE_SIZE = 127;
        public static final int SPRITE_SHEET_SIZE = 508;
        public static final int SPRITE_COLUMNS = 4;
        public static final int SPRITE_ROWS = 4;
        public static final int TOTAL_FRAMES = 16;
        public static final int FRAME_DURATION_MS = 50;
        public long animationStartTime = -1L;
        public long slowdownDelayMs;
        public long slowdownStartTime = -1L;

        public WheelOfFortune(PunIntroScreen parent) {
            this.parent = parent;
            this.xOffset = 0;
            this.yOffset = 0;
        }

        public WheelOfFortune(PunIntroScreen parent, int xOffset, int yOffset) {
            this.parent = parent;
            this.xOffset = xOffset;
            this.yOffset = yOffset;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            if (active) {
                this.wheelAngle = 0.0f;
                this.angularVelocity = 0.0f;
                this.grabbing = false;
                this.hasExceededThreshold = false;
                this.stopTime = -1L;
                this.fading = false;
                this.fadeStart = -1L;
                this.wheelAlpha = 1.0f;
                this.previousAngularVelocity = 0.0f;
                this.slowdownStartTime = -1L;
                this.slowdownDelayMs = RandomSource.create().nextIntBetweenInclusive(0, 1000);
            } else {
                this.hasExceededThreshold = false;
                this.hasReacted = false;
                this.animationStartTime = -1L;
            }
            this.active = active;
        }

        public boolean hasExceededThreshold() {
            return this.hasExceededThreshold;
        }

        public void tick(float partialTicks) {
            if (this.active) {
                long current = System.currentTimeMillis();
                if (this.grabbing) {
                    this.angularVelocity *= 0.3f;
                } else {
                    if (Math.abs(this.angularVelocity) > this.speedThreshold) {
                        this.hasExceededThreshold = true;
                        if (this.slowdownStartTime == -1L) {
                            this.slowdownStartTime = current;
                        }
                    } else if (!this.grabbing && this.wasActiveDrag && !this.hasExceededThreshold && !this.showTooSlowMessage) {
                        this.showTooSlowMessage = true;
                        this.tooSlowMessageStart = System.currentTimeMillis();
                    }
                    this.wheelAngle += this.angularVelocity * partialTicks;
                    this.angularVelocity *= this.friction;
                    if (Math.abs(this.angularVelocity) < 0.1f) {
                        if (Math.abs(this.previousAngularVelocity) >= 0.1f && this.hasExceededThreshold) {
                            this.stopTime = current;
                            this.triggerWheelReaction();
                        }
                        this.angularVelocity = 0.0f;
                    }
                    this.previousAngularVelocity = this.angularVelocity;
                }
                if (this.stopTime > -1L) {
                    if (!this.fading && current - this.stopTime >= 1000L) {
                        this.fading = true;
                        this.fadeStart = current;
                    }
                    if (this.fading) {
                        float fadeDuration = 1.5f;
                        float t = (float)(current - this.fadeStart) / (fadeDuration * 1000.0f);
                        if ((t = Mth.clamp((float)t, (float)0.0f, (float)1.0f)) >= 1.0f) {
                            this.wheelAlpha = 0.0f;
                            this.setActive(false);
                        } else {
                            float eased = t * t * t;
                            this.wheelAlpha = 1.0f - eased;
                        }
                    }
                }
                if (this.hasExceededThreshold && this.animationStartTime == -1L) {
                    this.animationStartTime = System.currentTimeMillis();
                }
            }
            this.wasActiveDrag = this.grabbing;
        }

        public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            if (this.stopTime > -1L && this.fading) {
                float fadeDuration = 2.0f;
                float t = (float)(System.currentTimeMillis() - this.fadeStart) / (fadeDuration * 1000.0f);
                if ((t = Mth.clamp((float)t, (float)0.0f, (float)1.0f)) >= 1.0f) {
                    this.wheelAlpha = 0.0f;
                    this.setActive(false);
                } else {
                    float eased = t * t * t;
                    this.wheelAlpha = 1.0f - eased;
                }
            }
            int color = Puns.rgbaToInt(1.0f, 1.0f, 1.0f, this.wheelAlpha);
            double centerX = (double)this.parent.width / 2.0 + (double)this.xOffset;
            double centerY = (double)this.parent.height / 2.0 + (double)this.yOffset;
            int halfSize = 127;
            graphics.blit(RenderPipelines.GUI_TEXTURED, WHEEL_BASE_TEX, (int)(centerX - (double)halfSize), (int)(centerY - (double)halfSize), 0.0f, 0.0f, 254, 254, 254, 254, color);
            this.drawLights(graphics, centerX, centerY, halfSize, color);
            graphics.pose().pushMatrix();
            graphics.pose().translate((float)centerX, (float)centerY - 0.5f);
            graphics.pose().rotate((float)Math.toRadians(-this.wheelAngle));
            graphics.blit(RenderPipelines.GUI_TEXTURED, WHEEL_TEX, -halfSize, -halfSize, 0.0f, 0.0f, 254, 254, 254, 254, color);
            float iconRadius = 58.0f;
            int iconTexSize = 36;
            float iconScale = 0.75f;
            for (int i = 0; i < 10; ++i) {
                graphics.pose().pushMatrix();
                float theta = (float)i * 36.0f - 90.0f;
                double rad = Math.toRadians(theta);
                double posX = (double)iconRadius * Math.cos(rad);
                double posY = (double)iconRadius * Math.sin(rad);
                graphics.pose().translate((float)posX, (float)posY - 0.5f);
                graphics.pose().rotate((float)Math.toRadians(theta + 90.0f));
                graphics.pose().scale(iconScale, iconScale);
                ReactionType rt = ORDERED_REACTIONS_FOR_WHEEL.get(i);
                ResourceLocation iconTex = Puns.identifier("textures/gui/reaction/" + rt.name().toLowerCase() + ".png");
                graphics.blit(RenderPipelines.GUI_TEXTURED, iconTex, -iconTexSize / 2, -iconTexSize / 2, 0.0f, 0.0f, iconTexSize, iconTexSize, iconTexSize, iconTexSize, color);
                graphics.pose().popMatrix();
            }
            graphics.pose().popMatrix();
            boolean flickHand = false;
            boolean isCCW = this.angularVelocity < 0.0f;
            for (int i = 0; i < 10; ++i) {
                float start = (float)i * 36.0f;
                float dot1 = (start + 5.4f + this.wheelAngle + 360.0f) % 360.0f;
                float dot2 = (start + 30.6f + this.wheelAngle + 360.0f) % 360.0f;
                if (!(Math.abs(dot1 - 270.0f) < 1.7f || Math.abs(dot1 - 270.0f + 360.0f) < 1.7f || Math.abs(dot1 - 270.0f - 360.0f) < 1.7f || Math.abs(dot2 - 270.0f) < 1.7f || Math.abs(dot2 - 270.0f + 360.0f) < 1.7f) && !(Math.abs(dot2 - 270.0f - 360.0f) < 1.7f)) continue;
                flickHand = true;
                break;
            }
            ResourceLocation handTex = flickHand ? (!isCCW ? HAND_CCW_TEX : HAND_CW_TEX) : HAND_0_TEX;
            graphics.pose().pushMatrix();
            graphics.pose().translate((float)centerX, (float)centerY - 0.5f);
            graphics.blit(RenderPipelines.GUI_TEXTURED, handTex, -halfSize, -halfSize, 0.0f, 0.0f, 254, 254, 254, 254, color);
            graphics.pose().popMatrix();
            this.drawText(graphics);
            this.tick(partialTicks);
        }

        public void drawText(GuiGraphics graphics) {
            if (this.showTooSlowMessage) {
                MutableComponent msg = Component.translatable((String)"puns.screen.spin_too_slow").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)));
                long elapsed = System.currentTimeMillis() - this.tooSlowMessageStart;
                if (elapsed < 2000L) {
                    graphics.drawCenteredString(this.parent.font, (Component)msg, this.parent.width / 2, this.parent.height / 2 + 105, Puns.rgbaToInt(1.0f, 0.65f, 0.0f, 1.0f));
                } else if (elapsed < 3000L) {
                    float fadeProgress = (float)(elapsed - 2000L) / 1000.0f;
                    float alpha = 1.0f - fadeProgress;
                    graphics.drawCenteredString(this.parent.font, (Component)msg, this.parent.width / 2, this.parent.height / 2 + 105, Puns.rgbaToInt(1.0f, 0.65f, 0.0f, alpha));
                } else {
                    this.showTooSlowMessage = false;
                }
            }
        }

        public void drawLights(GuiGraphics graphics, double centerX, double centerY, int halfSize, int color) {
            if (!this.hasReacted) {
                graphics.pose().pushMatrix();
                if (this.active && this.hasExceededThreshold && this.animationStartTime != -1L) {
                    long elapsed = System.currentTimeMillis() - this.animationStartTime;
                    float velocityFactor = Mth.clamp((float)Math.abs(this.angularVelocity * 0.02f), (float)0.001f, (float)50.0f);
                    float effectiveFrameDuration = Math.max(1.0f, 50.0f / velocityFactor);
                    int currentFrame = 16 - (int)((float)elapsed / effectiveFrameDuration % 16.0f);
                    int col = currentFrame % 4;
                    int row = currentFrame / 4;
                    int u = col * 254;
                    int v = row * 254;
                    graphics.blit(RenderPipelines.GUI_TEXTURED, LIGHTS_TEX, (int)(centerX - (double)halfSize), (int)(centerY - (double)halfSize), (float)u, (float)v, 254, 254, 1016, 1016, color);
                } else {
                    graphics.blit(RenderPipelines.GUI_TEXTURED, LIGHTS_OFF_TEX, (int)(centerX - (double)halfSize), (int)(centerY - (double)halfSize), 0.0f, 0.0f, 254, 254, 254, 254, color);
                }
                graphics.pose().popMatrix();
            }
        }

        public void drawDebugLines(GuiGraphics graphics, float halfSize) {
            float radius = halfSize;
            int color = -464426;
            for (int i = 0; i < 10; ++i) {
                float theta = (float)i * 36.0f;
                float ex = (float)((double)radius * Math.cos(Math.toRadians(theta))) - 5.0f;
                float ey = (float)((double)radius * Math.sin(Math.toRadians(theta)));
                this.drawDebugLine(graphics, 0.0f, 0.0f, ex, ey, color);
            }
        }

        public void drawDebugLine(GuiGraphics graphics, float x1, float y1, float x2, float y2, int color) {
            int dx = (int)(x2 - x1);
            int dy = (int)(y2 - y1);
            int steps = Math.max(Math.abs(dx), Math.abs(dy));
            float xInc = (float)dx / (float)steps;
            float yInc = (float)dy / (float)steps;
            float x = x1;
            float y = y1;
            for (int i = 0; i <= steps; ++i) {
                graphics.fill((int)x, (int)y, (int)x + 1, (int)y + 1, color);
                x += xInc;
                y += yInc;
            }
        }

        public void triggerWheelReaction() {
            if (this.hasReacted) {
                return;
            }
            this.hasReacted = true;
            float effectiveHandAngle = (270.0f - this.wheelAngle + 720.0f - 18.0f) % 360.0f;
            float angleFromRight = ((270.0f - effectiveHandAngle) % 360.0f + 360.0f) % 360.0f;
            int slice = (int)Math.floor(angleFromRight / 36.0f);
            if (slice >= 0 && slice < ORDERED_REACTIONS_FOR_WHEEL.size()) {
                ReactionType reaction = ORDERED_REACTIONS_FOR_WHEEL.get(slice);
                ReactionButton button = this.parent.getButtonForReaction(reaction);
                if (button != null) {
                    this.parent.startAnimation(button);
                    this.parent.wheelButton.active = false;
                }
            } else {
                Puns.LOGGER.warn("Wheel landed on invalid slice {}", (Object)slice);
            }
        }

        public boolean isOverWheel(double mouseX, double mouseY) {
            int centerX = this.parent.width / 2 + this.xOffset;
            int centerY = this.parent.height / 2 + this.yOffset;
            int halfSize = 127;
            return mouseX >= (double)(centerX - halfSize) && mouseX <= (double)(centerX + halfSize) && mouseY >= (double)(centerY - halfSize) && mouseY <= (double)(centerY + halfSize);
        }

        public double computeMouseAngle(double mouseX, double mouseY) {
            int centerX = this.parent.width / 2 + this.xOffset;
            int centerY = this.parent.height / 2 + this.yOffset;
            return Math.toDegrees(Math.atan2(mouseY - (double)centerY, mouseX - (double)centerX));
        }

        public boolean mouseClicked(MouseButtonEvent buttonEvent, boolean bool) {
            if (!this.hasExceededThreshold && buttonEvent.button() == 0 && this.isOverWheel(buttonEvent.x(), buttonEvent.y())) {
                this.grabbing = true;
                this.lastMouseAngle = this.computeMouseAngle(buttonEvent.x(), buttonEvent.y());
                this.lastDragTime = System.currentTimeMillis();
                return true;
            }
            return false;
        }

        public boolean mouseDragged(MouseButtonEvent buttonEvent, double dragX, double dragY) {
            if (this.grabbing) {
                double currentMouseAngle = this.computeMouseAngle(buttonEvent.x(), buttonEvent.y());
                double deltaAngle = currentMouseAngle - this.lastMouseAngle;
                if (deltaAngle > 180.0) {
                    deltaAngle -= 360.0;
                }
                if (deltaAngle < -180.0) {
                    deltaAngle += 360.0;
                }
                this.wheelAngle -= (float)deltaAngle;
                long now = System.currentTimeMillis();
                float dt = Math.max((float)(now - this.lastDragTime) / 1000.0f, 0.001f);
                if (dt > 0.0f) {
                    this.angularVelocity = -((float)(deltaAngle / (double)dt)) * this.inertiaMultiplier;
                }
                this.lastDragTime = now;
                this.lastMouseAngle = currentMouseAngle;
                return true;
            }
            return false;
        }

        public boolean mouseReleased(MouseButtonEvent buttonEvent) {
            if (this.grabbing) {
                this.grabbing = false;
                return true;
            }
            return false;
        }
    }

    public static class ReactionButton
    extends ImageButton {
        public static final ResourceLocation SHOCKWAVE_TEX = Puns.identifier("textures/gui/reaction_press.png");
        public final PunIntroScreen parent;
        public final ReactionType reaction;
        public final Tooltip toolTip;
        public static final float FADE_DELAY = 0.5f;
        public boolean animating = false;
        public boolean isPressedButton = false;
        public float alpha = 1.0f;
        public float scale = 1.0f;
        public float targetScale = 1.0f;
        public long hoverStart;
        public boolean hovering = false;
        public float px;
        public float py;
        public float vx;
        public float vy;
        public float spin;
        public float angle;
        public long animStart;
        public long lastUpdateTime;
        public boolean shockwaveActive = false;
        public long shockwaveStart;
        public float shockwaveScale = 0.0f;
        public float shockwaveAlpha = 1.0f;

        public ReactionButton(PunIntroScreen parent, int x, int y, ResourceLocation texture, String langKey, ReactionType reaction) {
            super(x, y, 24, 24, new WidgetSprites(texture, texture), b -> {
                if (!parent.wheel.isActive()) {
                    parent.startAnimation((ReactionButton)b);
                }
            }, (Component)Component.translatable((String)langKey));
            this.toolTip = Tooltip.create((Component)Component.translatable((String)langKey));
            this.setTooltip(this.toolTip);
            this.parent = parent;
            this.reaction = reaction;
            this.px = x;
            this.py = y;
        }

        public ReactionType getReaction() {
            return this.reaction;
        }

        public void beginAnimation(boolean pressed, int pressedX, int pressedY, int screenWidth, int screenHeight) {
            this.animating = true;
            this.isPressedButton = pressed;
            this.lastUpdateTime = this.animStart = System.currentTimeMillis();
            RandomSource r = RandomSource.create();
            if (pressed) {
                this.vy = 0.0f;
                this.vx = 0.0f;
                this.spin = (r.nextFloat() - 0.5f) * 360.0f;
                this.shockwaveActive = true;
                this.shockwaveStart = System.currentTimeMillis();
                this.shockwaveScale = 0.0f;
                this.shockwaveAlpha = 1.0f;
            } else {
                float dy;
                float dx = this.getX() - pressedX;
                float dist = (float)Math.sqrt(dx * dx + (dy = (float)(this.getY() - pressedY)) * dy);
                if (dist == 0.0f) {
                    dist = 1.0f;
                }
                float dirAngle = (float)Math.atan2(dy, dx);
                float nx = (float)Math.cos(dirAngle += (r.nextFloat() - 0.5f) * 0.3f);
                float ny = (float)Math.sin(dirAngle);
                float delay = dist / 600.0f;
                this.animStart += (long)(delay * 1000.0f);
                float speed = (r.nextFloat() * 10000.0f + 15000.0f) / (dist + 30.0f) + r.nextFloat() * 100.0f - 50.0f;
                this.vx = nx * speed;
                this.vy = ny * speed;
                this.spin = (r.nextFloat() - 0.5f) * 720.0f;
            }
            this.setTooltip(null);
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            this.setX((int)this.px);
            this.setY((int)this.py);
            long now = System.currentTimeMillis();
            boolean currentlyHovering = this.isHoveredOrFocused();
            if (currentlyHovering != this.hovering) {
                this.hovering = currentlyHovering;
                this.hoverStart = now;
                this.targetScale = this.hovering ? 1.25f : 1.0f;
            }
            float elapsed = (float)(now - this.hoverStart) / 200.0f;
            elapsed = Mth.clamp((float)elapsed, (float)0.0f, (float)1.0f);
            float easedScale = 1.0f - (float)Math.pow(1.0f - elapsed, 3.0);
            this.scale = Mth.lerp((float)easedScale, (float)this.scale, (float)this.targetScale);
            if (this.animating && now < this.animStart) {
                this.px = this.getX();
                this.py = this.getY();
                this.angle = 0.0f;
                this.alpha = 1.0f;
            } else if (this.animating) {
                float eased;
                float dt = (float)(now - this.lastUpdateTime) / 1000.0f;
                this.lastUpdateTime = now;
                float t = (float)(now - this.animStart) / 1000.0f;
                if (t >= 0.5f) {
                    float fadeT = t - 0.5f;
                    float fadeDuration = 1.0f;
                    float progress = Mth.clamp((float)(fadeT / fadeDuration), (float)0.0f, (float)1.0f);
                    this.alpha = eased = 1.0f - progress * progress;
                } else {
                    this.alpha = 1.0f;
                }
                if (this.isPressedButton) {
                    this.angle += this.spin * dt;
                    this.px = this.getX();
                    this.py = this.getY();
                    float progress = t / 2.0f;
                    float c1 = 1.70158f;
                    float c3 = c1 + 1.0f;
                    eased = c3 * progress * progress * progress - c1 * progress * progress;
                    float shrinkFactor = 1.0f - eased;
                    this.scale = (this.scale + 0.3f * (float)Math.sin((double)(t * 2.0f) * Math.PI * 3.0)) * shrinkFactor;
                } else {
                    this.vx = (float)((double)this.vx * Math.pow(0.9, dt));
                    this.vy += 980.0f * dt;
                    this.px += this.vx * dt;
                    this.py += this.vy * dt;
                    this.angle += this.spin * dt;
                }
            } else {
                this.px = this.getX();
                this.py = this.getY();
                this.angle = 0.0f;
                this.alpha = 1.0f;
            }
            this.alpha = Mth.clamp((float)this.alpha, (float)0.0f, (float)1.0f);
            this.scale = Math.max(this.scale, 0.0f);
            if (this.shockwaveActive) {
                float elapsedSW = (float)(now - this.shockwaveStart) / 1000.0f;
                this.shockwaveScale = 600.0f * elapsedSW / 12.0f;
                this.shockwaveAlpha = 1.0f;
                if (this.shockwaveScale > 20.0f) {
                    float excess = this.shockwaveScale - 20.0f;
                    this.shockwaveAlpha = Math.max(0.0f, 1.0f - excess / 30.0f);
                }
                if (this.shockwaveAlpha <= 0.0f) {
                    this.shockwaveActive = false;
                }
                this.shockwaveAlpha = Mth.clamp((float)this.shockwaveAlpha, (float)0.0f, (float)1.0f);
                graphics.pose().pushMatrix();
                graphics.pose().translate(this.px + (float)this.width / 2.0f, this.py + (float)this.height / 2.0f);
                graphics.pose().scale(this.shockwaveScale, this.shockwaveScale);
                graphics.blit(RenderPipelines.GUI_TEXTURED, SHOCKWAVE_TEX, -this.width / 2, -this.height / 2, 0.0f, 0.0f, this.width, this.height, this.width, this.height, Puns.rgbaToInt(1.0f, 1.0f, 1.0f, this.shockwaveAlpha));
                graphics.pose().popMatrix();
            }
            graphics.pose().pushMatrix();
            graphics.pose().translate(this.px + (float)this.width / 2.0f, this.py + (float)this.height / 2.0f);
            graphics.pose().scale(this.scale, this.scale);
            graphics.pose().rotate((float)Math.toRadians(this.angle));
            graphics.blit(RenderPipelines.GUI_TEXTURED, this.sprites.get(this.isActive(), this.isHoveredOrFocused()), -this.width / 2, -this.height / 2, 0.0f, 0.0f, this.width, this.height, this.width, this.height, Puns.rgbaToInt(1.0f, 1.0f, 1.0f, this.alpha));
            graphics.pose().popMatrix();
        }

        public boolean isFadedOut() {
            return this.alpha <= 0.0f;
        }
    }

    public static class WheelOpenButton
    extends ImageButton {
        public static final int baseSize = 20;
        public final PunIntroScreen parent;
        public final ResourceLocation onTexture;
        public final ResourceLocation offTexture;
        public final ResourceLocation hoverTexture;
        public final float scale;

        public WheelOpenButton(PunIntroScreen parent, int x, int y, float scale) {
            super(x, y, (int)(20.0f * scale), (int)(20.0f * scale), new WidgetSprites(parent.WHEEL_BUTTON_TEX, parent.WHEEL_BUTTON_OFF_TEX, parent.WHEEL_BUTTON_HOVER_TEX, parent.WHEEL_BUTTON_OFF_TEX), b -> {
                if (!parent.wheel.hasExceededThreshold) {
                    boolean newActive = !parent.wheel.isActive();
                    parent.setWheelActive(newActive);
                }
            }, (Component)Component.translatable((String)"puns.screen.wheel_button_open"));
            this.parent = parent;
            this.onTexture = parent.WHEEL_BUTTON_TEX;
            this.offTexture = parent.WHEEL_BUTTON_OFF_TEX;
            this.hoverTexture = parent.WHEEL_BUTTON_HOVER_TEX;
            this.scale = scale;
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            ResourceLocation tex;
            if (this.parent.fadingOut || this.parent.alpha <= 0.0f || this.parent.wheel.hasExceededThreshold || !this.active || this.parent.wheel.hasExceededThreshold) {
                this.setTooltip(null);
            } else {
                this.setTooltip(Tooltip.create((Component)Component.translatable((String)("puns.screen.wheel_button_" + (!this.parent.wheel.isActive() ? "open" : "close")))));
            }
            ResourceLocation resourceLocation = tex = this.active && !this.parent.wheel.hasExceededThreshold ? this.onTexture : this.offTexture;
            if (this.active && this.isHovered() && !this.parent.wheel.hasExceededThreshold) {
                tex = this.hoverTexture;
            }
            graphics.blit(RenderPipelines.GUI_TEXTURED, tex, this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height, Puns.rgbaToInt(1.0f, 1.0f, 1.0f, this.parent.alpha));
            ResourceLocation wheelTex = Puns.identifier("textures/gui/wheel_of_fortune.png");
            int wheelSize = 127;
            int displaySize = (int)(22.0f * this.scale);
            float overlayScale = (float)displaySize / (float)wheelSize;
            float brightness = this.parent.wheel.hasExceededThreshold || !this.active || this.parent.wheel.hasExceededThreshold ? 0.25f : 1.0f;
            graphics.pose().pushMatrix();
            graphics.pose().translate((float)this.getX() + (float)this.width / 2.0f, (float)this.getY() + (float)this.height / 2.0f);
            graphics.pose().scale(overlayScale, overlayScale);
            graphics.blit(RenderPipelines.GUI_TEXTURED, wheelTex, -wheelSize / 2, -wheelSize / 2, 0.0f, 0.0f, wheelSize, wheelSize, wheelSize, wheelSize, Puns.rgbaToInt(brightness, brightness, brightness, this.parent.alpha));
            graphics.pose().popMatrix();
        }
    }

    public class FloatingPointText {
        public final Component pointText;
        public final Component bubbleText;
        public final ResourceLocation texture;
        public final int startX;
        public final int startY;
        public final long startTime;
        public final int points;
        public final float rotation;
        public float alpha;
        public boolean mayExpire = false;

        public FloatingPointText(PunIntroScreen this$0, int x, int y, ReactionType reaction) {
            this.points = reaction.getPoints();
            this.pointText = Component.literal((String)(this.points > 0 ? "+" + this.points : String.valueOf(this.points))).withStyle(this.points > 0 ? Style.EMPTY.withColor(0x88FF33).withBold(Boolean.valueOf(true)) : (this.points < 0 ? Style.EMPTY.withColor(0xFF4444).withBold(Boolean.valueOf(true)) : Style.EMPTY.withColor(0xAAAAAA)));
            this.bubbleText = reaction.getBubble();
            this.texture = this.points > 0 ? Puns.identifier("textures/gui/bubble/positive.png") : (this.points < 0 ? Puns.identifier("textures/gui/bubble/negative.png") : Puns.identifier("textures/gui/bubble/neutral.png"));
            this.startX = x;
            this.startY = y;
            this.startTime = System.currentTimeMillis();
            this.rotation = (RandomSource.create().nextFloat() - 0.5f) * 60.0f;
        }

        public boolean isExpired() {
            return this.mayExpire && this.alpha <= 0.0f;
        }

        public void render(GuiGraphics graphics, Font font) {
            float t = (float)(System.currentTimeMillis() - this.startTime) / 1000.0f;
            float fadeInDuration = 0.05f;
            float holdDuration = 0.7f;
            float fadeOutDuration = 0.5f;
            float totalDuration = fadeInDuration + holdDuration + fadeOutDuration;
            if (t < fadeInDuration) {
                this.alpha = t / fadeInDuration;
            } else if (t < fadeInDuration + holdDuration) {
                this.alpha = 1.0f;
            } else if (t < totalDuration) {
                float outT = (t - fadeInDuration - holdDuration) / fadeOutDuration;
                float eased = outT * outT * outT;
                this.alpha = 1.0f - eased;
            } else {
                this.alpha = 0.0f;
                this.mayExpire = true;
            }
            this.alpha = Mth.clamp((float)this.alpha, (float)0.0f, (float)1.0f);
            float duration = 1.0f;
            float progress = Mth.clamp((float)(t / duration), (float)0.0f, (float)1.0f);
            float c1 = 1.70158f;
            float c3 = c1 + 1.0f;
            float eased = 1.0f + c3 * (float)Math.pow(progress - 1.0f, 3.0) + c1 * (float)Math.pow(progress - 1.0f, 2.0);
            float scale = 0.5f + eased * 1.0f;
            float rise = t * 25.0f;
            int y = (int)((float)this.startY - rise);
            if (!this.isExpired()) {
                graphics.pose().pushMatrix();
                graphics.pose().translate((float)this.startX, (float)y);
                graphics.pose().rotate((float)Math.toRadians(this.rotation));
                graphics.pose().scale(scale, scale);
                int color = Puns.rgbaToInt(1.0f, 1.0f, 1.0f, this.alpha);
                int colorText = Puns.rgbaToInt(1.0f, 1.0f, 0.0f, this.alpha);
                graphics.blit(RenderPipelines.GUI_TEXTURED, this.texture, -28, -28, 0.0f, 0.0f, 56, 56, 56, 56, color);
                Objects.requireNonNull(font);
                graphics.drawCenteredString(font, this.bubbleText, 0, -9, colorText);
                graphics.drawCenteredString(font, this.pointText, 0, 0, color);
                graphics.pose().popMatrix();
            }
        }
    }
}

