/*
 * Decompiled with CFR 0.152.
 */
package puns.common;

import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import puns.Puns;
import puns.config.Config;
import puns.data.PunDataLoader;
import puns.network.HybridPunStatsHandler;
import puns.network.LocalPunStats;
import puns.network.PunPackets;
import puns.network.PunStats;

public class ServerEventHandler {
    public static void init(IEventBus bus) {
        bus.addListener(ServerEventHandler::onServerStarting);
        bus.addListener(ServerEventHandler::onPlayerLoggedIn);
    }

    public static void onServerStarting(ServerStartingEvent event) {
        if (!((Boolean)Config.COMMON.enableOnline.get()).booleanValue()) {
            Puns.SERVER_PUN_STATS_HANDLER = new LocalPunStats();
            Puns.debugMessage("Online stats disabled in config --> using local-only stats");
        } else if (((Boolean)Config.COMMON.enableLocalStats.get()).booleanValue()) {
            Puns.SERVER_PUN_STATS_HANDLER = new HybridPunStatsHandler();
            Puns.debugMessage("Hybrid stats mode enabled: remote for official puns, local for custom");
        } else {
            Puns.SERVER_PUN_STATS_HANDLER = new PunStats();
            Puns.debugMessage("Pure remote stats mode: all reactions sent to central server");
        }
        PunDataLoader.loadPuns();
        Puns.debugMessage("Server active puns count: " + PunDataLoader.ACTIVE_PUNS.size());
    }

    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        player.connection.send((Packet)new ClientboundCustomPayloadPacket((CustomPacketPayload)new PunPackets.SyncPunsPayload(PunDataLoader.ACTIVE_PUNS)));
        player.connection.send((Packet)new ClientboundCustomPayloadPacket((CustomPacketPayload)new PunPackets.SyncConfigPayload((Boolean)Config.COMMON.enableLocalStats.get(), (Boolean)Config.COMMON.enableOnline.get())));
    }
}

