/*
 * Decompiled with CFR 0.152.
 */
package puns.network;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import puns.Puns;
import puns.data.PunDataLoader;

public class PunPackets {
    public static final StreamCodec<FriendlyByteBuf, PunDataLoader.PunEntry> PUN_ENTRY_CODEC = StreamCodec.of((buf, entry) -> {
        buf.writeInt(entry.id());
        buf.writeUtf(entry.question());
        buf.writeUtf(entry.answer());
    }, buf -> new PunDataLoader.PunEntry(buf.readInt(), buf.readUtf(), buf.readUtf()));

    public record OpenVoteScreenPayload(PunDataLoader.PunEntry pun) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<OpenVoteScreenPayload> TYPE = new CustomPacketPayload.Type(Puns.identifier("open_vote_screen"));
        public static final StreamCodec<FriendlyByteBuf, OpenVoteScreenPayload> CODEC = StreamCodec.of((buf, payload) -> PUN_ENTRY_CODEC.encode(buf, (Object)payload.pun()), buf -> new OpenVoteScreenPayload((PunDataLoader.PunEntry)PUN_ENTRY_CODEC.decode(buf)));

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record ListPunsPayload(List<PunDataLoader.PunEntry> puns) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<ListPunsPayload> TYPE = new CustomPacketPayload.Type(Puns.identifier("list_puns"));
        public static final StreamCodec<FriendlyByteBuf, ListPunsPayload> CODEC = StreamCodec.of((buf, payload) -> {
            buf.writeInt(payload.puns().size());
            for (PunDataLoader.PunEntry entry : payload.puns()) {
                PUN_ENTRY_CODEC.encode(buf, (Object)entry);
            }
        }, buf -> {
            int size = buf.readInt();
            ArrayList<PunDataLoader.PunEntry> list = new ArrayList<PunDataLoader.PunEntry>(size);
            for (int i = 0; i < size; ++i) {
                list.add((PunDataLoader.PunEntry)PUN_ENTRY_CODEC.decode(buf));
            }
            return new ListPunsPayload(list);
        });

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record SyncPunsPayload(List<PunDataLoader.PunEntry> puns) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SyncPunsPayload> TYPE = new CustomPacketPayload.Type(Puns.identifier("sync_puns"));
        public static final StreamCodec<FriendlyByteBuf, SyncPunsPayload> CODEC = StreamCodec.of((buf, payload) -> {
            buf.writeInt(payload.puns().size());
            for (PunDataLoader.PunEntry entry : payload.puns()) {
                PUN_ENTRY_CODEC.encode(buf, (Object)entry);
            }
        }, buf -> {
            int size = buf.readInt();
            ArrayList<PunDataLoader.PunEntry> list = new ArrayList<PunDataLoader.PunEntry>(size);
            for (int i = 0; i < size; ++i) {
                list.add((PunDataLoader.PunEntry)PUN_ENTRY_CODEC.decode(buf));
            }
            return new SyncPunsPayload(list);
        });

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record FetchStatsPayload(PunDataLoader.PunEntry pun) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<FetchStatsPayload> TYPE = new CustomPacketPayload.Type(Puns.identifier("fetch_stats"));
        public static final StreamCodec<FriendlyByteBuf, FetchStatsPayload> CODEC = StreamCodec.of((buf, payload) -> PUN_ENTRY_CODEC.encode(buf, (Object)payload.pun()), buf -> new FetchStatsPayload((PunDataLoader.PunEntry)PUN_ENTRY_CODEC.decode(buf)));

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record SendReactionPayload(PunDataLoader.PunEntry pun, String reaction) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SendReactionPayload> TYPE = new CustomPacketPayload.Type(Puns.identifier("send_reaction"));
        public static final StreamCodec<FriendlyByteBuf, SendReactionPayload> CODEC = StreamCodec.of((buf, payload) -> {
            PUN_ENTRY_CODEC.encode(buf, (Object)payload.pun());
            buf.writeUtf(payload.reaction());
        }, buf -> new SendReactionPayload((PunDataLoader.PunEntry)PUN_ENTRY_CODEC.decode(buf), buf.readUtf()));

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record StatsResponsePayload(PunDataLoader.PunEntry pun, int positivePoints, int negativePoints, int approvalRating, int count) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<StatsResponsePayload> TYPE = new CustomPacketPayload.Type(Puns.identifier("stats_response"));
        public static final StreamCodec<FriendlyByteBuf, StatsResponsePayload> CODEC = StreamCodec.of((buf, payload) -> {
            PUN_ENTRY_CODEC.encode(buf, (Object)payload.pun());
            buf.writeInt(payload.positivePoints());
            buf.writeInt(payload.negativePoints());
            buf.writeInt(payload.approvalRating());
            buf.writeInt(payload.count());
        }, buf -> new StatsResponsePayload((PunDataLoader.PunEntry)PUN_ENTRY_CODEC.decode(buf), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt()));

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record SyncConfigPayload(boolean enableLocalStats, boolean enableOnline) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SyncConfigPayload> TYPE = new CustomPacketPayload.Type(Puns.identifier("sync_config"));
        public static final StreamCodec<FriendlyByteBuf, SyncConfigPayload> CODEC = StreamCodec.of((buf, payload) -> {
            buf.writeBoolean(payload.enableLocalStats());
            buf.writeBoolean(payload.enableOnline());
        }, buf -> new SyncConfigPayload(buf.readBoolean(), buf.readBoolean()));

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

