/*
 * Decompiled with CFR 0.152.
 */
package puns;

import com.mojang.logging.LogUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.slf4j.Logger;
import puns.client.ClientEventHandler;
import puns.common.PunCommand;
import puns.common.ServerEventHandler;
import puns.config.Config;
import puns.data.PunDataLoader;
import puns.network.IPunStats;
import puns.network.PacketHandler;

@Mod(value="puns")
public class Puns {
    public static final String MOD_ID = "puns";
    public static final String MOD_NAME = "Puns";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static IPunStats SERVER_PUN_STATS_HANDLER;

    public Puns() {
        Config.init();
        PunDataLoader.loadPuns();
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(PunCommand::onRegisterCommands);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientEventHandler.init(bus, eventBus);
        }
        PacketHandler.init(bus);
        ServerEventHandler.init(eventBus);
        LOGGER.info("Loaded!");
    }

    public static ResourceLocation identifier(String name) {
        return Puns.resourceLocation(MOD_ID, name);
    }

    public static ResourceLocation resourceLocation(String name) {
        return new ResourceLocation(name);
    }

    public static ResourceLocation resourceLocation(String domain, String path) {
        return new ResourceLocation(domain, path);
    }

    public static int rgbaToInt(float r, float g, float b, float a) {
        int ri = (int)(r * 255.0f);
        int gi = (int)(g * 255.0f);
        int bi = (int)(b * 255.0f);
        int ai = (int)(a * 255.0f);
        return ai << 24 | ri << 16 | gi << 8 | bi;
    }

    public static void debugMessage(String string) {
        if (((Boolean)Config.COMMON.enableDebug.get()).booleanValue()) {
            LOGGER.debug(string);
        }
    }

    public static void warnMessage(String string) {
        if (((Boolean)Config.COMMON.enableDebug.get()).booleanValue()) {
            LOGGER.warn(string);
        }
    }

    public static void warnMessage(String string, Exception e) {
        if (((Boolean)Config.COMMON.enableDebug.get()).booleanValue()) {
            LOGGER.warn(string, (Throwable)e);
        }
    }

    public static void errorMessage(String string, Exception e) {
        if (((Boolean)Config.COMMON.enableDebug.get()).booleanValue()) {
            LOGGER.error(string, (Throwable)e);
        }
    }
}

