/*
 * Decompiled with CFR 0.152.
 */
package puns.client;

import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.progress.StoringChunkProgressListener;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import puns.Puns;
import puns.client.ClientEventHandler;
import puns.client.RenderHelpers;
import puns.config.Config;
import puns.data.PunDataLoader;
import puns.data.ReactionType;
import puns.mixin.LevelLoadingScreenAccessor;
import puns.network.IPunStats;

public class PunIntroScreen
extends Screen {
    public static final ResourceLocation BLANK = Puns.identifier("textures/gui/blank.png");
    public ResourceLocation WHEEL_BUTTON_TEX = Puns.identifier("textures/gui/wheel_button.png");
    public ResourceLocation WHEEL_BUTTON_OFF_TEX = Puns.identifier("textures/gui/wheel_button_off.png");
    public ResourceLocation WHEEL_BUTTON_HOVER_TEX = Puns.identifier("textures/gui/wheel_button_hover.png");
    public static final int STATS_REFRESH_INTERVAL_TICKS = 200;
    public int ticksSinceLastStatsRefresh = 0;
    public static final String SCREEN_NAME = "puns.screen.pun";
    public final Screen parent;
    public final Component title;
    public PunDataLoader.PunEntry pun;
    public IPunStats stats;
    public final List<FloatingPointText> floatingTexts = new ArrayList<FloatingPointText>();
    public static final List<ReactionType> ORDERED_REACTIONS_FOR_WHEEL = Arrays.asList(ReactionType.ANGRY, ReactionType.ROLLING, ReactionType.EXPRESSIONLESS, ReactionType.NEUTRAL, ReactionType.COOL, ReactionType.ZANY, ReactionType.SMILING, ReactionType.GRIMACE, ReactionType.CRINGE, ReactionType.CROSSED);
    public boolean animating = false;
    public boolean fadingOut = false;
    public long fadeStart;
    public long reactionTime = -1L;
    public boolean shaking = false;
    public long shakeStart;
    public float shakeDuration = 2.0f;
    public float alpha = 1.0f;
    public WheelOfFortune wheel;
    public WheelOpenButton wheelButton;

    public PunIntroScreen(Screen parent) {
        this(parent, (Component)Component.m_237119_());
    }

    public PunIntroScreen(Screen parent, Component title) {
        super((Component)Component.m_237115_((String)SCREEN_NAME));
        this.title = title;
        this.parent = parent;
        PunDataLoader.PunEntry pun = PunDataLoader.getRandomPun(RandomSource.m_216327_());
        if (pun == null) {
            pun = new PunDataLoader.PunEntry(-1, "The pun was intended", "Though it was never received");
        }
        this.pun = pun;
        ClientEventHandler.HAS_SHOWN_PUN_SCREEN = true;
        this.stats = Puns.SERVER_PUN_STATS_HANDLER;
        Puns.debugMessage("Opening PunIntroScreen for pun: " + String.valueOf(pun) + ", refreshing stats cache");
        this.stats.asyncFetchStats(this.pun);
        this.wheel = new WheelOfFortune(this, 0, 10);
        this.ticksSinceLastStatsRefresh = 0;
        Puns.debugMessage("Using stats handler: " + Puns.SERVER_PUN_STATS_HANDLER.getClass().getSimpleName());
    }

    public Screen getParent() {
        return this.parent;
    }

    public void m_6574_(Minecraft mc, int width, int height) {
        boolean wasActive = this.wheel.isActive();
        float currentAngle = this.wheel.wheelAngle;
        float currentVel = this.wheel.angularVelocity;
        boolean exceeded = this.wheel.hasExceededThreshold;
        super.m_6574_(mc, width, height);
        this.m_169413_();
        this.m_7856_();
        this.setWheelActive(wasActive);
        if (wasActive) {
            this.wheel.wheelAngle = currentAngle;
            this.wheel.angularVelocity = currentVel;
            this.wheel.hasExceededThreshold = exceeded;
        }
    }

    public void setWheelActive(boolean active) {
        this.wheel.setActive(active);
    }

    public boolean m_6913_() {
        return false;
    }

    public boolean canReloadPuns() {
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!this.wheel.isActive() && keyCode == ClientEventHandler.REFRESH_PUN_SCREEN.getKey().m_84873_() && this.canReloadPuns()) {
            Minecraft.m_91087_().m_91152_((Screen)new PunIntroScreen(this.parent));
        }
        if (this.wheel.isActive() && keyCode == 256 && !this.wheel.hasExceededThreshold()) {
            this.setWheelActive(false);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.pun != null) {
            ++this.ticksSinceLastStatsRefresh;
            if (this.ticksSinceLastStatsRefresh >= 200) {
                this.ticksSinceLastStatsRefresh = 0;
                this.stats.asyncFetchStats(this.pun);
                Puns.debugMessage("Auto-refreshed stats for pun: " + this.pun.id());
            }
        }
    }

    protected void m_7856_() {
        int spacing = 30;
        int totalWidth = 5 * spacing;
        int startX = this.f_96543_ / 2 - totalWidth / 2;
        int rowY1 = this.f_96544_ / 2 + 20;
        int rowY2 = rowY1 + 30;
        ArrayList<ReactionType> reactions = new ArrayList<ReactionType>(ORDERED_REACTIONS_FOR_WHEEL);
        Collections.shuffle(reactions);
        for (int i = 0; i < reactions.size(); ++i) {
            boolean row = i >= 5;
            int col = i % 5;
            int x = startX + col * spacing;
            int y = !row ? rowY1 : rowY2;
            ReactionType reaction = (ReactionType)((Object)reactions.get(i));
            ResourceLocation tex = Puns.identifier("textures/gui/reaction/" + reaction.name().toLowerCase() + ".png");
            String langKey = "puns.reaction." + reaction.name().toLowerCase();
            this.m_142416_((GuiEventListener)new ReactionButton(this, x, y, tex, langKey, reaction));
        }
        int guiX = (this.f_96543_ - 270) / 2;
        int guiY = (this.f_96544_ - 190) / 2 - 10;
        int buttonX = guiX + 270 + 2;
        int buttonY = guiY + 190 - 20;
        float buttonScale = 1.5f;
        this.wheelButton = (WheelOpenButton)this.m_142416_((GuiEventListener)new WheelOpenButton(this, buttonX, buttonY, buttonScale));
    }

    public void startAnimation(ReactionButton pressed) {
        int startY;
        int startX;
        if (this.animating) {
            return;
        }
        this.animating = true;
        this.shaking = true;
        this.shakeStart = System.currentTimeMillis();
        this.reactionTime = System.currentTimeMillis();
        for (Renderable widget : this.f_169369_) {
            ReactionButton rb;
            if (!(widget instanceof ReactionButton)) continue;
            rb.beginAnimation((rb = (ReactionButton)widget) == pressed, pressed.m_252754_(), pressed.m_252907_(), this.f_96543_, this.f_96544_);
        }
        if (this.wheelButton != null) {
            this.wheelButton.f_93623_ = false;
        }
        ReactionType reaction = pressed.getReaction();
        this.stats.addReaction(this.pun, reaction);
        this.stats.asyncFetchStats(this.pun);
        if (this.wheel.isActive()) {
            startX = this.f_96543_ / 2;
            startY = this.f_96544_ / 2 + 10;
        } else {
            startX = pressed.m_252754_() + pressed.m_5711_() / 2;
            startY = pressed.m_252907_() + pressed.m_93694_() / 2;
        }
        this.floatingTexts.add(new FloatingPointText(startX, startY, reaction));
    }

    public ReactionButton getButtonForReaction(ReactionType type) {
        for (Renderable widget : this.f_169369_) {
            ReactionButton rb;
            if (!(widget instanceof ReactionButton) || (rb = (ReactionButton)widget).getReaction() != type) continue;
            return rb;
        }
        return null;
    }

    public void m_280273_(GuiGraphics guiGraphics) {
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Screen lineWidth3;
        float safetyMargin;
        float buttonsY;
        float maxBottom;
        float t;
        if (this.alpha <= 0.0f) {
            return;
        }
        if (this.title.getString().toLowerCase(Locale.ROOT).contains("world")) {
            graphics.m_280653_(this.f_96547_, this.title, this.f_96543_ / 2, 20, 0xFFFFFF);
        }
        if (this.fadingOut) {
            t = (float)(System.currentTimeMillis() - this.fadeStart) / 1000.0f;
            float duration = 3.0f;
            float progress = Mth.m_14036_((float)(t / duration), (float)0.0f, (float)1.0f);
            float eased = progress * progress * progress;
            this.alpha = 1.0f - eased;
        }
        graphics.m_280168_().m_85836_();
        if (this.shaking) {
            t = (float)(System.currentTimeMillis() - this.shakeStart) / 1000.0f;
            if (t > this.shakeDuration) {
                this.shaking = false;
            } else {
                float progress = t / this.shakeDuration;
                float c1 = 1.70158f;
                float c3 = c1 + 1.0f;
                float eased = c3 * progress * progress * progress - c1 * progress * progress;
                float intensity = 3.0f * (1.0f - eased);
                float offsetX = intensity * (Mth.m_14031_((float)(t * 25.0f)) + Mth.m_14031_((float)(t * 40.0f))) * 0.5f;
                float offsetY = intensity * (Mth.m_14089_((float)(t * 30.0f)) + Mth.m_14089_((float)(t * 45.0f))) * 0.5f;
                graphics.m_280168_().m_252880_(offsetX, offsetY, 0.0f);
            }
        }
        this.renderFadingBackground(graphics, this.alpha);
        MutableComponent questionComp = Component.m_237113_((String)this.pun.question()).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        MutableComponent answerComp = Component.m_237113_((String)this.pun.answer()).m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)));
        float questionScale = 1.5f;
        int questionMaxWidth = (int)((float)this.f_96543_ / questionScale) - 50;
        List questionLines = this.f_96547_.m_92923_((FormattedText)questionComp, questionMaxWidth);
        Objects.requireNonNull(this.f_96547_);
        int lineHeight = 9;
        float questionBlockHeight = (float)(questionLines.size() * lineHeight) * questionScale + 2.0f;
        float answerScale = 1.25f;
        ArrayList answerLines = this.pun.answer().isEmpty() ? new ArrayList() : this.f_96547_.m_92923_((FormattedText)answerComp, (int)((float)this.f_96543_ / answerScale) - 40);
        int answerLinesCount = answerLines.size();
        float answerBlockHeight = (float)(answerLinesCount * lineHeight) * answerScale;
        float margin = 4.5f;
        float fixedAnswerBottom = (float)this.f_96544_ / 2.0f - 0.75f;
        float virtualAnswerHeight = (float)((answerLinesCount == 0 ? 1 : answerLinesCount) * lineHeight) * answerScale;
        float virtualAnswerTop = fixedAnswerBottom - virtualAnswerHeight;
        float questionBottom = virtualAnswerTop - margin;
        float questionTopEffective = questionBottom - questionBlockHeight;
        int questionStartYPre = (int)(questionTopEffective / questionScale);
        int questionCenterXPre = (int)((float)(this.f_96543_ / 2) / questionScale);
        int maxQuestionWidth = 0;
        for (FormattedCharSequence line : questionLines) {
            maxQuestionWidth = Math.max(maxQuestionWidth, this.f_96547_.m_92724_(line));
        }
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(questionScale, questionScale, 1.0f);
        for (int i = 0; i < questionLines.size(); ++i) {
            FormattedCharSequence line;
            line = (FormattedCharSequence)questionLines.get(i);
            int lineWidth2 = this.f_96547_.m_92724_(line);
            graphics.m_280649_(this.f_96547_, line, questionCenterXPre - lineWidth2 / 2, questionStartYPre + i * lineHeight, Puns.rgbaToInt(1.0f, 1.0f, 1.0f, this.alpha), false);
        }
        graphics.m_280168_().m_85849_();
        float actualBottom = questionTopEffective + questionBlockHeight;
        float answerTopEffective = 0.0f;
        if (!this.pun.answer().isEmpty()) {
            answerTopEffective = fixedAnswerBottom - answerBlockHeight;
            int answerStartYPre = (int)(answerTopEffective / answerScale);
            int answerCenterXPre = (int)((float)(this.f_96543_ / 2) / answerScale);
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(answerScale, answerScale, 1.0f);
            for (int i = 0; i < answerLines.size(); ++i) {
                FormattedCharSequence line = (FormattedCharSequence)answerLines.get(i);
                int lineWidth3 = this.f_96547_.m_92724_(line);
                graphics.m_280649_(this.f_96547_, line, answerCenterXPre - lineWidth3 / 2, answerStartYPre + i * lineHeight, Puns.rgbaToInt(0.8f, 0.8f, 0.8f, this.alpha), false);
            }
            graphics.m_280168_().m_85849_();
            actualBottom = answerTopEffective + answerBlockHeight;
        }
        if (actualBottom > (maxBottom = (buttonsY = (float)(this.f_96544_ / 2 + 20)) - (safetyMargin = 10.0f))) {
            float excess = actualBottom - maxBottom;
            questionStartYPre = (int)((questionTopEffective -= excess) / questionScale);
        }
        if ((lineWidth3 = this.parent) instanceof LevelLoadingScreen) {
            LevelLoadingScreen lls = (LevelLoadingScreen)lineWidth3;
            this.renderChunks(lls, graphics, mouseX, mouseY, partialTicks);
        }
        this.renderButtons(graphics, mouseX, mouseY, partialTicks);
        for (Renderable r : this.f_169369_) {
            if (!(r instanceof ReactionButton)) continue;
            ReactionButton rb = (ReactionButton)r;
            rb.m_257544_(this.wheel.isActive() ? null : rb.toolTip);
        }
        this.renderWheelButton(graphics, mouseX, mouseY, partialTicks);
        this.drawApprovalRating(graphics, this.alpha, questionTopEffective, questionBlockHeight, answerTopEffective, answerBlockHeight, questionCenterXPre, maxQuestionWidth, questionScale);
        if (this.wheel.isActive()) {
            this.wheel.tick(partialTicks);
            this.wheel.render(graphics, mouseX, mouseY, partialTicks);
        }
        this.floatingTexts.removeIf(FloatingPointText::isExpired);
        for (FloatingPointText ft : this.floatingTexts) {
            ft.render(graphics, this.f_96547_);
        }
        graphics.m_280168_().m_85849_();
        if (this.animating && !this.fadingOut && this.reactionTime > 0L && System.currentTimeMillis() - this.reactionTime >= 200L) {
            this.fadingOut = true;
            this.fadeStart = System.currentTimeMillis();
        }
        if (this.fadingOut && this.alpha <= 0.0f) {
            this.goToWindow();
        }
    }

    public void goToWindow() {
        Minecraft.m_91087_().m_91152_((Screen)((Boolean)Config.COMMON.onlyPuns.get() != false ? new PunIntroScreen(this.parent) : this.parent));
    }

    public void renderChunks(LevelLoadingScreen lls, GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        LevelLoadingScreenAccessor accessor = (LevelLoadingScreenAccessor)lls;
        int size = 20;
        int margin = 20;
        int x = margin + size;
        int y = this.f_96544_ - margin - size;
        LevelLoadingScreen.m_96149_((GuiGraphics)graphics, (StoringChunkProgressListener)accessor.getProgressListener(), (int)x, (int)y, (int)2, (int)0);
        graphics.m_280056_(this.f_96547_, Mth.m_14045_((int)accessor.getProgressListener().m_9674_(), (int)0, (int)100) + "%", x, y - size / 2, 0xFFFFFF, false);
    }

    public void drawApprovalRating(GuiGraphics graphics, float alpha, float questionTopEffective, float questionBlockHeight, float answerTopEffective, float answerBlockHeight, int questionCenterXPre, int maxQuestionWidth, float questionScale) {
        int questionTopYScreen;
        int questionLeftXScreen;
        MutableComponent ratingComp;
        if (this.stats == null) {
            return;
        }
        int rating = this.stats.getApprovalRating(this.pun);
        String emoticon = rating >= 69 && rating < 70 ? "... nice" : (rating >= 75 ? ":)" : (rating <= 25 ? ":(" : ""));
        boolean noRatings = this.stats.getPositivePoints(this.pun) == 0 && this.stats.getNegativePoints(this.pun) == 0;
        MutableComponent noRating = Component.m_237115_((String)"puns.screen.no_rating");
        MutableComponent mutableComponent = ratingComp = noRatings ? noRating : Component.m_237110_((String)"puns.screen.approval", (Object[])new Object[]{rating + "%", emoticon});
        if (this.wheel.isActive()) {
            int centerX = (int)((double)this.f_96543_ / 2.0 + (double)this.wheel.xOffset);
            int centerY = (int)((double)this.f_96544_ / 2.0 + (double)this.wheel.yOffset);
            questionLeftXScreen = centerX - 63 - 14;
            questionTopYScreen = centerY - 84 + 12;
        } else {
            questionLeftXScreen = (int)((float)(questionCenterXPre - maxQuestionWidth / 2) * questionScale);
            questionTopYScreen = (int)questionTopEffective;
        }
        String raw = ratingComp.getString();
        ArrayList<String> lines = new ArrayList<String>();
        if (raw.contains("!")) {
            String[] parts = raw.split("\\!");
            for (int i = 0; i < parts.length; ++i) {
                Object line = parts[i].trim();
                if (((String)line).isEmpty()) continue;
                if (i < parts.length - 1) {
                    line = (String)line + "!";
                }
                lines.add((String)line);
            }
        } else {
            lines.add(raw);
        }
        int n = lines.size();
        Objects.requireNonNull(this.f_96547_);
        int ratingBlockHeight = n * 9;
        int anchorX = questionLeftXScreen - 5;
        int maxLineWidth = 0;
        for (String line : lines) {
            maxLineWidth = Math.max(maxLineWidth, this.f_96547_.m_92895_(line));
        }
        int leftEdge = anchorX - maxLineWidth / 2;
        int rightEdge = anchorX + maxLineWidth / 2;
        if (leftEdge < 0) {
            anchorX += -leftEdge + 2;
        } else if (rightEdge > this.f_96543_) {
            anchorX -= rightEdge - this.f_96543_ + 2;
        }
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)anchorX, (float)questionTopYScreen - 2.0f, 0.0f);
        graphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(-20.0f));
        float f = 1.8f - Mth.m_14154_((float)(Mth.m_14031_((float)((float)(Util.m_137550_() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
        f = f * 100.0f / (float)(this.f_96547_.m_92852_((FormattedText)noRating) + 32);
        graphics.m_280168_().m_85841_(f, f, f);
        int color = Puns.rgbaToInt(1.0f, 1.0f, 0.0f, alpha);
        int y = -ratingBlockHeight;
        for (String line : lines) {
            graphics.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)line), 0, y, color);
            Objects.requireNonNull(this.f_96547_);
            y += 9;
        }
        graphics.m_280168_().m_85849_();
    }

    public void renderButtons(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (Renderable renderable : this.f_169369_) {
            if (renderable instanceof WheelOpenButton) continue;
            renderable.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public void renderWheelButton(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (Renderable renderable : this.f_169369_) {
            if (!(renderable instanceof WheelOpenButton)) continue;
            renderable.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public void renderFadingBackground(GuiGraphics graphics, float alpha) {
        alpha = Mth.m_14036_((float)alpha, (float)0.0f, (float)1.0f);
        graphics.m_280168_().m_85836_();
        RenderHelpers.blit(graphics, f_279548_, 0, 0, 0.0f, 0.0f, this.f_96543_, this.f_96544_, 32, 32, Puns.rgbaToInt(0.25f, 0.25f, 0.25f, (Boolean)Config.COMMON.onlyPuns.get() != false ? 1.0f : alpha));
        graphics.m_280168_().m_85849_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.wheel.isActive() && this.wheel.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.wheel.isActive() && this.wheel.mouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.wheel.isActive() && this.wheel.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public static class WheelOfFortune {
        public final PunIntroScreen parent;
        public final int xOffset;
        public final int yOffset;
        public boolean active = false;
        public float wheelAngle = 0.0f;
        public float angularVelocity = 0.0f;
        public float friction = 0.99f;
        public float inertiaMultiplier = 1.8f;
        public boolean grabbing = false;
        public double lastMouseAngle = 0.0;
        public long lastDragTime = 0L;
        public float previousAngularVelocity = 0.0f;
        public boolean hasExceededThreshold = false;
        public boolean showTooSlowMessage = false;
        public boolean wasActiveDrag = false;
        public long tooSlowMessageStart = 0L;
        public float speedThreshold = 70.0f;
        public long stopTime = -1L;
        public boolean fading = false;
        public long fadeStart = -1L;
        public float fadeDuration = 1.5f;
        public float wheelAlpha = 1.0f;
        public boolean hasReacted = false;
        public long burstStart = 0L;
        public final RandomSource burstRandom = RandomSource.m_216327_();
        public static final ResourceLocation LIGHTS_TEX = Puns.identifier("textures/gui/wheel_lights_sheet.png");
        public static final ResourceLocation LIGHTS_OFF_TEX = Puns.identifier("textures/gui/wheel_lights_off.png");
        public static final ResourceLocation WHEEL_BASE_TEX = Puns.identifier("textures/gui/wheel_of_fortune_base.png");
        public static final ResourceLocation WHEEL_TEX = Puns.identifier("textures/gui/wheel_of_fortune.png");
        public static final ResourceLocation HAND_0_TEX = Puns.identifier("textures/gui/hand_0.png");
        public static final ResourceLocation HAND_CW_TEX = Puns.identifier("textures/gui/hand_1.png");
        public static final ResourceLocation HAND_CCW_TEX = Puns.identifier("textures/gui/hand_2.png");
        public static final int WHEEL_SIZE = 254;
        public static final float SLICE_ANGLE = 36.0f;
        public static final float DOT_OFFSET_1 = 5.4f;
        public static final float DOT_OFFSET_2 = 30.6f;
        public static final float CLOSE_DISTANCE = 1.7f;
        public static final float HAND_ANGLE = 270.0f;
        public static final int SPRITE_SIZE = 127;
        public static final int SPRITE_SHEET_SIZE = 508;
        public static final int SPRITE_COLUMNS = 4;
        public static final int SPRITE_ROWS = 4;
        public static final int TOTAL_FRAMES = 16;
        public static final int FRAME_DURATION_MS = 50;
        public long animationStartTime = -1L;
        public long slowdownDelayMs;
        public long slowdownStartTime = -1L;

        public WheelOfFortune(PunIntroScreen parent) {
            this.parent = parent;
            this.xOffset = 0;
            this.yOffset = 0;
        }

        public WheelOfFortune(PunIntroScreen parent, int xOffset, int yOffset) {
            this.parent = parent;
            this.xOffset = xOffset;
            this.yOffset = yOffset;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            if (active) {
                this.wheelAngle = 0.0f;
                this.angularVelocity = 0.0f;
                this.grabbing = false;
                this.hasExceededThreshold = false;
                this.stopTime = -1L;
                this.fading = false;
                this.fadeStart = -1L;
                this.wheelAlpha = 1.0f;
                this.previousAngularVelocity = 0.0f;
                this.slowdownStartTime = -1L;
                this.slowdownDelayMs = RandomSource.m_216327_().m_216332_(0, 1000);
            } else {
                this.hasExceededThreshold = false;
                this.hasReacted = false;
                this.animationStartTime = -1L;
            }
            this.active = active;
        }

        public boolean hasExceededThreshold() {
            return this.hasExceededThreshold;
        }

        public void tick(float partialTicks) {
            if (this.active) {
                long current = System.currentTimeMillis();
                if (this.grabbing) {
                    this.angularVelocity *= 0.3f;
                } else {
                    if (Math.abs(this.angularVelocity) > this.speedThreshold) {
                        this.hasExceededThreshold = true;
                        if (this.slowdownStartTime == -1L) {
                            this.slowdownStartTime = current;
                        }
                    } else if (!this.grabbing && this.wasActiveDrag && !this.hasExceededThreshold && !this.showTooSlowMessage) {
                        this.showTooSlowMessage = true;
                        this.tooSlowMessageStart = System.currentTimeMillis();
                    }
                    this.wheelAngle += this.angularVelocity * partialTicks;
                    this.angularVelocity *= this.friction;
                    if (Math.abs(this.angularVelocity) < 0.1f) {
                        if (Math.abs(this.previousAngularVelocity) >= 0.1f && this.hasExceededThreshold) {
                            this.stopTime = current;
                            this.triggerWheelReaction();
                        }
                        this.angularVelocity = 0.0f;
                    }
                    this.previousAngularVelocity = this.angularVelocity;
                }
                if (this.stopTime > -1L) {
                    if (!this.fading && current - this.stopTime >= 1000L) {
                        this.fading = true;
                        this.fadeStart = current;
                    }
                    if (this.fading) {
                        float fadeDuration = 1.5f;
                        float t = (float)(current - this.fadeStart) / (fadeDuration * 1000.0f);
                        if ((t = Mth.m_14036_((float)t, (float)0.0f, (float)1.0f)) >= 1.0f) {
                            this.wheelAlpha = 0.0f;
                            this.setActive(false);
                        } else {
                            float eased = t * t * t;
                            this.wheelAlpha = 1.0f - eased;
                        }
                    }
                }
                if (this.hasExceededThreshold && this.animationStartTime == -1L) {
                    this.animationStartTime = System.currentTimeMillis();
                }
            }
            this.wasActiveDrag = this.grabbing;
        }

        public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            if (this.stopTime > -1L && this.fading) {
                float fadeDuration = 2.0f;
                float t = (float)(System.currentTimeMillis() - this.fadeStart) / (fadeDuration * 1000.0f);
                if ((t = Mth.m_14036_((float)t, (float)0.0f, (float)1.0f)) >= 1.0f) {
                    this.wheelAlpha = 0.0f;
                    this.setActive(false);
                } else {
                    float eased = t * t * t;
                    this.wheelAlpha = 1.0f - eased;
                }
            }
            int color = Puns.rgbaToInt(1.0f, 1.0f, 1.0f, this.wheelAlpha);
            double centerX = (double)this.parent.f_96543_ / 2.0 + (double)this.xOffset;
            double centerY = (double)this.parent.f_96544_ / 2.0 + (double)this.yOffset;
            int halfSize = 127;
            RenderHelpers.blit(graphics, WHEEL_BASE_TEX, (int)(centerX - (double)halfSize), (int)(centerY - (double)halfSize), 0.0f, 0.0f, 254, 254, 254, 254, color);
            this.drawLights(graphics, centerX, centerY, halfSize, color);
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85837_(centerX, centerY - 0.5, 0.0);
            graphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(-this.wheelAngle));
            RenderHelpers.blit(graphics, WHEEL_TEX, -halfSize, -halfSize, 0.0f, 0.0f, 254, 254, 254, 254, color);
            float iconRadius = 58.0f;
            int iconTexSize = 36;
            float iconScale = 0.75f;
            for (int i = 0; i < 10; ++i) {
                graphics.m_280168_().m_85836_();
                float theta = (float)i * 36.0f - 90.0f;
                double rad = Math.toRadians(theta);
                double posX = (double)iconRadius * Math.cos(rad);
                double posY = (double)iconRadius * Math.sin(rad);
                graphics.m_280168_().m_85837_(posX, posY - 0.5, 0.0);
                graphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(theta + 90.0f));
                graphics.m_280168_().m_85841_(iconScale, iconScale, 1.0f);
                ReactionType rt = ORDERED_REACTIONS_FOR_WHEEL.get(i);
                ResourceLocation iconTex = Puns.identifier("textures/gui/reaction/" + rt.name().toLowerCase() + ".png");
                RenderHelpers.blit(graphics, iconTex, -iconTexSize / 2, -iconTexSize / 2, 0.0f, 0.0f, iconTexSize, iconTexSize, iconTexSize, iconTexSize, color);
                graphics.m_280168_().m_85849_();
            }
            graphics.m_280168_().m_85849_();
            boolean flickHand = false;
            boolean isCCW = this.angularVelocity < 0.0f;
            for (int i = 0; i < 10; ++i) {
                float start = (float)i * 36.0f;
                float dot1 = (start + 5.4f + this.wheelAngle + 360.0f) % 360.0f;
                float dot2 = (start + 30.6f + this.wheelAngle + 360.0f) % 360.0f;
                if (!(Math.abs(dot1 - 270.0f) < 1.7f || Math.abs(dot1 - 270.0f + 360.0f) < 1.7f || Math.abs(dot1 - 270.0f - 360.0f) < 1.7f || Math.abs(dot2 - 270.0f) < 1.7f || Math.abs(dot2 - 270.0f + 360.0f) < 1.7f) && !(Math.abs(dot2 - 270.0f - 360.0f) < 1.7f)) continue;
                flickHand = true;
                break;
            }
            ResourceLocation handTex = flickHand ? (!isCCW ? HAND_CCW_TEX : HAND_CW_TEX) : HAND_0_TEX;
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85837_(centerX, centerY - 0.5, 0.0);
            RenderHelpers.blit(graphics, handTex, -halfSize, -halfSize, 0.0f, 0.0f, 254, 254, 254, 254, color);
            graphics.m_280168_().m_85849_();
            this.drawText(graphics);
            this.tick(partialTicks);
        }

        public void drawText(GuiGraphics graphics) {
            if (this.showTooSlowMessage) {
                MutableComponent msg = Component.m_237115_((String)"puns.screen.spin_too_slow").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
                long elapsed = System.currentTimeMillis() - this.tooSlowMessageStart;
                if (elapsed < 2000L) {
                    graphics.m_280653_(this.parent.f_96547_, (Component)msg, this.parent.f_96543_ / 2, this.parent.f_96544_ / 2 + 105, Puns.rgbaToInt(1.0f, 0.65f, 0.0f, 1.0f));
                } else if (elapsed < 3000L) {
                    float fadeProgress = (float)(elapsed - 2000L) / 1000.0f;
                    float alpha = 1.0f - fadeProgress;
                    graphics.m_280653_(this.parent.f_96547_, (Component)msg, this.parent.f_96543_ / 2, this.parent.f_96544_ / 2 + 105, Puns.rgbaToInt(1.0f, 0.65f, 0.0f, alpha));
                } else {
                    this.showTooSlowMessage = false;
                }
            }
        }

        public void drawLights(GuiGraphics graphics, double centerX, double centerY, int halfSize, int color) {
            if (!this.hasReacted) {
                graphics.m_280168_().m_85836_();
                if (this.active && this.hasExceededThreshold && this.animationStartTime != -1L) {
                    long elapsed = System.currentTimeMillis() - this.animationStartTime;
                    float velocityFactor = Mth.m_14036_((float)Math.abs(this.angularVelocity * 0.02f), (float)0.001f, (float)50.0f);
                    float effectiveFrameDuration = Math.max(1.0f, 50.0f / velocityFactor);
                    int currentFrame = 16 - (int)((float)elapsed / effectiveFrameDuration % 16.0f);
                    int col = currentFrame % 4;
                    int row = currentFrame / 4;
                    int u = col * 254;
                    int v = row * 254;
                    RenderHelpers.blit(graphics, LIGHTS_TEX, (int)(centerX - (double)halfSize), (int)(centerY - (double)halfSize), u, v, 254, 254, 1016, 1016, color);
                } else {
                    RenderHelpers.blit(graphics, LIGHTS_OFF_TEX, (int)(centerX - (double)halfSize), (int)(centerY - (double)halfSize), 0.0f, 0.0f, 254, 254, 254, 254, color);
                }
                graphics.m_280168_().m_85849_();
            }
        }

        public void drawDebugLines(GuiGraphics graphics, float halfSize) {
            float radius = halfSize;
            int color = -464426;
            for (int i = 0; i < 10; ++i) {
                float theta = (float)i * 36.0f;
                float ex = (float)((double)radius * Math.cos(Math.toRadians(theta))) - 5.0f;
                float ey = (float)((double)radius * Math.sin(Math.toRadians(theta)));
                this.drawDebugLine(graphics, 0.0f, 0.0f, ex, ey, color);
            }
        }

        public void drawDebugLine(GuiGraphics graphics, float x1, float y1, float x2, float y2, int color) {
            int dx = (int)(x2 - x1);
            int dy = (int)(y2 - y1);
            int steps = Math.max(Math.abs(dx), Math.abs(dy));
            float xInc = (float)dx / (float)steps;
            float yInc = (float)dy / (float)steps;
            float x = x1;
            float y = y1;
            for (int i = 0; i <= steps; ++i) {
                graphics.m_280509_((int)x, (int)y, (int)x + 1, (int)y + 1, color);
                x += xInc;
                y += yInc;
            }
        }

        public void triggerWheelReaction() {
            if (this.hasReacted) {
                return;
            }
            this.hasReacted = true;
            float effectiveHandAngle = (270.0f - this.wheelAngle + 720.0f - 18.0f) % 360.0f;
            float angleFromRight = ((270.0f - effectiveHandAngle) % 360.0f + 360.0f) % 360.0f;
            int slice = (int)Math.floor(angleFromRight / 36.0f);
            if (slice >= 0 && slice < ORDERED_REACTIONS_FOR_WHEEL.size()) {
                ReactionType reaction = ORDERED_REACTIONS_FOR_WHEEL.get(slice);
                ReactionButton button = this.parent.getButtonForReaction(reaction);
                if (button != null) {
                    this.parent.startAnimation(button);
                    this.parent.wheelButton.f_93623_ = false;
                }
            } else {
                Puns.LOGGER.warn("Wheel landed on invalid slice {}", (Object)slice);
            }
        }

        public boolean isOverWheel(double mouseX, double mouseY) {
            int centerX = this.parent.f_96543_ / 2 + this.xOffset;
            int centerY = this.parent.f_96544_ / 2 + this.yOffset;
            int halfSize = 127;
            return mouseX >= (double)(centerX - halfSize) && mouseX <= (double)(centerX + halfSize) && mouseY >= (double)(centerY - halfSize) && mouseY <= (double)(centerY + halfSize);
        }

        public double computeMouseAngle(double mouseX, double mouseY) {
            int centerX = this.parent.f_96543_ / 2 + this.xOffset;
            int centerY = this.parent.f_96544_ / 2 + this.yOffset;
            return Math.toDegrees(Math.atan2(mouseY - (double)centerY, mouseX - (double)centerX));
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (!this.hasExceededThreshold && button == 0 && this.isOverWheel(mouseX, mouseY)) {
                this.grabbing = true;
                this.lastMouseAngle = this.computeMouseAngle(mouseX, mouseY);
                this.lastDragTime = System.currentTimeMillis();
                return true;
            }
            return false;
        }

        public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
            if (this.grabbing) {
                double currentMouseAngle = this.computeMouseAngle(mouseX, mouseY);
                double deltaAngle = currentMouseAngle - this.lastMouseAngle;
                if (deltaAngle > 180.0) {
                    deltaAngle -= 360.0;
                }
                if (deltaAngle < -180.0) {
                    deltaAngle += 360.0;
                }
                this.wheelAngle -= (float)deltaAngle;
                long now = System.currentTimeMillis();
                float dt = Math.max((float)(now - this.lastDragTime) / 1000.0f, 0.001f);
                if (dt > 0.0f) {
                    this.angularVelocity = -((float)(deltaAngle / (double)dt)) * this.inertiaMultiplier;
                }
                this.lastDragTime = now;
                this.lastMouseAngle = currentMouseAngle;
                return true;
            }
            return false;
        }

        public boolean mouseReleased(double mouseX, double mouseY, int button) {
            if (this.grabbing) {
                this.grabbing = false;
                return true;
            }
            return false;
        }
    }

    public static class ReactionButton
    extends ImageButton {
        public static final ResourceLocation SHOCKWAVE_TEX = Puns.identifier("textures/gui/reaction_press.png");
        public final PunIntroScreen parent;
        public final ReactionType reaction;
        public final Tooltip toolTip;
        public static final float FADE_DELAY = 0.5f;
        public boolean animating = false;
        public boolean isPressedButton = false;
        public float alpha = 1.0f;
        public float scale = 1.0f;
        public float targetScale = 1.0f;
        public long hoverStart;
        public boolean hovering = false;
        public float px;
        public float py;
        public float vx;
        public float vy;
        public float spin;
        public float angle;
        public long animStart;
        public long lastUpdateTime;
        public boolean shockwaveActive = false;
        public long shockwaveStart;
        public float shockwaveScale = 0.0f;
        public float shockwaveAlpha = 1.0f;

        public ReactionButton(PunIntroScreen parent, int x, int y, ResourceLocation texture, String langKey, ReactionType reaction) {
            super(x, y, 24, 24, 0, 0, 24, texture, 24, 24, b -> {
                if (!parent.wheel.isActive()) {
                    parent.startAnimation((ReactionButton)b);
                }
            }, (Component)Component.m_237115_((String)langKey));
            this.toolTip = Tooltip.m_257550_((Component)Component.m_237115_((String)langKey));
            this.m_257544_(this.toolTip);
            this.parent = parent;
            this.reaction = reaction;
            this.px = x;
            this.py = y;
        }

        public ReactionType getReaction() {
            return this.reaction;
        }

        public void beginAnimation(boolean pressed, int pressedX, int pressedY, int screenWidth, int screenHeight) {
            this.animating = true;
            this.isPressedButton = pressed;
            this.lastUpdateTime = this.animStart = System.currentTimeMillis();
            RandomSource r = RandomSource.m_216327_();
            if (pressed) {
                this.vy = 0.0f;
                this.vx = 0.0f;
                this.spin = (r.m_188501_() - 0.5f) * 360.0f;
                this.shockwaveActive = true;
                this.shockwaveStart = System.currentTimeMillis();
                this.shockwaveScale = 0.0f;
                this.shockwaveAlpha = 1.0f;
            } else {
                float dy;
                float dx = this.m_252754_() - pressedX;
                float dist = (float)Math.sqrt(dx * dx + (dy = (float)(this.m_252907_() - pressedY)) * dy);
                if (dist == 0.0f) {
                    dist = 1.0f;
                }
                float dirAngle = (float)Math.atan2(dy, dx);
                float nx = (float)Math.cos(dirAngle += (r.m_188501_() - 0.5f) * 0.3f);
                float ny = (float)Math.sin(dirAngle);
                float delay = dist / 600.0f;
                this.animStart += (long)(delay * 1000.0f);
                float speed = (r.m_188501_() * 10000.0f + 15000.0f) / (dist + 30.0f) + r.m_188501_() * 100.0f - 50.0f;
                this.vx = nx * speed;
                this.vy = ny * speed;
                this.spin = (r.m_188501_() - 0.5f) * 720.0f;
            }
            this.m_257544_(null);
        }

        public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            this.m_252865_((int)this.px);
            this.m_253211_((int)this.py);
            long now = System.currentTimeMillis();
            boolean currentlyHovering = this.m_198029_();
            if (currentlyHovering != this.hovering) {
                this.hovering = currentlyHovering;
                this.hoverStart = now;
                this.targetScale = this.hovering ? 1.25f : 1.0f;
            }
            float elapsed = (float)(now - this.hoverStart) / 200.0f;
            elapsed = Mth.m_14036_((float)elapsed, (float)0.0f, (float)1.0f);
            float easedScale = 1.0f - (float)Math.pow(1.0f - elapsed, 3.0);
            this.scale = Mth.m_14179_((float)easedScale, (float)this.scale, (float)this.targetScale);
            if (this.animating && now < this.animStart) {
                this.px = this.m_252754_();
                this.py = this.m_252907_();
                this.angle = 0.0f;
                this.alpha = 1.0f;
            } else if (this.animating) {
                float eased;
                float dt = (float)(now - this.lastUpdateTime) / 1000.0f;
                this.lastUpdateTime = now;
                float t = (float)(now - this.animStart) / 1000.0f;
                if (t >= 0.5f) {
                    float fadeT = t - 0.5f;
                    float fadeDuration = 1.0f;
                    float progress = Mth.m_14036_((float)(fadeT / fadeDuration), (float)0.0f, (float)1.0f);
                    this.alpha = eased = 1.0f - progress * progress;
                } else {
                    this.alpha = 1.0f;
                }
                if (this.isPressedButton) {
                    this.angle += this.spin * dt;
                    this.px = this.m_252754_();
                    this.py = this.m_252907_();
                    float progress = t / 2.0f;
                    float c1 = 1.70158f;
                    float c3 = c1 + 1.0f;
                    eased = c3 * progress * progress * progress - c1 * progress * progress;
                    float shrinkFactor = 1.0f - eased;
                    this.scale = (this.scale + 0.3f * (float)Math.sin((double)(t * 2.0f) * Math.PI * 3.0)) * shrinkFactor;
                } else {
                    this.vx = (float)((double)this.vx * Math.pow(0.9, dt));
                    this.vy += 980.0f * dt;
                    this.px += this.vx * dt;
                    this.py += this.vy * dt;
                    this.angle += this.spin * dt;
                }
            } else {
                this.px = this.m_252754_();
                this.py = this.m_252907_();
                this.angle = 0.0f;
                this.alpha = 1.0f;
            }
            this.alpha = Mth.m_14036_((float)this.alpha, (float)0.0f, (float)1.0f);
            this.scale = Math.max(this.scale, 0.0f);
            if (this.shockwaveActive) {
                float elapsedSW = (float)(now - this.shockwaveStart) / 1000.0f;
                this.shockwaveScale = 600.0f * elapsedSW / 12.0f;
                this.shockwaveAlpha = 1.0f;
                if (this.shockwaveScale > 20.0f) {
                    float excess = this.shockwaveScale - 20.0f;
                    this.shockwaveAlpha = Math.max(0.0f, 1.0f - excess / 30.0f);
                }
                if (this.shockwaveAlpha <= 0.0f) {
                    this.shockwaveActive = false;
                }
                this.shockwaveAlpha = Mth.m_14036_((float)this.shockwaveAlpha, (float)0.0f, (float)1.0f);
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_(this.px + (float)this.f_93618_ / 2.0f, this.py + (float)this.f_93619_ / 2.0f, 0.0f);
                graphics.m_280168_().m_85841_(this.shockwaveScale, this.shockwaveScale, 1.0f);
                RenderHelpers.blit(graphics, SHOCKWAVE_TEX, -this.f_93618_ / 2, -this.f_93619_ / 2, 0.0f, 0.0f, this.f_93618_, this.f_93619_, this.f_93618_, this.f_93619_, Puns.rgbaToInt(1.0f, 1.0f, 1.0f, this.shockwaveAlpha));
                graphics.m_280168_().m_85849_();
            }
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(this.px + (float)this.f_93618_ / 2.0f, this.py + (float)this.f_93619_ / 2.0f, 0.0f);
            graphics.m_280168_().m_85841_(this.scale, this.scale, 1.0f);
            graphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(this.angle));
            RenderHelpers.blit(graphics, this.f_94223_, -this.f_93618_ / 2, -this.f_93619_ / 2, 0.0f, 0.0f, this.f_93618_, this.f_93619_, this.f_93618_, this.f_93619_, Puns.rgbaToInt(1.0f, 1.0f, 1.0f, this.alpha));
            graphics.m_280168_().m_85849_();
        }

        public boolean isFadedOut() {
            return this.alpha <= 0.0f;
        }
    }

    public static class WheelOpenButton
    extends ImageButton {
        public static final int baseSize = 20;
        public final PunIntroScreen parent;
        public final ResourceLocation onTexture;
        public final ResourceLocation offTexture;
        public final ResourceLocation hoverTexture;
        public final float scale;

        public WheelOpenButton(PunIntroScreen parent, int x, int y, float scale) {
            super(x, y, (int)(20.0f * scale), (int)(20.0f * scale), 0, 0, 20, parent.WHEEL_BUTTON_TEX, 20, 20, b -> {
                if (!parent.wheel.hasExceededThreshold) {
                    boolean newActive = !parent.wheel.isActive();
                    parent.setWheelActive(newActive);
                }
            }, (Component)Component.m_237115_((String)"puns.screen.wheel_button_open"));
            this.parent = parent;
            this.onTexture = parent.WHEEL_BUTTON_TEX;
            this.offTexture = parent.WHEEL_BUTTON_OFF_TEX;
            this.hoverTexture = parent.WHEEL_BUTTON_HOVER_TEX;
            this.scale = scale;
        }

        public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            ResourceLocation tex;
            if (this.parent.fadingOut || this.parent.alpha <= 0.0f || this.parent.wheel.hasExceededThreshold || !this.f_93623_ || this.parent.wheel.hasExceededThreshold) {
                this.m_257544_(null);
            } else {
                this.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)("puns.screen.wheel_button_" + (!this.parent.wheel.isActive() ? "open" : "close")))));
            }
            ResourceLocation resourceLocation = tex = this.f_93623_ && !this.parent.wheel.hasExceededThreshold ? this.onTexture : this.offTexture;
            if (this.f_93623_ && this.m_274382_() && !this.parent.wheel.hasExceededThreshold) {
                tex = this.hoverTexture;
            }
            RenderHelpers.blit(graphics, tex, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, this.f_93618_, this.f_93619_, this.f_93618_, this.f_93619_, Puns.rgbaToInt(1.0f, 1.0f, 1.0f, this.parent.alpha));
            ResourceLocation wheelTex = Puns.identifier("textures/gui/wheel_of_fortune.png");
            int wheelSize = 127;
            int displaySize = (int)(22.0f * this.scale);
            float overlayScale = (float)displaySize / (float)wheelSize;
            float brightness = this.parent.wheel.hasExceededThreshold || !this.f_93623_ || this.parent.wheel.hasExceededThreshold ? 0.25f : 1.0f;
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_((float)this.m_252754_() + (float)this.f_93618_ / 2.0f, (float)this.m_252907_() + (float)this.f_93619_ / 2.0f, 0.0f);
            graphics.m_280168_().m_85841_(overlayScale, overlayScale, 1.0f);
            RenderHelpers.blit(graphics, wheelTex, -wheelSize / 2, -wheelSize / 2, 0.0f, 0.0f, wheelSize, wheelSize, wheelSize, wheelSize, Puns.rgbaToInt(brightness, brightness, brightness, this.parent.alpha));
            graphics.m_280168_().m_85849_();
        }
    }

    public class FloatingPointText {
        public final Component pointText;
        public final Component bubbleText;
        public final ResourceLocation texture;
        public final int startX;
        public final int startY;
        public final long startTime;
        public final int points;
        public final float rotation;
        public float alpha;
        public boolean mayExpire = false;

        public FloatingPointText(int x, int y, ReactionType reaction) {
            this.points = reaction.getPoints();
            this.pointText = Component.m_237113_((String)(this.points > 0 ? "+" + this.points : String.valueOf(this.points))).m_130948_(this.points > 0 ? Style.f_131099_.m_178520_(0x88FF33).m_131136_(Boolean.valueOf(true)) : (this.points < 0 ? Style.f_131099_.m_178520_(0xFF4444).m_131136_(Boolean.valueOf(true)) : Style.f_131099_.m_178520_(0xAAAAAA)));
            this.bubbleText = reaction.getBubble();
            this.texture = this.points > 0 ? Puns.identifier("textures/gui/bubble/positive.png") : (this.points < 0 ? Puns.identifier("textures/gui/bubble/negative.png") : Puns.identifier("textures/gui/bubble/neutral.png"));
            this.startX = x;
            this.startY = y;
            this.startTime = System.currentTimeMillis();
            this.rotation = (RandomSource.m_216327_().m_188501_() - 0.5f) * 60.0f;
        }

        public boolean isExpired() {
            return this.mayExpire && this.alpha <= 0.0f;
        }

        public void render(GuiGraphics graphics, Font font) {
            float t = (float)(System.currentTimeMillis() - this.startTime) / 1000.0f;
            float fadeInDuration = 0.05f;
            float holdDuration = 0.7f;
            float fadeOutDuration = 0.5f;
            float totalDuration = fadeInDuration + holdDuration + fadeOutDuration;
            if (t < fadeInDuration) {
                this.alpha = t / fadeInDuration;
            } else if (t < fadeInDuration + holdDuration) {
                this.alpha = 1.0f;
            } else if (t < totalDuration) {
                float outT = (t - fadeInDuration - holdDuration) / fadeOutDuration;
                float eased = outT * outT * outT;
                this.alpha = 1.0f - eased;
            } else {
                this.alpha = 0.0f;
                this.mayExpire = true;
            }
            this.alpha = Mth.m_14036_((float)this.alpha, (float)0.0f, (float)1.0f);
            float duration = 1.0f;
            float progress = Mth.m_14036_((float)(t / duration), (float)0.0f, (float)1.0f);
            float c1 = 1.70158f;
            float c3 = c1 + 1.0f;
            float eased = 1.0f + c3 * (float)Math.pow(progress - 1.0f, 3.0) + c1 * (float)Math.pow(progress - 1.0f, 2.0);
            float scale = 0.5f + eased * 1.0f;
            float rise = t * 25.0f;
            int y = (int)((float)this.startY - rise);
            if (!this.isExpired()) {
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_((float)this.startX, (float)y, 0.0f);
                graphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(this.rotation));
                graphics.m_280168_().m_85841_(scale, scale, 1.0f);
                int color = Puns.rgbaToInt(1.0f, 1.0f, 1.0f, this.alpha);
                int colorText = Puns.rgbaToInt(1.0f, 1.0f, 0.0f, this.alpha);
                RenderHelpers.blit(graphics, this.texture, -28, -28, 0.0f, 0.0f, 56, 56, 56, 56, color);
                Objects.requireNonNull(font);
                graphics.m_280653_(font, this.bubbleText, 0, -9, colorText);
                graphics.m_280653_(font, this.pointText, 0, 0, color);
                graphics.m_280168_().m_85849_();
            }
        }
    }
}

