/*
 * Decompiled with CFR 0.152.
 */
package puns.client;

import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import puns.Puns;
import puns.client.PunIntroScreen;
import puns.client.RenderHelpers;
import puns.data.PunDataLoader;
import puns.data.ReactionType;

public class PunVoteScreen
extends PunIntroScreen {
    public static final ResourceLocation guiTex = Puns.identifier("textures/gui/pun_vote.png");
    public final int texWidth;
    public final int texHeight;

    public PunVoteScreen(PunDataLoader.PunEntry pun) {
        super(null);
        this.texWidth = 270;
        this.texHeight = 190;
        if (pun == null) {
            pun = new PunDataLoader.PunEntry(-1, "The pun was intended", "Though it was never received");
        }
        this.pun = pun;
        this.stats = Puns.SERVER_PUN_STATS_HANDLER;
        Puns.debugMessage("Opening PunVoteScreen for pun: " + String.valueOf(pun) + ", refreshing stats cache");
        this.stats.asyncFetchStats(this.pun);
        this.wheel = new PunIntroScreen.WheelOfFortune(this);
        this.ticksSinceLastStatsRefresh = 0;
        Puns.debugMessage("Using stats handler: " + Puns.SERVER_PUN_STATS_HANDLER.getClass().getSimpleName());
    }

    @Override
    public boolean canReloadPuns() {
        return false;
    }

    @Override
    protected void m_7856_() {
        int spacing = 30;
        int totalWidth = 5 * spacing;
        int startX = this.f_96543_ / 2 - totalWidth / 2;
        int rowY1 = this.f_96544_ / 2 + 5;
        int rowY2 = rowY1 + 30;
        ArrayList reactions = new ArrayList(ORDERED_REACTIONS_FOR_WHEEL);
        Collections.shuffle(reactions);
        for (int i = 0; i < reactions.size(); ++i) {
            boolean row = i >= 5;
            int col = i % 5;
            int x = startX + col * spacing;
            int y = !row ? rowY1 : rowY2;
            ReactionType reaction = (ReactionType)((Object)reactions.get(i));
            ResourceLocation tex = Puns.identifier("textures/gui/reaction/" + reaction.name().toLowerCase() + ".png");
            String langKey = "puns.reaction." + reaction.name().toLowerCase();
            this.m_142416_((GuiEventListener)new PunIntroScreen.ReactionButton(this, x, y, tex, langKey, reaction));
        }
        int guiX = (this.f_96543_ - 270) / 2;
        int guiY = (this.f_96544_ - 190) / 2 - 10;
        int buttonX = guiX + 270 + 2;
        int buttonY = guiY + 190 - 30;
        float buttonScale = 1.5f;
        this.wheelButton = (PunIntroScreen.WheelOpenButton)this.m_142416_((GuiEventListener)new PunIntroScreen.WheelOpenButton(this, buttonX, buttonY, buttonScale));
    }

    @Override
    public void m_6574_(Minecraft mc, int width, int height) {
        boolean wasActive = this.wheel.isActive();
        float currentAngle = this.wheel.wheelAngle;
        float currentVel = this.wheel.angularVelocity;
        boolean exceeded = this.wheel.hasExceededThreshold;
        super.m_6574_(mc, width, height);
        this.m_169413_();
        this.m_7856_();
        this.setWheelActive(wasActive);
        if (wasActive) {
            this.wheel.wheelAngle = currentAngle;
            this.wheel.angularVelocity = currentVel;
            this.wheel.hasExceededThreshold = exceeded;
        }
    }

    @Override
    public void startAnimation(PunIntroScreen.ReactionButton pressed) {
        int startY;
        int startX;
        if (this.animating) {
            return;
        }
        this.animating = true;
        this.shaking = true;
        this.shakeStart = System.currentTimeMillis();
        this.reactionTime = System.currentTimeMillis();
        for (Renderable widget : this.f_169369_) {
            PunIntroScreen.ReactionButton rb;
            if (!(widget instanceof PunIntroScreen.ReactionButton)) continue;
            rb.beginAnimation((rb = (PunIntroScreen.ReactionButton)widget) == pressed, pressed.m_252754_(), pressed.m_252907_(), this.f_96543_, this.f_96544_);
        }
        if (this.wheelButton != null) {
            this.wheelButton.f_93623_ = false;
        }
        ReactionType reaction = pressed.getReaction();
        this.stats.addReaction(this.pun, reaction);
        this.stats.asyncFetchStats(this.pun);
        if (this.wheel.isActive()) {
            startX = this.f_96543_ / 2;
            startY = this.f_96544_ / 2 + 10;
        } else {
            startX = pressed.m_252754_() + pressed.m_5711_() / 2;
            startY = pressed.m_252907_() + pressed.m_93694_() / 2;
        }
        this.floatingTexts.add(new PunIntroScreen.FloatingPointText(startX, startY, reaction));
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && !this.wheel.hasExceededThreshold()) {
            this.stats.addReaction(this.pun, ReactionType.NEUTRAL);
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        float safetyMargin;
        float buttonsY;
        float maxBottom;
        graphics.m_280168_().m_85836_();
        if (this.title != null && this.title.equals(Component.m_237119_())) {
            graphics.m_280653_(this.f_96547_, this.title, this.f_96543_ / 2, 24, 0xFFFFFF);
        }
        if (this.shaking) {
            float t = (float)(System.currentTimeMillis() - this.shakeStart) / 1000.0f;
            if (t > this.shakeDuration) {
                this.shaking = false;
            } else {
                float progress = t / this.shakeDuration;
                float c1 = 1.70158f;
                float c3 = c1 + 1.0f;
                float eased = c3 * progress * progress * progress - c1 * progress * progress;
                float intensity = 3.0f * (1.0f - eased);
                float offsetX = intensity * (Mth.m_14031_((float)(t * 25.0f)) + Mth.m_14031_((float)(t * 40.0f))) * 0.5f;
                float offsetY = intensity * (Mth.m_14089_((float)(t * 30.0f)) + Mth.m_14089_((float)(t * 45.0f))) * 0.5f;
                graphics.m_280168_().m_252880_(offsetX, offsetY, 0.0f);
            }
        }
        this.renderFadingBackground(graphics, 1.0f);
        MutableComponent questionComp = Component.m_237113_((String)this.pun.question()).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        MutableComponent answerComp = Component.m_237113_((String)this.pun.answer()).m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)));
        float questionScale = 1.4f;
        int questionMaxWidth = (int)((float)this.texWidth * 0.65f);
        List questionLines = this.f_96547_.m_92923_((FormattedText)questionComp, questionMaxWidth);
        Objects.requireNonNull(this.f_96547_);
        int lineHeight = 9;
        float questionBlockHeight = (float)(questionLines.size() * lineHeight) * questionScale + 2.0f;
        float answerScale = 1.175f;
        ArrayList answerLines = this.pun.answer().isEmpty() ? new ArrayList() : this.f_96547_.m_92923_((FormattedText)answerComp, questionMaxWidth);
        int answerLinesCount = answerLines.size();
        float answerBlockHeight = (float)(answerLinesCount * lineHeight) * answerScale;
        float margin = 4.5f;
        float fixedAnswerBottom = (float)this.f_96544_ / 2.0f - 17.0f;
        float virtualAnswerHeight = (float)((answerLinesCount == 0 ? 1 : answerLinesCount) * lineHeight) * answerScale;
        float virtualAnswerTop = fixedAnswerBottom - virtualAnswerHeight;
        float questionBottom = virtualAnswerTop - margin;
        float questionTopEffective = questionBottom - questionBlockHeight;
        int questionStartYPre = (int)(questionTopEffective / questionScale);
        int questionCenterXPre = (int)((float)(this.f_96543_ / 2) / questionScale);
        int maxQuestionWidth = 0;
        for (FormattedCharSequence line : questionLines) {
            maxQuestionWidth = Math.max(maxQuestionWidth, this.f_96547_.m_92724_(line));
        }
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(questionScale, questionScale, 1.0f);
        for (int i = 0; i < questionLines.size(); ++i) {
            FormattedCharSequence line;
            line = (FormattedCharSequence)questionLines.get(i);
            int lineWidth = this.f_96547_.m_92724_(line);
            graphics.m_280649_(this.f_96547_, line, questionCenterXPre - lineWidth / 2, questionStartYPre + i * lineHeight, Puns.rgbaToInt(1.0f, 1.0f, 1.0f, 1.0f), false);
        }
        graphics.m_280168_().m_85849_();
        float actualBottom = questionTopEffective + questionBlockHeight;
        float answerTopEffective = 0.0f;
        if (!this.pun.answer().isEmpty()) {
            answerTopEffective = fixedAnswerBottom - answerBlockHeight;
            int answerStartYPre = (int)(answerTopEffective / answerScale);
            int answerCenterXPre = (int)((float)(this.f_96543_ / 2) / answerScale);
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(answerScale, answerScale, 1.0f);
            for (int i = 0; i < answerLines.size(); ++i) {
                FormattedCharSequence line = (FormattedCharSequence)answerLines.get(i);
                int lineWidth = this.f_96547_.m_92724_(line);
                graphics.m_280649_(this.f_96547_, line, answerCenterXPre - lineWidth / 2, answerStartYPre + i * lineHeight, Puns.rgbaToInt(0.8f, 0.8f, 0.8f, 1.0f), false);
            }
            graphics.m_280168_().m_85849_();
            actualBottom = answerTopEffective + answerBlockHeight;
        }
        if (actualBottom > (maxBottom = (buttonsY = (float)(this.f_96544_ / 2 + 20)) - (safetyMargin = 10.0f))) {
            float excess = actualBottom - maxBottom;
            questionStartYPre = (int)((questionTopEffective -= excess) / questionScale);
        }
        this.renderButtons(graphics, mouseX, mouseY, partialTicks);
        for (Renderable r : this.f_169369_) {
            if (!(r instanceof PunIntroScreen.ReactionButton)) continue;
            PunIntroScreen.ReactionButton rb = (PunIntroScreen.ReactionButton)r;
            rb.m_257544_(this.wheel.isActive() ? null : rb.toolTip);
        }
        this.renderWheelButton(graphics, mouseX, mouseY, partialTicks);
        this.drawApprovalRating(graphics, this.alpha, questionTopEffective, questionBlockHeight, answerTopEffective, answerBlockHeight, questionCenterXPre, maxQuestionWidth, questionScale);
        if (this.wheel.isActive()) {
            this.wheel.tick(partialTicks);
            this.wheel.render(graphics, mouseX, mouseY, partialTicks);
        }
        this.floatingTexts.removeIf(PunIntroScreen.FloatingPointText::isExpired);
        for (PunIntroScreen.FloatingPointText ft : this.floatingTexts) {
            ft.render(graphics, this.f_96547_);
        }
        graphics.m_280168_().m_85849_();
        if (this.animating && !this.fadingOut && this.reactionTime > 0L && System.currentTimeMillis() - this.reactionTime >= 2000L) {
            this.fadingOut = true;
            this.fadeStart = System.currentTimeMillis();
        }
        if (this.fadingOut) {
            this.goToWindow();
        }
    }

    @Override
    public void renderFadingBackground(GuiGraphics graphics, float alpha) {
        graphics.m_280168_().m_85836_();
        int x = (this.f_96543_ - this.texWidth) / 2;
        int y = (this.f_96544_ - this.texHeight) / 2 - 10;
        RenderHelpers.blit(graphics, guiTex, x, y, 0.0f, 0.0f, this.texWidth, this.texHeight, this.texWidth, this.texHeight, Puns.rgbaToInt(1.0f, 1.0f, 1.0f, 1.0f));
        graphics.m_280168_().m_85849_();
    }

    @Override
    public void goToWindow() {
        Minecraft.m_91087_().m_91152_(null);
    }

    @Override
    public void drawApprovalRating(GuiGraphics graphics, float alpha, float questionTopEffective, float questionBlockHeight, float answerTopEffective, float answerBlockHeight, int questionCenterXPre, int maxQuestionWidth, float questionScale) {
        int questionTopYScreen;
        int questionLeftXScreen;
        MutableComponent ratingComp;
        if (this.stats == null) {
            return;
        }
        int rating = this.stats.getApprovalRating(this.pun);
        String emoticon = rating >= 69 && rating < 70 ? "... nice" : (rating >= 75 ? ":)" : (rating <= 25 ? ":(" : ""));
        boolean noRatings = this.stats.getPositivePoints(this.pun) == 0 && this.stats.getNegativePoints(this.pun) == 0;
        MutableComponent noRating = Component.m_237115_((String)"puns.screen.no_rating");
        MutableComponent mutableComponent = ratingComp = noRatings ? noRating : Component.m_237110_((String)"puns.screen.approval", (Object[])new Object[]{rating + "%", emoticon});
        if (this.wheel.isActive()) {
            int centerX = (int)((double)this.f_96543_ / 2.0 + (double)this.wheel.xOffset);
            int centerY = (int)((double)this.f_96544_ / 2.0 + (double)this.wheel.yOffset);
            questionLeftXScreen = centerX - 63 - 14;
            questionTopYScreen = centerY - 84 + 12;
        } else {
            questionLeftXScreen = (int)((float)(questionCenterXPre - maxQuestionWidth / 2) * questionScale);
            questionTopYScreen = (int)questionTopEffective;
        }
        String raw = ratingComp.getString();
        ArrayList<String> lines = new ArrayList<String>();
        if (raw.contains("!")) {
            String[] parts = raw.split("\\!");
            for (int i = 0; i < parts.length; ++i) {
                Object line = parts[i].trim();
                if (((String)line).isEmpty()) continue;
                if (i < parts.length - 1) {
                    line = (String)line + "!";
                }
                lines.add((String)line);
            }
        } else {
            lines.add(raw);
        }
        int n = lines.size();
        Objects.requireNonNull(this.f_96547_);
        int ratingBlockHeight = n * 9;
        int anchorX = questionLeftXScreen - 5;
        int maxLineWidth = 0;
        for (String line : lines) {
            maxLineWidth = Math.max(maxLineWidth, this.f_96547_.m_92895_(line));
        }
        int leftEdge = anchorX - maxLineWidth / 2;
        int rightEdge = anchorX + maxLineWidth / 2;
        if (leftEdge < 0) {
            anchorX += -leftEdge + 2;
        } else if (rightEdge > this.f_96543_) {
            anchorX -= rightEdge - this.f_96543_ + 2;
        }
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)anchorX, (float)questionTopYScreen - 2.0f, 0.0f);
        graphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(-20.0f));
        float f = 1.8f - Mth.m_14154_((float)(Mth.m_14031_((float)((float)(Util.m_137550_() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
        f = f * 100.0f / (float)(this.f_96547_.m_92852_((FormattedText)noRating) + 32);
        graphics.m_280168_().m_85841_(f, f, f);
        int color = Puns.rgbaToInt(1.0f, 1.0f, 0.0f, alpha);
        int y = -ratingBlockHeight;
        for (String line : lines) {
            graphics.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)line), 0, y, color);
            Objects.requireNonNull(this.f_96547_);
            y += 9;
        }
        graphics.m_280168_().m_85849_();
    }
}

