/*
 * Decompiled with CFR 0.152.
 */
package puns.common;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.network.PacketDistributor;
import puns.Puns;
import puns.data.PunDataLoader;
import puns.network.PacketHandler;
import puns.network.PunPackets;

public class PunCommand {
    public static final Pattern PUNCTUATION = Pattern.compile("[^\\w\\s]");
    public static final String NONE_AVAILABLE = "puns.command.no_puns_available";

    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"puns").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"send").executes(PunCommand::sendToAll)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(PunCommand::sendToTargets)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"color", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            for (ChatFormatting f : ChatFormatting.values()) {
                if (!f.m_126664_()) continue;
                builder.suggest(f.m_126666_());
            }
            return builder.buildFuture();
        }).executes(PunCommand::sendToTargetsWithColor)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"bold", (ArgumentType)BoolArgumentType.bool()).executes(PunCommand::sendToTargetsWithStyle)).then(Commands.m_82129_((String)"italic", (ArgumentType)BoolArgumentType.bool()).executes(PunCommand::sendToTargetsWithFullStyle)))))));
        LiteralArgumentBuilder admin = (LiteralArgumentBuilder)Commands.m_82127_((String)"puns").requires(cs -> cs.m_6761_(2));
        admin.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"vote").executes(PunCommand::voteRandomAll)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(PunCommand::voteRandomTargets)).then(Commands.m_82127_((String)"create").then(Commands.m_82129_((String)"question", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"answer", (ArgumentType)StringArgumentType.string()).executes(PunCommand::voteCreateAndOpen))))).then(Commands.m_82127_((String)"find").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> builder.suggest("fuzzy").suggest("exact").buildFuture()).then(Commands.m_82129_((String)"mode", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> builder.suggest("any").suggest("question").suggest("answer").suggest("both").buildFuture()).then(Commands.m_82129_((String)"search", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String type = StringArgumentType.getString((CommandContext)ctx, (String)"type");
            String mode = StringArgumentType.getString((CommandContext)ctx, (String)"mode").toLowerCase();
            if (mode.equals("both")) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Mode 'both' requires two parts: question and answer."));
                return 0;
            }
            String search = PunCommand.stripQuotes(StringArgumentType.getString((CommandContext)ctx, (String)"search"));
            return PunCommand.voteFind((CommandContext<CommandSourceStack>)ctx, type, mode, search, "");
        })))).then(Commands.m_82127_((String)"both").then(Commands.m_82129_((String)"questionPart", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"answerPart", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String type = StringArgumentType.getString((CommandContext)ctx, (String)"type");
            String q = PunCommand.stripQuotes(StringArgumentType.getString((CommandContext)ctx, (String)"questionPart"));
            String a = PunCommand.stripQuotes(StringArgumentType.getString((CommandContext)ctx, (String)"answerPart"));
            return PunCommand.voteFind((CommandContext<CommandSourceStack>)ctx, type, "both", q, a);
        }))))))).then(Commands.m_82127_((String)"byID").then(Commands.m_82129_((String)"id", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(PunCommand::voteById)))));
        admin.then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"question", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"answer", (ArgumentType)StringArgumentType.string()).executes(PunCommand::addCustomPun))));
        admin.then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.string()).executes(PunCommand::removeCustomPun)));
        admin.then(Commands.m_82127_((String)"reload").executes(PunCommand::reloadCommand));
        admin.then(Commands.m_82127_((String)"list").executes(PunCommand::listPuns));
        admin.then(Commands.m_82127_((String)"deleteFile").executes(PunCommand::deleteFile));
        admin.then(Commands.m_82127_((String)"clearFile").executes(PunCommand::clearFile));
        admin.then(Commands.m_82127_((String)"clearCustom").executes(PunCommand::clearCustom));
        dispatcher.register(admin);
    }

    public static int sendToAll(CommandContext<CommandSourceStack> ctx) {
        List targets = ((CommandSourceStack)ctx.getSource()).m_81377_().m_6846_().m_11314_();
        return PunCommand.sendPun((CommandSourceStack)ctx.getSource(), targets, TextColor.m_131266_((int)0xFFFF55), false, false);
    }

    public static int sendToTargets(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91477_(ctx, (String)"target");
        return PunCommand.sendPun((CommandSourceStack)ctx.getSource(), targets, TextColor.m_131266_((int)0xFFFF55), false, false);
    }

    public static int sendToTargetsWithColor(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return PunCommand.sendWithStyle(ctx, "target", "color", false, false);
    }

    public static int sendToTargetsWithStyle(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        boolean bold = BoolArgumentType.getBool(ctx, (String)"bold");
        return PunCommand.sendWithStyle(ctx, "target", "color", bold, false);
    }

    public static int sendToTargetsWithFullStyle(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        boolean bold = BoolArgumentType.getBool(ctx, (String)"bold");
        boolean italic = BoolArgumentType.getBool(ctx, (String)"italic");
        return PunCommand.sendWithStyle(ctx, "target", "color", bold, italic);
    }

    public static int sendWithStyle(CommandContext<CommandSourceStack> ctx, String targetArg, String colorArg, boolean bold, boolean italic) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91477_(ctx, (String)targetArg);
        String colorName = StringArgumentType.getString(ctx, (String)colorArg);
        ChatFormatting fmt = ChatFormatting.m_126657_((String)colorName);
        if (fmt == null || !fmt.m_126664_()) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("Invalid color: " + colorName)));
            return 0;
        }
        return PunCommand.sendPun((CommandSourceStack)ctx.getSource(), targets, TextColor.m_131266_((int)fmt.m_126665_()), bold, italic);
    }

    public static int voteRandomAll(CommandContext<CommandSourceStack> ctx) {
        List targets = ((CommandSourceStack)ctx.getSource()).m_81377_().m_6846_().m_11314_();
        PunCommand.openVoteForPlayers((Collection<ServerPlayer>)targets, PunDataLoader.getRandomPun(RandomSource.m_216327_()), (CommandSourceStack)ctx.getSource());
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Started random pun voting for all players."), true);
        PunCommand.reloadPuns(ctx);
        return targets.size();
    }

    public static int voteRandomTargets(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91477_(ctx, (String)"targets");
        PunCommand.openVoteForPlayers((Collection<ServerPlayer>)targets, PunDataLoader.getRandomPun(RandomSource.m_216327_()), (CommandSourceStack)ctx.getSource());
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Started random pun voting for " + targets.size() + " players.")), true);
        PunCommand.reloadPuns(ctx);
        return targets.size();
    }

    public static int voteCreateAndOpen(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91477_(ctx, (String)"targets");
        String question = StringArgumentType.getString(ctx, (String)"question");
        String answer = StringArgumentType.getString(ctx, (String)"answer");
        PunDataLoader.addCustomPun(question, answer);
        PunCommand.reloadPuns(ctx);
        List<PunDataLoader.PunEntry> matches = PunDataLoader.getPuns().stream().filter(p -> p.question().equals(question) && p.answer().equals(answer)).toList();
        PunCommand.openVoteForPlayers((Collection<ServerPlayer>)targets, matches.get(0), (CommandSourceStack)ctx.getSource());
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Created pun and started vote for " + targets.size() + " players: \"" + question + "\" --> \"" + answer + "\"")), true);
        return targets.size();
    }

    public static int voteFindAndOpen(CommandContext<CommandSourceStack> ctx, boolean answerOnly) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91477_(ctx, (String)"targets");
        String search = StringArgumentType.getString(ctx, (String)(answerOnly ? "answerText" : "search")).toLowerCase();
        List<PunDataLoader.PunEntry> matches = PunDataLoader.getPuns().stream().filter(p -> answerOnly ? p.answer().toLowerCase().contains(search) : p.question().toLowerCase().contains(search) || p.answer().toLowerCase().contains(search)).toList();
        if (matches.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("No pun found containing \"" + search + "\"")));
            return 0;
        }
        PunDataLoader.PunEntry chosen = matches.size() == 1 ? matches.get(0) : matches.get(RandomSource.m_216327_().m_188503_(matches.size()));
        PunCommand.openVoteForPlayers((Collection<ServerPlayer>)targets, chosen, (CommandSourceStack)ctx.getSource());
        String extra = matches.size() > 1 ? " (random from " + matches.size() + " matches)" : "";
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Found pun" + extra + " and started vote for " + targets.size() + " players: " + chosen.question() + " --> " + chosen.answer())), true);
        PunCommand.reloadPuns(ctx);
        return targets.size();
    }

    public static int voteById(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91477_(ctx, (String)"targets");
        PunDataLoader.PunEntry pun = PunDataLoader.getPun(IntegerArgumentType.getInteger(ctx, (String)"id"));
        PunCommand.openVoteForPlayers((Collection<ServerPlayer>)targets, pun, (CommandSourceStack)ctx.getSource());
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Started vote with punId=" + pun.id() + " for " + targets.size() + " players.")), true);
        PunCommand.reloadPuns(ctx);
        return targets.size();
    }

    public static void openVoteForPlayers(Collection<ServerPlayer> players, int punId, CommandSourceStack source) {
        PunCommand.openVoteForPlayers(players, PunDataLoader.getPun(punId), source);
    }

    public static void openVoteForPlayers(Collection<ServerPlayer> players, PunDataLoader.PunEntry pun, CommandSourceStack source) {
        for (ServerPlayer p : players) {
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> p), (Object)new PunPackets.OpenVoteScreenPayload(pun));
        }
    }

    public static int addCustomPun(CommandContext<CommandSourceStack> ctx) {
        String q = StringArgumentType.getString(ctx, (String)"question");
        String a = StringArgumentType.getString(ctx, (String)"answer");
        PunDataLoader.addCustomPun(q, a);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Added custom pun: " + q + " -> " + a)), true);
        PunCommand.reloadPuns(ctx);
        return 1;
    }

    public static int removeCustomPun(CommandContext<CommandSourceStack> ctx) {
        int id = IntegerArgumentType.getInteger(ctx, (String)"id");
        boolean removed = PunDataLoader.removeCustomPun(id);
        if (removed) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Removed custom pun with ID: " + id)), true);
            PunCommand.reloadPuns(ctx);
        } else {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("No custom pun found with ID: " + id)));
        }
        return removed ? 1 : 0;
    }

    public static int reloadCommand(CommandContext<CommandSourceStack> ctx) {
        PunCommand.reloadPuns(ctx, true);
        return 1;
    }

    public static int listPuns(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        List<PunDataLoader.PunEntry> puns = PunDataLoader.getPuns();
        try {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PunPackets.ListPunsPayload(puns));
        }
        catch (CommandSyntaxException e) {
            Puns.LOGGER.info("Server Active Puns (" + puns.size() + ")");
            for (PunDataLoader.PunEntry entry : puns) {
                Puns.LOGGER.info("[ID: " + String.valueOf(entry) + "] " + entry.question() + " -> " + entry.answer());
            }
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("List of " + puns.size() + " puns printed to server log.")), true);
        }
        return puns.size();
    }

    public static int deleteFile(CommandContext<CommandSourceStack> ctx) {
        boolean deleted = PunDataLoader.deleteAuthoritativeFile();
        if (deleted) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Deleted puns.json. Falling back to bundled/custom."), true);
            PunCommand.reloadPuns(ctx);
        } else {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Failed to delete puns.json."));
        }
        return deleted ? 1 : 0;
    }

    public static int clearFile(CommandContext<CommandSourceStack> ctx) {
        boolean cleared = PunDataLoader.clearAuthoritativeFile();
        if (cleared) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Cleared puns.json."), true);
            PunCommand.reloadPuns(ctx);
        } else {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Failed to clear puns.json."));
        }
        return cleared ? 1 : 0;
    }

    public static int clearCustom(CommandContext<CommandSourceStack> ctx) {
        boolean cleared = PunDataLoader.clearAllCustomPuns();
        if (cleared) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Cleared all custom puns."), true);
            PunCommand.reloadPuns(ctx);
        } else {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Failed to clear custom_puns.json."));
        }
        return cleared ? 1 : 0;
    }

    public static void reloadPuns(CommandContext<CommandSourceStack> ctx) {
        PunCommand.reloadPuns(ctx, false);
    }

    public static void reloadPuns(CommandContext<CommandSourceStack> ctx, boolean writeMessage) {
        PunDataLoader.reloadPuns();
        if (writeMessage) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Reloaded puns. Active size: " + PunDataLoader.ACTIVE_PUNS.size())), true);
        }
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new PunPackets.SyncPunsPayload(PunDataLoader.ACTIVE_PUNS));
    }

    public static int sendPun(CommandSourceStack source, Collection<ServerPlayer> targets, TextColor textColor, boolean bold, boolean italic) {
        Object object;
        PunDataLoader.PunEntry pun = PunDataLoader.getRandomPun(RandomSource.m_216327_());
        if (pun == null) {
            source.m_81352_((Component)Component.m_237115_((String)NONE_AVAILABLE));
            return 0;
        }
        String text = pun.answer().isEmpty() ? pun.question() : pun.question() + " - " + pun.answer();
        Style style = Style.f_131099_.m_131148_(textColor).m_131136_(Boolean.valueOf(bold)).m_131155_(Boolean.valueOf(italic));
        MutableComponent msg = Component.m_237113_((String)text).m_6270_(style);
        if (targets.isEmpty() && (object = source.m_81373_()) instanceof ServerPlayer) {
            ServerPlayer self = (ServerPlayer)object;
            self.m_213846_((Component)msg);
        } else {
            for (ServerPlayer p : targets) {
                p.m_213846_((Component)msg);
            }
        }
        return 1;
    }

    public static String stripOptionalQuotes(String input) {
        if (input == null || input.isEmpty()) {
            return "";
        }
        String trimmed = input.trim();
        if (trimmed.length() >= 2 && trimmed.charAt(0) == '\"' && trimmed.charAt(trimmed.length() - 1) == '\"') {
            return trimmed.substring(1, trimmed.length() - 1);
        }
        return trimmed;
    }

    public static int voteFindAndOpen(CommandContext<CommandSourceStack> ctx, FindMode mode) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91477_(ctx, (String)"targets");
        SearchQuery query = switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case FindMode.ANY -> {
                String raw = StringArgumentType.getString(ctx, (String)"search");
                String text = PunCommand.stripOptionalQuotes(raw);
                yield new SearchQuery(text, text);
            }
            case FindMode.QUESTION_ONLY -> {
                String raw = StringArgumentType.getString(ctx, (String)"questionText");
                String text = PunCommand.stripOptionalQuotes(raw);
                yield new SearchQuery(text, "");
            }
            case FindMode.ANSWER_ONLY -> {
                String raw = StringArgumentType.getString(ctx, (String)"answerText");
                String text = PunCommand.stripOptionalQuotes(raw);
                yield new SearchQuery("", text);
            }
            case FindMode.EXACT -> {
                String rawQ = StringArgumentType.getString(ctx, (String)"questionPart");
                String rawA = StringArgumentType.getString(ctx, (String)"answerPart");
                yield new SearchQuery(PunCommand.stripOptionalQuotes(rawQ), PunCommand.stripOptionalQuotes(rawA));
            }
        };
        if (query.question.isEmpty() && query.answer.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"At least one search term must be provided."));
            return 0;
        }
        List<PunDataLoader.PunEntry> matches = PunDataLoader.getPuns().stream().filter(p -> {
            String q = p.question().toLowerCase().replace(",", "");
            String a = p.answer().toLowerCase().replace(",", "");
            String queryQ = query.question.replace(",", "");
            String queryA = query.answer.replace(",", "");
            boolean qMatch = queryQ.isEmpty() || q.contains(queryQ);
            boolean aMatch = queryA.isEmpty() || a.contains(queryA);
            return switch (mode) {
                default -> throw new IncompatibleClassChangeError();
                case FindMode.ANY -> {
                    if (qMatch || aMatch) {
                        yield true;
                    }
                    yield false;
                }
                case FindMode.QUESTION_ONLY -> qMatch;
                case FindMode.ANSWER_ONLY -> aMatch;
                case FindMode.EXACT -> qMatch && aMatch;
            };
        }).toList();
        if (matches.isEmpty()) {
            String desc = switch (mode) {
                default -> throw new IncompatibleClassChangeError();
                case FindMode.ANY -> "containing \"" + (query.question.isEmpty() ? query.answer : query.question) + "\"";
                case FindMode.QUESTION_ONLY -> "with question containing \"" + query.question + "\"";
                case FindMode.ANSWER_ONLY -> "with answer containing \"" + query.answer + "\"";
                case FindMode.EXACT -> "matching question \"" + query.question + "\" and answer \"" + query.answer + "\"";
            };
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("No pun found " + desc + ".")));
            return 0;
        }
        PunDataLoader.PunEntry chosen = matches.size() == 1 ? matches.get(0) : matches.get(RandomSource.m_216327_().m_188503_(matches.size()));
        PunCommand.openVoteForPlayers((Collection<ServerPlayer>)targets, chosen, (CommandSourceStack)ctx.getSource());
        String extra = matches.size() > 1 ? " (randomly selected from " + matches.size() + " matches)" : "";
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Pun found" + extra + " --> vote started for " + targets.size() + " player(s): \"" + chosen.question() + "\" --> \"" + chosen.answer() + "\"")), true);
        PunCommand.reloadPuns(ctx);
        return targets.size();
    }

    public static int voteFindFlexible(CommandContext<CommandSourceStack> ctx, String modeStr, String part1, String part2) throws CommandSyntaxException {
        FindMode effectiveMode;
        SearchQuery query;
        Collection targets = EntityArgument.m_91477_(ctx, (String)"targets");
        switch (modeStr) {
            case "any": {
                if (!part2.isEmpty()) {
                    ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Mode 'any' accepts only one search term."));
                    return 0;
                }
                query = new SearchQuery(part1, part1);
                effectiveMode = FindMode.ANY;
                break;
            }
            case "question": {
                if (!part2.isEmpty()) {
                    ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Mode 'question' accepts only one search term."));
                    return 0;
                }
                query = new SearchQuery(part1, "");
                effectiveMode = FindMode.QUESTION_ONLY;
                break;
            }
            case "answer": {
                if (!part2.isEmpty()) {
                    ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Mode 'answer' accepts only one search term."));
                    return 0;
                }
                query = new SearchQuery("", part1);
                effectiveMode = FindMode.ANSWER_ONLY;
                break;
            }
            case "both": {
                query = new SearchQuery(part1, part2);
                effectiveMode = FindMode.EXACT;
                break;
            }
            default: {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("Invalid search mode: " + modeStr + ". Use any|question|answer|both")));
                return 0;
            }
        }
        return PunCommand.voteFindWithQuery(ctx, targets, query, effectiveMode);
    }

    public static int voteFindWithQuery(CommandContext<CommandSourceStack> ctx, Collection<ServerPlayer> targets, SearchQuery query, FindMode mode) {
        if (query.question.isEmpty() && query.answer.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"At least one search term must be provided."));
            return 0;
        }
        List<PunDataLoader.PunEntry> matches = PunDataLoader.getPuns().stream().filter(p -> {
            String q = p.question().toLowerCase().replace(",", "");
            String a = p.answer().toLowerCase().replace(",", "");
            String sq = query.question.replace(",", "");
            String sa = query.answer.replace(",", "");
            boolean qMatch = sq.isEmpty() || q.contains(sq);
            boolean aMatch = sa.isEmpty() || a.contains(sa);
            return switch (mode) {
                default -> throw new IncompatibleClassChangeError();
                case FindMode.ANY -> {
                    if (qMatch || aMatch) {
                        yield true;
                    }
                    yield false;
                }
                case FindMode.QUESTION_ONLY -> qMatch;
                case FindMode.ANSWER_ONLY -> aMatch;
                case FindMode.EXACT -> qMatch && aMatch;
            };
        }).toList();
        if (matches.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"No pun found matching the criteria."));
            return 0;
        }
        PunDataLoader.PunEntry chosen = matches.size() == 1 ? matches.get(0) : matches.get(RandomSource.m_216327_().m_188503_(matches.size()));
        PunCommand.openVoteForPlayers(targets, chosen, (CommandSourceStack)ctx.getSource());
        String extra = matches.size() > 1 ? " (chosen from " + matches.size() + " matches)" : "";
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Pun found" + extra + " --> vote opened for " + targets.size() + " player(s): \"" + chosen.question() + "\" --> \"" + chosen.answer() + "\"")), true);
        PunCommand.reloadPuns(ctx);
        return targets.size();
    }

    public static int voteFind(CommandContext<CommandSourceStack> ctx, String searchType, String modeStr, String part1, String part2) throws CommandSyntaxException {
        FindMode mode;
        Collection targets = EntityArgument.m_91477_(ctx, (String)"targets");
        boolean isFuzzy = searchType.equals("fuzzy");
        boolean isExact = searchType.equals("exact");
        if (!isFuzzy && !isExact) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Search type must be 'fuzzy' or 'exact'."));
            return 0;
        }
        switch (modeStr) {
            case "any": {
                FindMode findMode = FindMode.ANY;
                break;
            }
            case "question": {
                FindMode findMode = FindMode.QUESTION_ONLY;
                break;
            }
            case "answer": {
                FindMode findMode = FindMode.ANSWER_ONLY;
                break;
            }
            case "both": {
                FindMode findMode = FindMode.EXACT;
                break;
            }
            default: {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("Invalid mode: " + modeStr)));
                FindMode findMode = mode = null;
            }
        }
        if (mode == null) {
            return 0;
        }
        SearchQuery query = switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case FindMode.ANY -> new SearchQuery(part1, part1);
            case FindMode.QUESTION_ONLY -> new SearchQuery(part1, "");
            case FindMode.ANSWER_ONLY -> new SearchQuery("", part1);
            case FindMode.EXACT -> new SearchQuery(part1, part2);
        };
        List<PunDataLoader.PunEntry> matches = PunDataLoader.getPuns().stream().filter(p -> {
            String questionLower = p.question().toLowerCase();
            String answerLower = p.answer().toLowerCase();
            String sq = isExact ? query.question.toLowerCase() : PunCommand.normalizeForFuzzy(query.question);
            String sa = isExact ? query.answer.toLowerCase() : PunCommand.normalizeForFuzzy(query.answer);
            String qFuzzy = PunCommand.normalizeForFuzzy(p.question());
            String aFuzzy = PunCommand.normalizeForFuzzy(p.answer());
            boolean qContains = sq.isEmpty() || qFuzzy.contains(sq);
            boolean aContains = sa.isEmpty() || aFuzzy.contains(sa);
            boolean qExact = sq.isEmpty() || questionLower.equals(sq);
            boolean aExact = sa.isEmpty() || answerLower.equals(sa);
            return switch (mode) {
                default -> throw new IncompatibleClassChangeError();
                case FindMode.ANY -> {
                    if (qContains || aContains) {
                        yield true;
                    }
                    yield false;
                }
                case FindMode.QUESTION_ONLY -> {
                    if (isExact) {
                        yield qExact;
                    }
                    yield qContains;
                }
                case FindMode.ANSWER_ONLY -> {
                    if (isExact) {
                        yield aExact;
                    }
                    yield aContains;
                }
                case FindMode.EXACT -> {
                    if (isExact) {
                        if (qExact && aExact) {
                            yield true;
                        }
                        yield false;
                    }
                    yield qContains && aContains;
                }
            };
        }).toList();
        if (matches.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("No pun found with " + searchType + " " + modeStr + " search.")));
            return 0;
        }
        PunDataLoader.PunEntry chosen = matches.size() == 1 ? matches.get(0) : matches.get(RandomSource.m_216327_().m_188503_(matches.size()));
        PunCommand.openVoteForPlayers((Collection<ServerPlayer>)targets, chosen, (CommandSourceStack)ctx.getSource());
        String typeLabel = isFuzzy ? "fuzzy" : "exact";
        String extra = matches.size() > 1 ? " (selected from " + matches.size() + ")" : "";
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("[" + typeLabel.toUpperCase() + "] Found pun" + extra + ": \"" + chosen.question() + "\" --> \"" + chosen.answer() + "\"")), true);
        return targets.size();
    }

    public static String normalizeForFuzzy(String s) {
        return PUNCTUATION.matcher(s.toLowerCase()).replaceAll("").trim();
    }

    public static String normalizeForExact(String s) {
        return s.toLowerCase();
    }

    public static String stripQuotes(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        if ((s = s.trim()).startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'")) {
            s = s.substring(1, s.length() - 1);
        }
        return s.trim();
    }

    public static enum FindMode {
        ANY,
        QUESTION_ONLY,
        ANSWER_ONLY,
        EXACT;

    }

    public static final class SearchQuery {
        final String question;
        final String answer;

        SearchQuery(String question, String answer) {
            this.question = question.trim().toLowerCase();
            this.answer = answer.trim().toLowerCase();
        }
    }
}

